/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.datadosen.util.IO;

public class StringCodec {
    private static final byte[] UTF16BESignature;
    private static final byte[] UTF16LESignature;
    private static final byte[] UTF8Signature;
    private boolean addSignature = false;
    private String detectedEncoding;
    protected static Map encMap;

    static {
        UTF8Signature = new byte[]{-17, -69, -65};
        UTF16BESignature = new byte[]{-2, -1};
        UTF16LESignature = new byte[]{-1, -2};
        encMap = new HashMap();
        encMap.put("UTF-8", UTF8Signature);
        encMap.put("UTF8", UTF8Signature);
        encMap.put("UTF-16BE", UTF16BESignature);
        encMap.put("UTF-16LE", UTF16LESignature);
    }

    public String decode(byte[] buf, int offset, int length, String defaultEncoding) throws UnsupportedEncodingException {
        if (defaultEncoding == null) {
            defaultEncoding = System.getProperty("file.encoding");
        }
        this.detectedEncoding = null;
        Iterator it = encMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            byte[] signature = (byte[])e2.getValue();
            if (!StringCodec.startsWith(buf, offset, signature)) continue;
            this.detectedEncoding = (String)e2.getKey();
            return new String(buf, signature.length + offset, length - signature.length, this.detectedEncoding);
        }
        if (StringCodec.isUTF8(buf, offset, length)) {
            this.detectedEncoding = "UTF-8";
            return new String(buf, offset, length, this.detectedEncoding);
        }
        return new String(buf, 0, length, defaultEncoding);
    }

    public String decode(byte[] buf, int offset, int length) throws UnsupportedEncodingException {
        return this.decode(buf, offset, length, null);
    }

    public String decode(byte[] buf, String defaultEncoding) throws UnsupportedEncodingException {
        return this.decode(buf, 0, buf.length, defaultEncoding);
    }

    public String decode(byte[] buf) throws UnsupportedEncodingException {
        return this.decode(buf, 0, buf.length, null);
    }

    public byte[] encode(String s2) throws UnsupportedEncodingException {
        return this.encode(s2, null);
    }

    public byte[] encode(String s2, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        byte[] buf = s2.getBytes(encoding);
        this.detectedEncoding = encoding;
        if (!this.addSignature) {
            return buf;
        }
        byte[] prefix = (byte[])encMap.get(encoding);
        if (prefix == null) {
            return buf;
        }
        byte[] finalBuf = new byte[prefix.length + buf.length];
        System.arraycopy(prefix, 0, finalBuf, 0, prefix.length);
        System.arraycopy(buf, 0, finalBuf, prefix.length, buf.length);
        return finalBuf;
    }

    public String getDetectedEncoding() {
        return this.detectedEncoding;
    }

    public boolean isAddSignature() {
        return this.addSignature;
    }

    public static boolean isEncodable(String s2, String encoding) throws UnsupportedEncodingException {
        StringCodec codec = new StringCodec();
        byte[] buf = codec.encode(s2, encoding);
        String s22 = codec.decode(buf, encoding);
        return s22.equals(s2);
    }

    public static boolean isUTF8(byte[] buf, int offset, int length) {
        if (StringCodec.startsWith(buf, offset, UTF8Signature)) {
            return true;
        }
        boolean yesItIs = false;
        int i2 = offset;
        while (i2 < offset + length) {
            if ((buf[i2] & 0xC0) == 192) {
                int nBytes = 2;
                while (nBytes < 8) {
                    int mask = 1 << 7 - nBytes;
                    if ((buf[i2] & mask) == 0) break;
                    ++nBytes;
                }
                int j2 = 1;
                while (j2 < nBytes) {
                    if (i2 + j2 >= length || (buf[i2 + j2] & 0xC0) != 128) {
                        return false;
                    }
                    ++j2;
                }
                yesItIs = true;
            }
            ++i2;
        }
        return yesItIs;
    }

    public static boolean isUTF8(byte[] buf) {
        return StringCodec.isUTF8(buf, 0, buf.length);
    }

    public static void main(String[] args) throws Exception {
        StringCodec codec = new StringCodec();
        byte[] b2 = codec.encode("Blaa", "ISO-8859-1");
        byte[] b22 = codec.encode("Blaa", "UTF-8");
        byte[] b3 = codec.encode("Blaa", "UTF-16BE");
        byte[] b4 = codec.encode("Blaa", "UTF-16LE");
        byte[] b5 = codec.encode("", "UTF-16LE");
        System.out.println("b is " + codec.decode(b2, "ISO-8859-1") + " Detected encoding is " + codec.getDetectedEncoding());
        System.out.println("b2 is " + codec.decode(b22, "ISO-8859-1") + " Detected encoding is " + codec.getDetectedEncoding());
        System.out.println("b3 is " + codec.decode(b3, "ISO-8859-1") + " Detected encoding is " + codec.getDetectedEncoding());
        System.out.println("b4 is " + codec.decode(b4, "ISO-8859-1") + " Detected encoding is " + codec.getDetectedEncoding());
        System.out.println("b5 is " + codec.decode(b5, "ISO-8859-1") + " Detected encoding is " + codec.getDetectedEncoding());
        StringCodec.testEncode("\ufffdkermark", "ASCII");
        StringCodec.testEncode("Akermark", "ASCII");
        StringCodec.testEncode("\ufffdkermark", "ISO-8859-1");
        if (args.length > 0) {
            File f2 = new File(args[0]);
            byte[] buf = IO.readBytes(f2);
            System.out.println(f2.getAbsolutePath() + " is UTF-8:" + StringCodec.isUTF8(buf));
        }
    }

    public void setAddSignature(boolean addIt) {
        this.addSignature = addIt;
    }

    private static boolean startsWith(byte[] buf, int offset, byte[] prefix) {
        int i2 = 0;
        while (i2 < prefix.length) {
            if (i2 + offset == buf.length || buf[i2 + offset] != prefix[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static void testEncode(String s2, String encoding) throws UnsupportedEncodingException {
        if (StringCodec.isEncodable(s2, encoding)) {
            System.out.println(s2 + " can be encoded to " + encoding);
        } else {
            System.out.println(s2 + " can not be encoded to " + encoding);
        }
    }
}

