/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import se.datadosen.util.CharBuffer;

public class Template {
    CharBuffer buffer;
    private LinkedList data = new LinkedList();
    final char keyPrefix;
    final int sizeHint;

    public Template(String ts, char keyPrefix) {
        this.keyPrefix = keyPrefix;
        this.sizeHint = ts.length();
        int index = 0;
        int lastIndex = 0;
        while ((index = ts.indexOf(keyPrefix, index)) > 0) {
            this.data.add(ts.substring(lastIndex, index));
            int keyLength = this.getKeyLength(ts, ++index);
            this.data.add(new Key(ts.substring(index, index + keyLength)));
            lastIndex = index += keyLength;
        }
        this.data.add(ts.substring(lastIndex));
    }

    public Template(String ts) {
        this(ts, '$');
    }

    private int getKeyLength(String s2, int index) {
        int i2 = index;
        while (i2 < s2.length()) {
            char c2 = s2.charAt(i2);
            if (!Character.isJavaIdentifierPart(c2) && (c2 != '.' || i2 + 1 >= s2.length() || !Character.isJavaIdentifierPart(s2.charAt(i2 + 1)))) break;
            ++i2;
        }
        return i2 - index;
    }

    public static void main(String[] args) {
        String ts = "This is a simple text with a $style and a $styleFile variable. We also have $text.somekey $text.blaj. Here comes a $style variable again.$styleFil";
        Template testTemplate = new Template(ts, '$');
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("style", "[This is an expanded style variable]");
        mapping.put("styleFile", "[This is an expanded styleFile variable]");
        mapping.put("text.somekey", "[This is an expanded text]");
        System.out.println(testTemplate.toString(mapping));
        Template t2 = new Template("This is a string without any mappings", '$');
        System.out.println(t2.toString(mapping));
    }

    public String toString(Map mapping) {
        if (this.data.size() == 1 && this.data.getFirst() instanceof String) {
            return (String)this.data.getFirst();
        }
        StringBuffer buf = new StringBuffer(this.sizeHint);
        Iterator it = this.data.iterator();
        while (it.hasNext()) {
            Object o2 = it.next();
            if (o2 instanceof String) {
                buf.append((String)o2);
                continue;
            }
            Key key = (Key)o2;
            if (mapping.containsKey(key.name)) {
                buf.append(mapping.get(key.name));
                continue;
            }
            buf.append(this.keyPrefix);
            buf.append(key.name);
        }
        return buf.toString();
    }

    static class Key {
        String name;

        public Key(String name) {
            this.name = name;
        }
    }
}

