/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util.httpClient;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.datadosen.util.httpClient.Http;
import se.datadosen.util.httpClient.HttpResponse;
import se.datadosen.util.httpClient.Log;
import se.datadosen.util.httpClient.ModuleException;

public class HttpConnection {
    private String encoding;
    private String host;
    private int port;
    private String proto;
    private static int timeout = 0;
    private String uri;

    public HttpConnection(URL url) {
        this.proto = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.proto.equalsIgnoreCase("https") ? 443 : 80;
        }
        this.uri = url.getFile();
    }

    public HttpResponse Post(Map data) throws IOException, ModuleException {
        return this.Post(data, new HashMap());
    }

    public HttpResponse Post(Map data, Map headers) throws IOException, ModuleException {
        return this.Post("application/x-www-form-urlencoded", HttpConnection.encodeFormData(data), headers);
    }

    public HttpResponse Post(String contentType, String data, Map headers) throws IOException, ModuleException {
        String request = this.buildPost(this.uri, headers, contentType, data);
        Log.DEBUG("request is:\n" + request);
        Socket sock = Http.makeSocket(this.proto, this.host, this.port);
        sock.setSoTimeout(timeout);
        Log.DEBUG("made socket\n");
        if (contentType.indexOf("charset") != -1) {
            this.encoding = contentType.substring(contentType.indexOf(61, contentType.indexOf("charset")) + 1);
        }
        this.sendRequest(sock, request, this.encoding);
        Log.DEBUG("request sent\n");
        HttpResponse response = Http.readResponse(sock.getInputStream());
        sock.close();
        return response;
    }

    private String buildPost(String uri, Map headers, String contentType, String content) {
        String result = "POST " + uri + " HTTP/1.1\r\n";
        String[] mandatory = new String[]{"Accept", "*/*", "Content-Type", contentType, "Accept-Encoding", "deflate, gzip, x-gzip, compress, x-compress", "User-Agent", "Mozilla/4.0 (compatible; JAlbum)", "Host", this.host, "Content-Length", String.valueOf(content.length()), "Connection", "Close", "Cache-Control", "no-cache"};
        int i2 = 0;
        while (i2 < mandatory.length) {
            headers = HttpConnection.mandatoryHeader(headers, mandatory[i2], mandatory[i2 + 1]);
            i2 += 2;
        }
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            result = result + e2.getKey() + ": " + e2.getValue() + "\r\n";
        }
        result = result + "\r\n" + content;
        return result;
    }

    static String encodeFormData(Map data) {
        String result = "";
        Iterator it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            if (!result.equals("")) {
                result = result + "&";
            }
            result = result + URLEncoder.encode(e2.getKey().toString()) + "=" + URLEncoder.encode(e2.getValue().toString());
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("http://localhost/www.datadosen.se/jalbum/signuptest.jsp");
        HttpConnection conn = new HttpConnection(url);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("foo", "bar");
        data.put("firstName", "David Ekholm \u00e5\u00e4\u00f6");
        HttpResponse resp = conn.Post(data);
        System.out.println(resp.getContentAsString());
    }

    static Map mandatoryHeader(Map headers, String name, String value) {
        if (headers.containsKey(name)) {
            return headers;
        }
        headers.put(name, value);
        return headers;
    }

    private void sendRequest(Socket sock, String request, String encoding) throws IOException {
        BufferedWriter out = encoding == null ? new BufferedWriter(new OutputStreamWriter(sock.getOutputStream())) : new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), encoding));
        out.write(request);
        out.flush();
    }

    public static void setDefaultAllowUserInteraction(boolean dummy) {
    }

    public static void setDefaultTimeout(int timeout) {
        HttpConnection.timeout = timeout;
    }
}

