import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.*;
import java.awt.color.ColorSpace;

/**
 * Title:        JAlbum grayscale image filter making an image grayscale
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class TintFilter implements JAFilter {

	private int redPercent = 100;
	private int greenPercent = 100;
	private int bluePercent = 100;

	private static final int REDS = 0;
	private static final int GREENS = 1;
	private static final int BLUES = 2;


	public int getRedPercent() {
		return redPercent;
	}

	public void setRedPercent(int percent) {
		this.redPercent = percent;
	}

	public int getGreenPercent() {
		return greenPercent;
	}

	public void setGreenPercent(int percent) {
		this.greenPercent = percent;
	}

	public int getBluePercent() {
		return bluePercent;
	}

	public void setBluePercent(int percent) {
		this.bluePercent = percent;
	}


		// Implements JAFilter
    public String getName() {
        return "Tint filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Tint an image to desired color";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
		byte[][] colorBytes = new byte[3][256];

		for (int i=0; i<256; i++) {
			int d = i*redPercent/100;
			if (d > 255) d = 255;
			colorBytes[REDS][i] = (byte)d;
		}

		for (int i=0; i<256; i++) {
			int d = i*greenPercent/100;
			if (d > 255) d = 255;
			colorBytes[GREENS][i] = (byte)d;
		}

		for (int i=0; i<256; i++) {
			int d = i*bluePercent/100;
			if (d > 255) d = 255;
			colorBytes[BLUES][i] = (byte)d;
		}

		ByteLookupTable colorLookup = new ByteLookupTable(0, colorBytes);
		LookupOp theOp = new LookupOp(colorLookup, null);
		return theOp.filter(bi, null);
    }
}
