
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.CompiledScript;

import java.lang.reflect.Field;
import javax.swing.*;

public class BPPCompiledScript extends CompiledScript
{
	protected boolean copyOriginals;

	public BPPCompiledScript(AlbumBean albumBean)
	{
		super(albumBean);
		updateMyVars();
	}

	protected String getBPPGeneratedImageDirectory()
	{
		return /*engine.getThumbnailDirectory() + "/" +*/ Constants.SKIN_BPP_GENERATED_IMAGE_DIR;
	}

	protected void log(String str)
	{
		log(str, null);
	}

	protected void log(Throwable e)
	{
		log(null, e);
	}

	protected void log(String str, Throwable e)
	{
		if( str!=null )
			System.out.println(str);

		if( e!=null )
			e.printStackTrace(System.out);
	}

	protected void displayMessage(String msg)
	{
		if( window!=null )
			window.messageBox(msg);
		else
			System.out.println(msg);
	}

	public void updateVars()
	{
		super.updateVars();
		updateMyVars();
	}

	private void updateMyVars()
	{
		this.style = engine.getStyle();
		copyOriginals = isCopyOriginals();

		if( this.originalPath==null && copyOriginals )
			this.originalPath = "../" + fileName;
	}

	private boolean isCopyOriginals()
	{
		try
		{
			Field field = window.getClass().getDeclaredField("copyOriginals");
			field.setAccessible(true);
			JCheckBox chkCopyOriginals = (JCheckBox)field.get(window);

			return chkCopyOriginals.isEnabled() && engine.isCopyOriginals();
		}
		catch( Exception e )
		{
			log(e);
			return engine.isCopyOriginals();
		}
	}
}
