
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.util.IO;

import java.io.File;
import java.io.IOException;

public class BPPStyleSheet extends Common
{
	private static final String STYLE_SHEET_INDEX_PB_SELECTOR_NAME = ".index-pagebody";
	private static final String STYLE_SHEET_SLIDE_PB_SELECTOR_NAME = ".slide-pagebody";
	private static final String STYLE_SHEET_BODY_SELECTOR_NAME = "body";
	private static final String STYLE_SHEET_BG_COLOR_ATTRIBUTE_NAME = "background-color";
	private static final String STYLE_SHEET_BG_IMAGE_ATTRIBUTE_NAME = "background-image";
	private static final String STYLE_SHEET_FG_COLOR_ATTRIBUTE_NAME = "color";

	public BPPStyleSheet( AlbumBean engine )
	{
		super( engine );
	}

	protected File extractStyleSheetBackgroundImage(File dir, int applyLevel) throws IOException
	{
		String bgAttribute = null;

		switch( applyLevel )
		{
			case BPPFrameHandler.APPLY_LEVEL_SLIDE:
			case BPPFrameHandler.APPLY_LEVEL_MOVIE_SLIDE:
				bgAttribute = extractStyleSheetAttribute(dir, STYLE_SHEET_SLIDE_PB_SELECTOR_NAME, STYLE_SHEET_BG_IMAGE_ATTRIBUTE_NAME);
				break;
			case BPPFrameHandler.APPLY_LEVEL_THUMBNAIL:
			case BPPFrameHandler.APPLY_LEVEL_FOLDER:
				bgAttribute = extractStyleSheetAttribute(dir, STYLE_SHEET_INDEX_PB_SELECTOR_NAME, STYLE_SHEET_BG_IMAGE_ATTRIBUTE_NAME);
				break;
			default:
				throw new IllegalArgumentException("The 'applyLevel' parameter is not valid!");
		}

		if( isEmptyString(bgAttribute) )
			return null;

		bgAttribute = bgAttribute.trim();

		int index1 = bgAttribute.toLowerCase().indexOf("url(");
		int index2 = bgAttribute.toLowerCase().indexOf(")");

		if( index1!=-1 && index2!=-1 )
			bgAttribute = bgAttribute.substring(4, index2);

		File bgFile = new File(skinResDirectory, "/styles/" + bgAttribute.trim());

		if( bgFile.exists() )
			return bgFile;
		else
			return null;
	}

	protected String extractStyleSheetForegroundColor(File dir) throws IOException
	{
		return extractStyleSheetAttribute(dir, STYLE_SHEET_BODY_SELECTOR_NAME, STYLE_SHEET_FG_COLOR_ATTRIBUTE_NAME);
	}

	protected String extractStyleSheetBackgroundColor(File dir, int applyLevel) throws IOException
	{
		if( applyLevel==BPPFrameHandler.APPLY_LEVEL_SLIDE )
			return extractStyleSheetAttribute(dir, STYLE_SHEET_SLIDE_PB_SELECTOR_NAME, STYLE_SHEET_BG_COLOR_ATTRIBUTE_NAME);
		else
			return extractStyleSheetAttribute(dir, STYLE_SHEET_INDEX_PB_SELECTOR_NAME, STYLE_SHEET_BG_COLOR_ATTRIBUTE_NAME);
	}

	protected String extractStyleSheetAttribute(File dir, String selectorName, String attributeName) throws IOException
	{
		String style = readUserVariableAsString(Constants.USER_VAR_STYLE, dir, this.style);
		File cssFile = new File(skinResDirectory, "/styles/" + style);
		String cssContent = IO.readTextFile(cssFile).toLowerCase();
		int selectorIndex = allWordIndexOf(cssContent, selectorName, 0);

		if( selectorIndex==-1 )
			return null;

		int attributeIndex = allWordIndexOf(cssContent, attributeName, selectorIndex);

		if( attributeIndex==-1 || attributeIndex>cssContent.indexOf('}', selectorIndex) )
			return null;

		return cssContent.substring( cssContent.indexOf(':', attributeIndex) + 1, cssContent.indexOf(';', attributeIndex)).trim();
	}

	private int allWordIndexOf(String source, String exp, int startIndex)
	{
		int index = source.indexOf(exp, startIndex);

		while( index>0 )
		{
			char ch = source.charAt(index - 1);

			if( !Character.isLetterOrDigit(ch) && ch!='-' )
				break;
			index = source.indexOf(exp, index + 1);
		}

		return index;
	}
}
