
import java.awt.*;

public final class Constants
{
// Skin spec...
	public static final String SKIN_VERSION = "v3.10";
	public static final String SKIN_RELEASE_DATE = "July 08, 2006";
	public static final String SKIN_HOME_URL = "http://bluplusplus.armondavanes.com";
	public static final String SKIN_DOCUMENTATION_URL = SKIN_HOME_URL + "/docs.html";
	public static final String SKIN_CHANGES_HISTORY_URL = SKIN_HOME_URL + "/history.html";
	//public static final String SKIN_FORUM_URL = "http://forums.armondavanes.com";     //Unfortunately down!!!
	public static final String SKIN_FORUM_URL = "http://jalbum.net/forum/forum.jspa?forumID=16";
	public static final String SKIN_AUTHOR_NAME = "Armond Avanes";
	public static final String SKIN_AUTHOR_EMAIL = "Armond555@yahoo.com";
	public static final String SKIN_FRAME_DOWNLOAD_URL = SKIN_HOME_URL + "/frames.html";
	public static final String MINIMUM_JALBUM_VERSION = "6.0";

// Skin constants...
	public static final String SKIN_CAMERA_INFORMATION = "cameras.properties";
	public static final String SKIN_PHOTO_METADATA_RESOURCE_BUNDLE_NAME = "photo-metadata";

	public static final String SKIN_TRUNCATED_TEXT_POSTFIX = "...";
	public static final String SKIN_TOP_BAR_PATH_SEPARATOR = "&nbsp;&#xbb;&nbsp;";
	public static final String SKIN_NAVIGATION_BAR_SEPARATOR = "&nbsp;&nbsp;&nbsp;&nbsp;";
	public static final String SKIN_JUMPING_MENU_HIERARCHY_SEPARATOR = SKIN_NAVIGATION_BAR_SEPARATOR;
	public static final String SKIN_FOLDER_META_DATA = "meta.properties";
	public static final String SKIN_FOLDER_LEVEL_VARIABLES = "variables.properties";
	public static final String SKIN_THEME_VARIABLES = "theme.properties";
	public static final String SKIN_FRAME_CONFIG_EXTENSION = ".xbp";
	public static final String SKIN_FRAME_CONFIG_DIR = "/frames/";
	public static final String SKIN_MOVIE_THUMBNAIL_EXTENSION = ".thumb";
	public static final String SKIN_ACTION_RESOURCE_DIR = "/actions/";
	public static final String SKIN_BPP_GENERATED_IMAGE_DIR = "bpp-generated/";
	public static final String SKIN_FOLDER_THUMBNAIL_POSTFIX = "_folderthumb.jpg";
	public static final String SKIN_MOVIE_THUMBNAIL_POSTFIX = "_moviethumb.jpg";
	public static final String SKIN_MOVIE_FRAME_POSTFIX = "_movieframe.jpg";
	public static final String SKIN_MOVIE_STANDARD_GENERATED_THUMBNAIL = "movie_icon.jpg";


// User variables...
	public static final String USER_VAR_ENABLE_DEDICATED_SLIDE_COMMENT_SECTION = "enableDedicatedSlideCommentSection";
	public static final String USER_VAR_SLIDE_COMMENT_HORIZONTAL_ALIGN = "slideCommentHorizontalAlign";
	public static final String USER_VAR_SLIDE_COMMENT_VERTICAL_POSITION = "slideCommentVerticalPosition";
	public static final String USER_VAR_NAVIGATION_BAR_VERTICAL_LOCATION = "navigationBarVerticalLocation";
	//public static final String USER_VAR_CHOOSE_RANDOM_ICON_FOR_FOLDER = "chooseRandomIconForFolder";
	public static final String USER_VAR_INCLUDE_KEYBOARD_SUPPORT = "includeKeyboardSupport";
	public static final String USER_VAR_INCLUDE_SLIDE_SHOW = "includeSlideShow";
	public static final String USER_VAR_SLIDE_SHOW_DELAY = "slideShowDelay";
	public static final String USER_VAR_SLIDE_SHOW_COMMENT_DELAY = "slideShowCommentDelay";
	public static final String USER_VAR_SLIDE_SHOW_MOVIE_DELAY = "slideShowMovieDelay";
	public static final String USER_VAR_CYCLIC_SLIDE_SHOW = "cyclicSlideShow";
	public static final String USER_VAR_INCLUDE_SLIDE_PAGE_THUMBNAILS = "includeSlidePageThumbnails";
	public static final String USER_VAR_SLIDE_PAGE_THUMBNAIL_COUNT = "slidePageThumbnailCount";
	public static final String USER_VAR_SLIDE_PAGE_THUMBNAIL_RATIO = "slidePageThumbnailRatio";
	public static final String USER_VAR_MOVIE_SLIDE_DIMENSION = "movieSlideDimension";
	public static final String USER_VAR_INCLUDE_JUMP_TO_PAGE_ACTION = "includeJumpToPageAction";
	public static final String USER_VAR_INCLUDE_FIRST_LAST_PAGE_ACTIONS = "includeFirstLastPageActions";
	public static final String USER_VAR_INCLUDE_MOVE_FORWARD_FACILITY = "includeMoveForwardFacility";
	public static final String USER_VAR_METADATA_DISPLAY_MODE = "metadataDisplayMode";
	public static final String USER_VAR_CUSTOM_METADATA_FIELDS = "customMetadataFields";
	public static final String USER_VAR_ALBUM_COPYRIGHT_NOTE = "albumCopyright";
	public static final String USER_VAR_EXTERNAL_HOME_PATH = "externalHomePath";
	public static final String USER_VAR_INCLUDE_SAVE_PROTECTION = "includeSaveProtection";
	public static final String USER_VAR_THUMBNAIL_TOOLTIP_CONTENT = "thumbnailTooltipContent";
	public static final String USER_VAR_THUMBNAIL_CAPTION_CONTENT = "thumbnailCaptionContent";
	public static final String USER_VAR_FOLDER_TOOLTIP_CONTENT = "folderTooltipContent";
	public static final String USER_VAR_FOLDER_CAPTION_CONTENT = "folderCaptionContent";
	public static final String USER_VAR_SLIDE_CAPTION_CONTENT = "slideCaptionContent";
	public static final String USER_VAR_SLIDE_BREADCRUMB_TRAIL_CONTENT = "slideBreadcrumbTrailContent";
	public static final String USER_VAR_SLIDE_FRAME_TYPE = "slideFrameType";
	public static final String USER_VAR_SLIDE_FRAME_RATIO = "slideFrameRatio";
	public static final String USER_VAR_MOVIE_SLIDE_FRAME_TYPE = "movieSlideFrameType";
	public static final String USER_VAR_MOVIE_SLIDE_FRAME_RATIO = "movieSlideFrameRatio";
	public static final String USER_VAR_SLIDE_THUMBNAIL_FRAME_TYPE = "thumbnailFrameType";
	public static final String USER_VAR_SLIDE_THUMBNAIL_FRAME_RATIO = "thumbnailFrameRatio";
	public static final String USER_VAR_FOLDER_THUMBNAIL_FRAME_TYPE = "folderThumbnailFrameType";
	public static final String USER_VAR_FOLDER_THUMBNAIL_FRAME_RATIO = "folderThumbnailFrameRatio";
	public static final String USER_VAR_ICON_SET = "iconSet";
	public static final String USER_VAR_STYLE = "style";
	public static final String USER_VAR_SHOW_AUDIO_CONSOLE = "showAudioConsole";
	public static final String USER_VAR_AUDIO_CONSOLE_DIMENSION = "audioConsoleDimension";
	public static final String USER_VAR_ONLINE_PRINTING_SUPPORT = "printing";
	public static final String USER_VAR_PREFETCH_SIBLING_SLIDES = "prefetchSiblingSlides";
	public static final String USER_VAR_INCLUDE_BLENDING_EFFECT_ON_SLIDES = "includeBlendingEffectOnSlides";
	public static final String USER_VAR_INCLUDE_BLENDING_EFFECT_ON_INDEXES = "includeBlendingEffectOnIndexes";
	public static final String USER_VAR_CONTEXT_HELP_STYLE = "contextHelpStyle";
	public static final String USER_VAR_INCLUDE_NAVIGATION_HELP_TIPS = "includeNavigationHelpTips";
	public static final String USER_VAR_ENABLE_TEXT_TRUNCATION = "enableTextTruncation";
	public static final String USER_VAR_MAXIMUM_FOLDER_LENGTH_ON_PATH_BAR = "maximumFolderLengthOnPathBar";
	public static final String USER_VAR_MAXIMUM_THUMBNAIL_CAPTION_LENGTH = "maximumThumbnailCaptionLength";
	public static final String USER_VAR_INCLUDE_VIEWER_REMARKS_FEATURE_ON_SLIDES = "includeViewerRemarksOnSlides";
	public static final String USER_VAR_INCLUDE_VIEWER_REMARKS_FEATURE_ON_FOLDERS = "includeViewerRemarksOnFolders";
	public static final String USER_VAR_REMARKS_FORCE_VISIBLE = "remarksForceVisible";
	public static final String USER_VAR_REMARKS_NOTIFY_VIA_EMAIL = "remarksNotifyViaEmail";

// Metadata constants...
	public static final String META_FOLDER_TITLE = "folderTitle";
	public static final String META_FOLDER_HEADER = "folderHeader";
	public static final String META_FOLDER_FOOTER = "folderFooter";
	public static final String META_FOLDER_ICON = "folderIcon";
	public static final String META_FOLDER_VOICE = "folderVoice";
	public static final String META_INDEX_BACKGROUND_IMAGE = "indexBackgroundImage";
	public static final String META_SLIDE_BACKGROUND_IMAGE = "slideBackgroundImage";
	public static final String META_SLIDE_TITLE = "title.";
	public static final String META_SLIDE_DESCRIPTION = "description.";
	public static final String META_SLIDE_VOICE = "voice.";

// Default values...
	public static final int DEFAULT_SLIDE_SHOW_DELAY = 4;
	public static final int DEFAULT_SLIDE_SHOW_MOVIE_DELAY = 15;
	public static final int DEFAULT_SLIDE_PAGE_THUMBNAIL_COUNT = 5;
	public static final int DEFAULT_SLIDE_PAGE_THUMBNAIL_RATIO = 50;
	public static final String DEFAULT_METADATA_DISPLAY_MODE = "custom";
	public static final String DEFAULT_CUSTOM_METADATA_FIELDS = "|<title>General info:|Model|Make|Device Setting Description" +
							"|<title>Basic shot info:|Focal Length|Subject Distance|Aperture Value|F-Number|Shutter Speed Value|ISO Speed Ratings|White Balance Mode|Flash|Metering Mode" +
							"|<title>Advanced shot info:|Exposure Bias Value|Exposure Time|Exposure Mode|Max Aperture Value|Brightness Value|Contrast|Saturation|Sharpness" +
							"|<title>Exif-related info:|Date/Time|Exif Image Width|Exif Image Height";
	public static final String DEFAULT_SLIDE_FRAME_TYPE = "shadow";
	public static final String DEFAULT_MOVIE_SLIDE_FRAME_TYPE = "shadow_full";
	public static final String DEFAULT_SLIDE_THUMBNAIL_FRAME_TYPE = "frame";
	public static final String DEFAULT_FOLDER_THUMBNAIL_FRAME_TYPE = "frame";
	public static final String DEFAULT_ICON_SET = "universal";
	public static final String DEFAULT_THUMBNAIL_TOOLTIP_CONTENT = "Title|Comment|Dimension|FileSize";
	public static final String DEFAULT_FOLDER_TOOLTIP_CONTENT = "Title|Header|SlideCount";
	public static final String DEFAULT_FOLDER_CAPTION_CONTENT = "Title";
	public static final String DEFAULT_THUMBNAIL_CAPTION_CONTENT = "Title";
	public static final String DEFAULT_SLIDE_CAPTION_CONTENT = "FileName|Dimension|FileSize||Date";
	public static final String DEFAULT_SLIDE_BREADCRUMB_TRAIL = "Title";
	public static final String DEFAULT_CONTEXT_HELP_STYLE = "ToolTip";
	public static final String DEFAULT_SLIDE_COMMENT_VERTICAL_POSITION = "TOP_UNDER_NAVIGATION";
	public static final String DEFAULT_NAVIGATION_BAR_VERTICAL_LOCATION = "Top";
	public static final String DEFAULT_ONLINE_PRINTING_SUPPORT = "none";
	public static final Dimension DEFAULT_AUDIO_CONSOLE_DIMENSION = new Dimension(150, 20);

// Data cache keys...
	public static final String CACHE_KEY_PREFIX = "CacheKey_";
	public static final String CACHE_KEY_PHOTO_METADATA_RESOURCE_BUNDLE = CACHE_KEY_PREFIX + "Photo_MetaData_Resource_Bundle";
	public static final String CACHE_KEY_DIRECTORY_SLIDE_COUNT = CACHE_KEY_PREFIX + "DirectorySlideCount";
	public static final String CACHE_KEY_FIRST_SLIDE_OF_INDEX_PAGE = CACHE_KEY_PREFIX + "FirstSlideOfIndexPageKey";
	public static final String CACHE_KEY_THUMBNAIL_TOOLTIP = CACHE_KEY_PREFIX + "ThumbnailTooltip";
	public static final String CACHE_KEY_SLIDE_THUMBNAIL_COUNT = CACHE_KEY_PREFIX + "SlideThumbnailCount";
	public static final String CACHE_KEY_SLIDE_COMMENT = CACHE_KEY_PREFIX + "SlideComment";
	public static final String CACHE_KEY_THUMBNAIL_FRAME_BLOCK = CACHE_KEY_PREFIX + "ThumbnailFrameBlock";
	public static final String CACHE_KEY_FOLDER_USER_VARIABLE = CACHE_KEY_PREFIX + "FolderUserVariable_";
	public static final String CACHE_KEY_NAVIGATION_HELP_TIPS = CACHE_KEY_PREFIX + "NavigationHelpTips";
	public static final String CACHE_KEY_SLIDE_JUMP_TO_PAGE = CACHE_KEY_PREFIX + "SlideJumpToPage";
	public static final String CACHE_KEY_INDEX_JUMP_TO_PAGE = CACHE_KEY_PREFIX + "IndexJumpToPage";
	public static final String CACHE_KEY_SLIDE_TOP_PATH_BAR = CACHE_KEY_PREFIX + "SlideTopPathBar";
	public static final String CACHE_KEY_INDEX_TOP_PATH_BAR = CACHE_KEY_PREFIX + "IndexTopPathBar";

	public static final String CACHE_KEY_USED_ICON_SETS = CACHE_KEY_PREFIX + "UsedIconSets";
	public static final String CACHE_KEY_USED_STYLES = CACHE_KEY_PREFIX + "UsedStyles";
	public static final String CACHE_KEY_USED_FULL_STYLES = CACHE_KEY_PREFIX + "UsedFullStyles";

	public static final String CACHE_KEY_FOLDER_FRAME_FILTER = CACHE_KEY_PREFIX + "FolderFrameFilter";
	public static final String CACHE_KEY_SLIDE_FRAME_FILTER = CACHE_KEY_PREFIX + "SlideFrameFilter";
	public static final String CACHE_KEY_MOVIE_SLIDE_FRAME_FILTER = CACHE_KEY_PREFIX + "MovieSlideFrameFilter";
	public static final String CACHE_KEY_THUMBNAIL_FRAME_FILTER = CACHE_KEY_PREFIX + "ThumbnailFrameFilter";
	public static final String CACHE_KEY_LOGO_FILTER = CACHE_KEY_PREFIX + "LogoFilter";
}
