
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;

import se.datadosen.jalbum.AlbumBean;

public class OriginalSlide extends AbstractSlide
{
	private static final String IMAGE_TEMPLATE = "<img src=\"{0}\" alt=\"{1}\"/>";
	private static final String LINK_TEMPLATE = "<a href=\"{0}\" title=\"{1}\">{2}</a>";

	public OriginalSlide(AlbumBean engine)
	{
		super(engine);
	}

	public String getCurrentOriginalSlideContent()
	{
		Map vars = (Map)fileVariables.get(currentFile);
		String block;

		if( isMovieFile(currentFile) )
			block = getMovieBlock(currentFile.getName(), getMovieSlideSize());
		else
		{
			if( isVariableValueEqual( Constants.USER_VAR_INCLUDE_MOVE_FORWARD_FACILITY, imageDirectory, true ) )
			{
				if( !isEmptyString(nextPage) )
				{
					block = MessageFormat.format(IMAGE_TEMPLATE, new Object[] {vars.get("originalPath"), texts.getString("next-slide")});
					block = MessageFormat.format(LINK_TEMPLATE, new Object[] {"javascript:nextPage()", texts.getString("next-slide"), block});
				}
				else
					block = MessageFormat.format(IMAGE_TEMPLATE, new Object[] {vars.get("originalPath"), texts.getString("on-last-slide")});
			}
			else
			{
				block = MessageFormat.format(IMAGE_TEMPLATE, new Object[] {vars.get("originalPath"), texts.getString("up")});
				block = MessageFormat.format(LINK_TEMPLATE, new Object[] {vars.get("currentPage"), texts.getString("up"), block});
			}
		}

		return block;
	}
}
