
import java.awt.*;
import javax.swing.*;

import se.datadosen.component.RiverLayout;
import se.datadosen.component.ControlPanel;

public abstract class SkinAbstractSection extends JPanel
{
	protected SkinPanel ui;

	public SkinAbstractSection(SkinPanel ui)
	{
		this.ui = ui;
	}

	public SkinAbstractSection(LayoutManager layout, SkinPanel ui)
	{
		super(layout);
		this.ui = ui;
	}

	protected static void addToContainer(Component comp, Container cont, GridBagLayout gridbag, GridBagConstraints c)
	{
		 gridbag.setConstraints(comp, c);
		 cont.add(comp);
	}

	protected static ControlPanel createControlPanel(String name)
	{
		return createControlPanel(name, 5, 5);
	}

	protected static ControlPanel createControlPanel(String name, int hgap)
	{
		return createControlPanel(name, hgap, 5);
	}

	protected static ControlPanel createControlPanel(String name, int hgap, int vgap)
	{
		ControlPanel ccPanel = new ControlPanel(name);

		((RiverLayout)ccPanel.getLayout()).setHgap(hgap);
		((RiverLayout)ccPanel.getLayout()).setVgap(vgap);
		return ccPanel;
	}
}
