import javax.swing.*;

import se.datadosen.component.RiverLayout;
import se.datadosen.component.ControlPanel;

public class SkinFilterManagementSection extends SkinAbstractSection
{
	public SkinFilterManagementSection(SkinPanel ui)
	{
		super(new RiverLayout(1, 1), ui);

		JTabbedPane tabFilterManagementSet = new JTabbedPane();
		JPanel pnlFilterManagementGeneralSet = new JPanel(new RiverLayout(0, 0));
		JLabel lblWarning = new JLabel("Note: Use Rebuild All if these settings are changed between album generations.");

		pnlFilterManagementGeneralSet.add("p vtop", getFixedShapeFilterPanel());
		pnlFilterManagementGeneralSet.add("left", getZoomFilterPanel());
		pnlFilterManagementGeneralSet.add("left hfill", getGrayScaleFilterPanel());
		pnlFilterManagementGeneralSet.add("p vtop hfill", getLogoFilterPanel());

		tabFilterManagementSet.addTab("General Filters", pnlFilterManagementGeneralSet);
		tabFilterManagementSet.addTab("Text Filter", getTextFilterPanel());
		tabFilterManagementSet.addTab("Shadow Text Filter", getShadowTextFilterPanel());
		tabFilterManagementSet.addTab("Watermark Text Filter", getWatermarkTextFilterPanel());

		lblWarning.setToolTipText("For more information on filters, please refer to the Documentation and User Guide link on the About tab");
		add(lblWarning);
		add("br", ui.keepFiltersDefinedOutsideFMTabs);
		add("p vtop hfill vfill", tabFilterManagementSet);
	}

	private ControlPanel getFixedShapeFilterPanel()
	{
		ControlPanel ccFilter = createControlPanel("Fixed Shape/Size", 0, 0);

		ccFilter.add(ui.includeFixedShapeFilterOnThumbnails);
		ccFilter.add("br", ui.prescaleFixedShapeFilterOnThumbnails);
		ccFilter.add("br", ui.includeFixedShapeFilterOnSlides);
		ccFilter.add("br", ui.prescaleFixedShapeFilterOnSlides);
		return ccFilter;
	}

	private ControlPanel getGrayScaleFilterPanel()
	{
		ControlPanel ccFilter = createControlPanel("Gray Scale", 0, 0);

		ccFilter.add(ui.includeGrayScaleFilterOnThumbnails);
		ccFilter.add("br", ui.includeGrayScaleFilterOnSlides);
		ccFilter.add("br", new JLabel(" "));
		ccFilter.add("br", new JLabel(" "));
		ccFilter.add("br", new JLabel(" "));
		return ccFilter;
	}

	private ControlPanel getZoomFilterPanel()
	{
		ControlPanel ccFilter = createControlPanel("Zoom", 2, 0);

		ccFilter.add(ui.includeZoomFilterOnThumbnails);
		ccFilter.add("tab", ui.zoomFilterPercentOnThumbnails);
		ccFilter.add(new JLabel("%"));
		ccFilter.add("br", ui.prescaleZoomFilterOnThumbnails);
		ccFilter.add("br", ui.includeZoomFilterOnSlides);
		ccFilter.add("tab", ui.zoomFilterPercentOnSlides);
		ccFilter.add(new JLabel("%"));
		ccFilter.add("br", ui.prescaleZoomFilterOnSlides);
		return ccFilter;
	}

	private ControlPanel getLogoFilterPanel()
	{
		ControlPanel ccFilter = createControlPanel("Logo", 0, 0);
		ControlPanel ccThumbnail = createControlPanel("", 2, 1);
		ControlPanel ccSlide = createControlPanel("", 2, 1);

		ccThumbnail.add(ui.includeLogoFilterOnThumbnails);
		ccThumbnail.add("left", ui.prescaleLogoFilterOnThumbnails);
		ccThumbnail.add("br", new JLabel("Logo Src"));
		ccThumbnail.add("tab hfill", ui.logoFilterSourceOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Align"));
		ccThumbnail.add("tab", ui.logoFilterHorizontalAlignOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Align"));
		ccThumbnail.add("tab", ui.logoFilterVerticalAlignOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Offset"));
		ccThumbnail.add("tab", ui.logoFilterHorizontalOffsetOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Offset"));
		ccThumbnail.add("tab", ui.logoFilterVerticalOffsetOnThumbnails);
		ccThumbnail.add("br", new JLabel("Margin"));
		ccThumbnail.add("tab", ui.logoFilterMarginOnThumbnails);

		ccSlide.add(ui.includeLogoFilterOnSlides);
		ccSlide.add("left", ui.prescaleLogoFilterOnSlides);
		ccSlide.add("br", new JLabel("Logo Src"));
		ccSlide.add("tab hfill", ui.logoFilterSourceOnSlides);
		ccSlide.add("br", new JLabel("Hor. Align"));
		ccSlide.add("tab", ui.logoFilterHorizontalAlignOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Align"));
		ccSlide.add("tab", ui.logoFilterVerticalAlignOnSlides);
		ccSlide.add("br", new JLabel("Hor. Offset"));
		ccSlide.add("tab", ui.logoFilterHorizontalOffsetOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Offset"));
		ccSlide.add("tab", ui.logoFilterVerticalOffsetOnSlides);
		ccSlide.add("br", new JLabel("Margin"));
		ccSlide.add("tab", ui.logoFilterMarginOnSlides);

		ccFilter.add(ccThumbnail);
		ccFilter.add("hfill", ccSlide);
		return ccFilter;
	}

	private JPanel getTextFilterPanel()
	{
		JPanel pnlFilter = new JPanel(new RiverLayout(2, 1));
		ControlPanel ccThumbnail = createControlPanel("", 5, 1);
		ControlPanel ccSlide = createControlPanel("", 5, 1);

		ccThumbnail.add(ui.includeTextFilterOnThumbnails);
		ccThumbnail.add("left", ui.prescaleTextFilterOnThumbnails);
		ccThumbnail.add("br", new JLabel("Text"));
		ccThumbnail.add("tab", ui.textFilterTextOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Color"));
		ccThumbnail.add("tab", ui.textFilterColorOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Margin"));
		ccThumbnail.add("tab", ui.textFilterMarginOnThumbnails);
		ccThumbnail.add("br", new JLabel("Font Face"));
		ccThumbnail.add("tab", ui.textFilterFontFaceOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Font Style"));
		ccThumbnail.add("tab", ui.textFilterFontStyleOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Font Size"));
		ccThumbnail.add("tab", ui.textFilterFontSizeOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Align"));
		ccThumbnail.add("tab", ui.textFilterHorizontalAlignOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Align"));
		ccThumbnail.add("tab", ui.textFilterVerticalAlignOnThumbnails);
		ccThumbnail.add("tab", ui.textFilterAntiAliasOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Offset"));
		ccThumbnail.add("tab", ui.textFilterHorizontalOffsetOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Offset"));
		ccThumbnail.add("tab", ui.textFilterVerticalOffsetOnThumbnails);

		ccSlide.add(ui.includeTextFilterOnSlides);
		ccSlide.add("left", ui.prescaleTextFilterOnSlides);
		ccSlide.add("br", new JLabel("Text"));
		ccSlide.add("tab", ui.textFilterTextOnSlides);
		ccSlide.add("tab", new JLabel("Color"));
		ccSlide.add("tab", ui.textFilterColorOnSlides);
		ccSlide.add("tab", new JLabel("Margin"));
		ccSlide.add("tab", ui.textFilterMarginOnSlides);
		ccSlide.add("br", new JLabel("Font Face"));
		ccSlide.add("tab", ui.textFilterFontFaceOnSlides);
		ccSlide.add("tab", new JLabel("Font Style"));
		ccSlide.add("tab", ui.textFilterFontStyleOnSlides);
		ccSlide.add("tab", new JLabel("Font Size"));
		ccSlide.add("tab", ui.textFilterFontSizeOnSlides);
		ccSlide.add("br", new JLabel("Hor. Align"));
		ccSlide.add("tab", ui.textFilterHorizontalAlignOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Align"));
		ccSlide.add("tab", ui.textFilterVerticalAlignOnSlides);
		ccSlide.add("tab", ui.textFilterAntiAliasOnSlides);
		ccSlide.add("br", new JLabel("Hor. Offset"));
		ccSlide.add("tab", ui.textFilterHorizontalOffsetOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Offset"));
		ccSlide.add("tab", ui.textFilterVerticalOffsetOnSlides);

		pnlFilter.add("p vtop hfill", ccThumbnail);
		pnlFilter.add("br hfill", ccSlide);
		return pnlFilter;
	}

	private JPanel getShadowTextFilterPanel()
	{
		JPanel pnlFilter = new JPanel(new RiverLayout(2, 1));
		ControlPanel ccThumbnail = createControlPanel("", 5, 1);
		ControlPanel ccSlide = createControlPanel("", 5, 1);

		ccThumbnail.add(ui.includeShadowTextFilterOnThumbnails);
		ccThumbnail.add("left", ui.prescaleShadowTextFilterOnThumbnails);
		ccThumbnail.add("br", new JLabel("Text"));
		ccThumbnail.add("tab", ui.shadowTextFilterTextOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Text Color"));
		ccThumbnail.add("tab", ui.shadowTextFilterTextColorOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Margin"));
		ccThumbnail.add("tab", ui.shadowTextFilterMarginOnThumbnails);
		ccThumbnail.add("br", new JLabel("Font Face"));
		ccThumbnail.add("tab", ui.shadowTextFilterFontFaceOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Font Style"));
		ccThumbnail.add("tab", ui.shadowTextFilterFontStyleOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Font Size"));
		ccThumbnail.add("tab", ui.shadowTextFilterFontSizeOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Align"));
		ccThumbnail.add("tab", ui.shadowTextFilterHorizontalAlignOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Align"));
		ccThumbnail.add("tab", ui.shadowTextFilterVerticalAlignOnThumbnails);
		ccThumbnail.add("tab", ui.shadowTextFilterAntiAliasOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Offset"));
		ccThumbnail.add("tab", ui.shadowTextFilterHorizontalOffsetOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Offset"));
		ccThumbnail.add("tab", ui.shadowTextFilterVerticalOffsetOnThumbnails);
		ccThumbnail.add("br", new JLabel("Shadow Color"));
		ccThumbnail.add("tab", ui.shadowTextFilterShadowColorOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Shadow Dist."));
		ccThumbnail.add("tab", ui.shadowTextFilterShadowDistanceOnThumbnails);

		ccSlide.add(ui.includeShadowTextFilterOnSlides);
		ccSlide.add("left", ui.prescaleShadowTextFilterOnSlides);
		ccSlide.add("br", new JLabel("Text"));
		ccSlide.add("tab", ui.shadowTextFilterTextOnSlides);
		ccSlide.add("tab", new JLabel("Text Color"));
		ccSlide.add("tab", ui.shadowTextFilterTextColorOnSlides);
		ccSlide.add("tab", new JLabel("Margin"));
		ccSlide.add("tab", ui.shadowTextFilterMarginOnSlides);
		ccSlide.add("br", new JLabel("Font Face"));
		ccSlide.add("tab", ui.shadowTextFilterFontFaceOnSlides);
		ccSlide.add("tab", new JLabel("Font Style"));
		ccSlide.add("tab", ui.shadowTextFilterFontStyleOnSlides);
		ccSlide.add("tab", new JLabel("Font Size"));
		ccSlide.add("tab", ui.shadowTextFilterFontSizeOnSlides);
		ccSlide.add("br", new JLabel("Hor. Align"));
		ccSlide.add("tab", ui.shadowTextFilterHorizontalAlignOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Align"));
		ccSlide.add("tab", ui.shadowTextFilterVerticalAlignOnSlides);
		ccSlide.add("tab", ui.shadowTextFilterAntiAliasOnSlides);
		ccSlide.add("br", new JLabel("Hor. Offset"));
		ccSlide.add("tab", ui.shadowTextFilterHorizontalOffsetOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Offset"));
		ccSlide.add("tab", ui.shadowTextFilterVerticalOffsetOnSlides);
		ccSlide.add("br", new JLabel("Shadow Color"));
		ccSlide.add("tab", ui.shadowTextFilterShadowColorOnSlides);
		ccSlide.add("tab", new JLabel("Shadow Dist."));
		ccSlide.add("tab", ui.shadowTextFilterShadowDistanceOnSlides);

		pnlFilter.add("p vtop hfill", ccThumbnail);
		pnlFilter.add("br hfill", ccSlide);
		return pnlFilter;
	}

	private JPanel getWatermarkTextFilterPanel()
	{
		JPanel pnlFilter = new JPanel(new RiverLayout(2, 1));
		ControlPanel ccThumbnail = createControlPanel("", 5, 1);
		ControlPanel ccSlide = createControlPanel("", 5, 1);

		ccThumbnail.add(ui.includeWatermarkTextFilterOnThumbnails);
		ccThumbnail.add("left", ui.prescaleWatermarkTextFilterOnThumbnails);
		ccThumbnail.add("br", new JLabel("Text"));
		ccThumbnail.add("tab", ui.watermarkTextFilterTextOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Color"));
		ccThumbnail.add("tab", ui.watermarkTextFilterColorOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Margin"));
		ccThumbnail.add("tab", ui.watermarkTextFilterMarginOnThumbnails);
		ccThumbnail.add("br", new JLabel("Font Face"));
		ccThumbnail.add("tab", ui.watermarkTextFilterFontFaceOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Font Style"));
		ccThumbnail.add("tab", ui.watermarkTextFilterFontStyleOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Font Size"));
		ccThumbnail.add("tab", ui.watermarkTextFilterFontSizeOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Align"));
		ccThumbnail.add("tab", ui.watermarkTextFilterHorizontalAlignOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Align"));
		ccThumbnail.add("tab", ui.watermarkTextFilterVerticalAlignOnThumbnails);
		ccThumbnail.add("tab", ui.watermarkTextFilterAntiAliasOnThumbnails);
		ccThumbnail.add("br", new JLabel("Hor. Offset"));
		ccThumbnail.add("tab", ui.watermarkTextFilterHorizontalOffsetOnThumbnails);
		ccThumbnail.add("tab", new JLabel("Ver. Offset"));
		ccThumbnail.add("tab", ui.watermarkTextFilterVerticalOffsetOnThumbnails);
		ccThumbnail.add("br", new JLabel("Strength"));
		ccThumbnail.add("tab", ui.watermarkTextFilterStrengthPercentOnThumbnails);
		ccThumbnail.add(new JLabel("%"));

		ccSlide.add(ui.includeWatermarkTextFilterOnSlides);
		ccSlide.add("left", ui.prescaleWatermarkTextFilterOnSlides);
		ccSlide.add("br", new JLabel("Text"));
		ccSlide.add("tab", ui.watermarkTextFilterTextOnSlides);
		ccSlide.add("tab", new JLabel("Color"));
		ccSlide.add("tab", ui.watermarkTextFilterColorOnSlides);
		ccSlide.add("tab", new JLabel("Margin"));
		ccSlide.add("tab", ui.watermarkTextFilterMarginOnSlides);
		ccSlide.add("br", new JLabel("Font Face"));
		ccSlide.add("tab", ui.watermarkTextFilterFontFaceOnSlides);
		ccSlide.add("tab", new JLabel("Font Style"));
		ccSlide.add("tab", ui.watermarkTextFilterFontStyleOnSlides);
		ccSlide.add("tab", new JLabel("Font Size"));
		ccSlide.add("tab", ui.watermarkTextFilterFontSizeOnSlides);
		ccSlide.add("br", new JLabel("Hor. Align"));
		ccSlide.add("tab", ui.watermarkTextFilterHorizontalAlignOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Align"));
		ccSlide.add("tab", ui.watermarkTextFilterVerticalAlignOnSlides);
		ccSlide.add("tab", ui.watermarkTextFilterAntiAliasOnSlides);
		ccSlide.add("br", new JLabel("Hor. Offset"));
		ccSlide.add("tab", ui.watermarkTextFilterHorizontalOffsetOnSlides);
		ccSlide.add("tab", new JLabel("Ver. Offset"));
		ccSlide.add("tab", ui.watermarkTextFilterVerticalOffsetOnSlides);
		ccSlide.add("br", new JLabel("Strength"));
		ccSlide.add("tab", ui.watermarkTextFilterStrengthPercentOnSlides);
		ccSlide.add(new JLabel("%"));

		pnlFilter.add("p vtop hfill", ccThumbnail);
		pnlFilter.add("br hfill", ccSlide);
		return pnlFilter;
	}
}
