import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.List;
import javax.swing.*;

import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.util.BeanBinderException;

public class SkinGUI extends BPPCompiledScript
{
	private SkinPanel ui = null;

	public SkinGUI(AlbumBean albumBean)
	{
		super(albumBean);
		ui = new SkinPanel(albumBean);
	}

	public void onLoad()
	{
		setupComponents();
		doMainLayout();
		setupThemeNotification();
		setupImageLinkingNotification();

		// Finally install components into JAlbum
		window.setSkinUI(ui);
		window.pack();
	}

	private void setupComponents()
	{
		String[] fontFaces = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

		setItemsForComboBox(ui.iconSet, getIconSets());

		setItemsForComboBox(ui.textFilterFontFaceOnThumbnails, fontFaces);
		setItemsForComboBox(ui.textFilterFontFaceOnSlides, fontFaces);
		setItemsForComboBox(ui.shadowTextFilterFontFaceOnThumbnails, fontFaces);
		setItemsForComboBox(ui.shadowTextFilterFontFaceOnSlides, fontFaces);
		setItemsForComboBox(ui.watermarkTextFilterFontFaceOnThumbnails, fontFaces);
		setItemsForComboBox(ui.watermarkTextFilterFontFaceOnSlides, fontFaces);

		// Setting proper widths for the components to limit them
		ui.metadataDisplayMode.getPreferredSize().width = 100;
		ui.movieSlideDimension.getPreferredSize().width = 100;

		ui.textFilterFontFaceOnThumbnails.setPreferredSize( new Dimension(150, 20) );
		ui.textFilterFontFaceOnSlides.setPreferredSize( new Dimension(150, 20) );
		ui.shadowTextFilterFontFaceOnThumbnails.setPreferredSize( new Dimension(150, 20) );
		ui.shadowTextFilterFontFaceOnSlides.setPreferredSize( new Dimension(150, 20) );
		ui.watermarkTextFilterFontFaceOnThumbnails.setPreferredSize( new Dimension(150, 20) );
		ui.watermarkTextFilterFontFaceOnSlides.setPreferredSize( new Dimension(150, 20) );

		ui.movieSlideDimension.setEditable(true);
		ui.textFilterFontFaceOnThumbnails.setEditable(true);
		ui.textFilterFontFaceOnSlides.setEditable(true);

		ui.customMetadataFields.setLineWrap(true);

		setupComponentsDescription();
		setupEventHandlers();
	}

	// Adding some descriptions, as the labels themselves are not descriptive enough!
	private void setupComponentsDescription()
	{
		ui.prescaleFixedShapeFilterOnThumbnails.setToolTipText("Apply filter before scaling");
		ui.prescaleFixedShapeFilterOnSlides.setToolTipText("Apply filter before scaling");
		ui.prescaleZoomFilterOnThumbnails.setToolTipText("Apply filter before scaling");
		ui.prescaleZoomFilterOnSlides.setToolTipText("Apply filter before scaling");
		ui.prescaleLogoFilterOnThumbnails.setToolTipText("Apply filter before scaling");
		ui.prescaleLogoFilterOnSlides.setToolTipText("Apply filter before scaling");
		ui.prescaleTextFilterOnThumbnails.setToolTipText("Apply filter before scaling");
		ui.prescaleTextFilterOnSlides.setToolTipText("Apply filter before scaling");
		ui.prescaleShadowTextFilterOnThumbnails.setToolTipText("Apply filter before scaling");
		ui.prescaleShadowTextFilterOnSlides.setToolTipText("Apply filter before scaling");
		ui.prescaleWatermarkTextFilterOnThumbnails.setToolTipText("Apply filter before scaling");
		ui.prescaleWatermarkTextFilterOnSlides.setToolTipText("Apply filter before scaling");

		ui.logoFilterSourceOnSlides.setToolTipText("Full logo source path here");
		ui.logoFilterSourceOnThumbnails.setToolTipText("Full logo source path here");

		ui.includeMoveForwardFacility.setToolTipText("One click moving-forward facility on slide pages if there is no 'Link to originals via scaled images'");
		ui.movieSlideDimension.setToolTipText("Movie Slides Dimension must take into account the size of the movie player controls");

		ui.keepFiltersDefinedOutsideFMTabs.setToolTipText("Check this option if also adding filters via the JAlbum Advanced tab");

		ui.slideCaptionContent.setToolTipText("Available options are Title|FileName|FileType|Date|Dimension|SlideDimension|FileSize|<any EXIF/IPTC field name>");
		ui.slideBreadcrumbTrailContent.setToolTipText("Available options are Title|FileName|<any EXIF/IPTC field name>");
		ui.thumbnailTooltipContent.setToolTipText("Available options are Title|FileName|FileType|Comment|Date|Dimension|SlideDimension|FileSize|<any EXIF/IPTC field name>");
		ui.thumbnailCaptionContent.setToolTipText("Available options are Title|FileName|FileType|Comment|Date|Dimension|SlideDimension|FileSize|<any EXIF/IPTC field name>");
		ui.folderTooltipContent.setToolTipText("Available options are Title|FileName|Date|Header|Footer|SlideCount");
		ui.folderCaptionContent.setToolTipText("Available options are Title|FileName|Date|Header|Footer|SlideCount");

		ui.slidePageThumbnailRatio.setToolTipText("A number between zero and 100 (percentage)");

		ui.slideFrameRatio.setToolTipText("A number between zero and 100 (percentage)");
		ui.thumbnailFrameRatio.setToolTipText("A number between zero and 100 (percentage)");
		ui.folderThumbnailFrameRatio.setToolTipText("A number between zero and 100 (percentage)");

		ui.maximumFolderLengthOnPathBar.setToolTipText("Zero or any negative number here means no limit on the length");
		ui.maximumThumbnailCaptionLength.setToolTipText("Zero or any negative number here means no limit on the length");
	}

	private void setupEventHandlers()
	{
		ui.showAudioConsole.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.audioConsoleDimension.setEnabled(ui.showAudioConsole.isSelected());
		   }
		});
		correctCheckBoxState(ui.showAudioConsole);

		ui.enableTextTruncation.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.maximumFolderLengthOnPathBar.setEnabled(ui.enableTextTruncation.isSelected());
			ui.maximumThumbnailCaptionLength.setEnabled(ui.enableTextTruncation.isSelected());
		   }
		});
		correctCheckBoxState(ui.enableTextTruncation);

		ui.metadataDisplayMode.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			String sel_item = (String) ui.metadataDisplayMode.getSelectedItem();

			ui.customMetadataFields.setEnabled(sel_item.equalsIgnoreCase("custom") || sel_item.equals(""));
		   }
		});

		ItemListener viewerRemarksListener = new ItemListener() {
			public void itemStateChanged( ItemEvent e )
			{
				ui.remarksForceVisible.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksDatabaseUrl.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksDatabaseName.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksDatabaseUserName.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksDatabasePassword.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksAdminUser.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksAdminPassword.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksDatabaseTableName.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksDateFormat.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksDateSuffix.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );

				ui.remarksNotifyViaEmail.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksNotifyToEmail.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				ui.remarksNotifyFromEmail.setEnabled( ui.includeViewerRemarksOnSlides.isSelected() || ui.includeViewerRemarksOnFolders.isSelected() );
				correctCheckBoxState( ui.remarksNotifyViaEmail );
			}
		};
		ui.includeViewerRemarksOnSlides.addItemListener( viewerRemarksListener );
		ui.includeViewerRemarksOnFolders.addItemListener( viewerRemarksListener );
		correctCheckBoxState(ui.includeViewerRemarksOnSlides);
		correctCheckBoxState(ui.includeViewerRemarksOnFolders);

		ui.remarksNotifyViaEmail.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.remarksNotifyToEmail.setEnabled(ui.remarksNotifyViaEmail.isEnabled() && ui.remarksNotifyViaEmail.isSelected());
			ui.remarksNotifyFromEmail.setEnabled(ui.remarksNotifyViaEmail.isEnabled() && ui.remarksNotifyViaEmail.isSelected());
		   }
		});
		correctCheckBoxState(ui.remarksNotifyViaEmail);

		ui.includeSlidePageThumbnails.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.slidePageThumbnailCount.setEnabled(ui.includeSlidePageThumbnails.isSelected());
			ui.slidePageThumbnailRatio.setEnabled(ui.includeSlidePageThumbnails.isSelected());
		   }
		});
		correctCheckBoxState(ui.includeSlidePageThumbnails);

		ui.includeSlideShow.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.cyclicSlideShow.setEnabled(ui.includeSlideShow.isSelected());
			ui.slideShowDelay.setEnabled(ui.includeSlideShow.isSelected());
		    ui.slideShowCommentDelay.setEnabled(ui.includeSlideShow.isSelected());
			ui.slideShowMovieDelay.setEnabled(ui.includeSlideShow.isSelected());
			}
		});
		correctCheckBoxState(ui.includeSlideShow);

		ui.enableDedicatedSlideCommentSection.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.slideCommentHorizontalAlign.setEnabled(ui.enableDedicatedSlideCommentSection.isSelected());
			ui.slideCommentVerticalPosition.setEnabled(ui.enableDedicatedSlideCommentSection.isSelected());
			}
		});
		correctCheckBoxState(ui.enableDedicatedSlideCommentSection );
		if( engine.getSkinVariables().get(Constants.USER_VAR_ENABLE_DEDICATED_SLIDE_COMMENT_SECTION)==null )
			ui.enableDedicatedSlideCommentSection.setSelected(true);

		ui.includeZoomFilterOnThumbnails.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.zoomFilterPercentOnThumbnails.setEnabled(ui.includeZoomFilterOnThumbnails.isSelected());
			ui.prescaleZoomFilterOnThumbnails.setEnabled(ui.includeZoomFilterOnThumbnails.isSelected());
			}
		});
		correctCheckBoxState(ui.includeZoomFilterOnThumbnails);

		ui.includeFixedShapeFilterOnThumbnails.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleFixedShapeFilterOnThumbnails.setEnabled(ui.includeFixedShapeFilterOnThumbnails.isSelected());
			}
		});
		correctCheckBoxState(ui.includeFixedShapeFilterOnThumbnails);

		ui.includeFixedShapeFilterOnSlides.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleFixedShapeFilterOnSlides.setEnabled(ui.includeFixedShapeFilterOnSlides.isSelected());
			}
		});
		correctCheckBoxState(ui.includeFixedShapeFilterOnSlides);

		ui.includeZoomFilterOnSlides.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.zoomFilterPercentOnSlides.setEnabled(ui.includeZoomFilterOnSlides.isSelected());
			ui.prescaleZoomFilterOnSlides.setEnabled(ui.includeZoomFilterOnSlides.isSelected());
			}
		});
		correctCheckBoxState(ui.includeZoomFilterOnSlides);

		ui.includeLogoFilterOnThumbnails.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleLogoFilterOnThumbnails.setEnabled(ui.includeLogoFilterOnThumbnails.isSelected());
			ui.logoFilterSourceOnThumbnails.setEnabled(ui.includeLogoFilterOnThumbnails.isSelected());
			ui.logoFilterMarginOnThumbnails.setEnabled(ui.includeLogoFilterOnThumbnails.isSelected());
			ui.logoFilterHorizontalOffsetOnThumbnails.setEnabled(ui.includeLogoFilterOnThumbnails.isSelected());
			ui.logoFilterVerticalOffsetOnThumbnails.setEnabled(ui.includeLogoFilterOnThumbnails.isSelected());
			ui.logoFilterHorizontalAlignOnThumbnails.setEnabled(ui.includeLogoFilterOnThumbnails.isSelected());
			ui.logoFilterVerticalAlignOnThumbnails.setEnabled(ui.includeLogoFilterOnThumbnails.isSelected());
			}
		});
		correctCheckBoxState(ui.includeLogoFilterOnThumbnails);

		ui.includeLogoFilterOnSlides.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleLogoFilterOnSlides.setEnabled(ui.includeLogoFilterOnSlides.isSelected());
			ui.logoFilterSourceOnSlides.setEnabled(ui.includeLogoFilterOnSlides.isSelected());
			ui.logoFilterMarginOnSlides.setEnabled(ui.includeLogoFilterOnSlides.isSelected());
			ui.logoFilterHorizontalOffsetOnSlides.setEnabled(ui.includeLogoFilterOnSlides.isSelected());
			ui.logoFilterVerticalOffsetOnSlides.setEnabled(ui.includeLogoFilterOnSlides.isSelected());
			ui.logoFilterHorizontalAlignOnSlides.setEnabled(ui.includeLogoFilterOnSlides.isSelected());
			ui.logoFilterVerticalAlignOnSlides.setEnabled(ui.includeLogoFilterOnSlides.isSelected());
			}
		});
		correctCheckBoxState(ui.includeLogoFilterOnSlides);

		ui.includeTextFilterOnThumbnails.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleTextFilterOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterTextOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterFontFaceOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterFontStyleOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterFontSizeOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterColorOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterAntiAliasOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterMarginOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterHorizontalOffsetOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterVerticalOffsetOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterHorizontalAlignOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			ui.textFilterVerticalAlignOnThumbnails.setEnabled(ui.includeTextFilterOnThumbnails.isSelected());
			}
		});
		correctCheckBoxState(ui.includeTextFilterOnThumbnails);

		ui.includeTextFilterOnSlides.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleTextFilterOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterTextOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterFontFaceOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterFontStyleOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterFontSizeOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterColorOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterAntiAliasOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterMarginOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterHorizontalOffsetOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterVerticalOffsetOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterHorizontalAlignOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			ui.textFilterVerticalAlignOnSlides.setEnabled(ui.includeTextFilterOnSlides.isSelected());
			}
		});
		correctCheckBoxState(ui.includeTextFilterOnSlides);

		ui.includeShadowTextFilterOnThumbnails.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleShadowTextFilterOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterTextOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterFontFaceOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterFontStyleOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterFontSizeOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterTextColorOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterShadowColorOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterShadowDistanceOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterAntiAliasOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterMarginOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterHorizontalOffsetOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterVerticalOffsetOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterHorizontalAlignOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			ui.shadowTextFilterVerticalAlignOnThumbnails.setEnabled(ui.includeShadowTextFilterOnThumbnails.isSelected());
			}
		});
		correctCheckBoxState(ui.includeShadowTextFilterOnThumbnails);

		ui.includeShadowTextFilterOnSlides.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleShadowTextFilterOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterTextOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterFontFaceOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterFontStyleOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterFontSizeOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterTextColorOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterShadowColorOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterShadowDistanceOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterAntiAliasOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterMarginOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterHorizontalOffsetOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterVerticalOffsetOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterHorizontalAlignOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			ui.shadowTextFilterVerticalAlignOnSlides.setEnabled(ui.includeShadowTextFilterOnSlides.isSelected());
			}
		});
		correctCheckBoxState(ui.includeShadowTextFilterOnSlides);

		ui.includeWatermarkTextFilterOnThumbnails.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleWatermarkTextFilterOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterTextOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterFontFaceOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterFontStyleOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterFontSizeOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterColorOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterAntiAliasOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterMarginOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterHorizontalOffsetOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterVerticalOffsetOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterHorizontalAlignOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterVerticalAlignOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			ui.watermarkTextFilterStrengthPercentOnThumbnails.setEnabled(ui.includeWatermarkTextFilterOnThumbnails.isSelected());
			}
		});
		correctCheckBoxState(ui.includeWatermarkTextFilterOnThumbnails);

		ui.includeWatermarkTextFilterOnSlides.addItemListener(new ItemListener() {
		   public void itemStateChanged(ItemEvent e) {
			ui.prescaleWatermarkTextFilterOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterTextOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterFontFaceOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterFontStyleOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterFontSizeOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterColorOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterAntiAliasOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterMarginOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterHorizontalOffsetOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterVerticalOffsetOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterHorizontalAlignOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterVerticalAlignOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			ui.watermarkTextFilterStrengthPercentOnSlides.setEnabled(ui.includeWatermarkTextFilterOnSlides.isSelected());
			}
		});
		correctCheckBoxState(ui.includeWatermarkTextFilterOnSlides);
	}

	private void doMainLayout()
	{
		RiverLayout layout = (RiverLayout)ui.getLayout();
		layout.setHgap(0);
		layout.setVgap(0);

		JTabbedPane tabbedPane = new JTabbedPane();

		tabbedPane.addTab("General", new SkinGeneralSection(ui));
		tabbedPane.addTab("Index", new SkinIndexSection(ui));
		tabbedPane.addTab("Slide", new SkinSlideSection(ui));
		tabbedPane.addTab("Frames", new SkinFramesSection(ui, window, engine));
		tabbedPane.addTab("Viewer Remarks", new SkinRemarksSection(ui));
		tabbedPane.addTab("Advanced", new SkinAdvancedSection(ui));
		tabbedPane.addTab("Filter Management", new SkinFilterManagementSection(ui));
		tabbedPane.addTab("About...", new SkinAboutSection(ui));
		ui.add("vtop hfill vfill", tabbedPane);
	}

	private void setupThemeNotification()
	{
		window.addJAlbumListener(new JAlbumAdapter() {
			public void styleChanged(JAlbumEvent e) {
				// Load the current style's default user variables found in the file
				// "res/styles/<styleName>/theme.properties".
				if( !window.useLayoutHints.isSelected() )
					return;

				try
				{
					window.ui2Engine();
				}
				catch( BeanBinderException ex )
				{
					log(ex);
				}

				String chosenStyle = engine.getStyle();
				int index = chosenStyle.toLowerCase().indexOf(".css");

				chosenStyle = (index!=-1) ? chosenStyle.substring(0, index) : chosenStyle;

				File styleDefaultsFile = new File(skinResDirectory, "/styles/" + chosenStyle + "/" + Constants.SKIN_THEME_VARIABLES);

				if (!styleDefaultsFile.exists())
					return;

				Properties styleDefaults = new Properties();

				try
				{
					styleDefaults.load(new FileInputStream(styleDefaultsFile));
				}
				catch( IOException ex )
				{
					log("Error loading the defaults for the currently selected theme!", ex);
				}
				se.datadosen.util.PropertyBinder.syncUI(styleDefaults, ui);
			}

			public void	skinChanged(JAlbumEvent e) {
				window.removeJAlbumListener(this);
			}

			public void	skinUIDisplayed(JAlbumEvent e) {
				try
				{
					window.ui2Engine();
				}
				catch( Exception ex )
				{
					log(ex);
				}
				ui.includeMoveForwardFacility.setEnabled(!engine.getImageLinking().equals(AlbumBean.LINK_ORIGINALS_VIA_SCALED));
			}
		});
	}

	private void setupImageLinkingNotification()
	{
		try
		{
			window.ui2Engine();
		}
		catch( BeanBinderException e )
		{
			log(e);
		}
		ui.includeMoveForwardFacility.setEnabled(engine.getImageLinking().equals(AlbumBean.LINK_ORIGINALS_VIA_SCALED));
	}

	private void correctCheckBoxState(JCheckBox chk)
	{
		chk.setSelected( !chk.isSelected() );
		chk.setSelected( !chk.isSelected() );
	}

	private void setItemsForComboBox(JComboBox combo, List items)
	{
		Collections.sort(items);
		combo.removeAllItems();

		Iterator it = items.iterator();

		while( it.hasNext() )
			combo.addItem( it.next() );
	}

	private void setItemsForComboBox(JComboBox combo, Object[] items)
	{
		Arrays.sort(items);
		combo.removeAllItems();

		for( int i=0; i<items.length; i++ )
			combo.addItem( items[i] );
	}

	private List getIconSets()
	{
		Iterator it = Arrays.asList(new File(skinResDirectory, Constants.SKIN_ACTION_RESOURCE_DIR).listFiles()).iterator();
		List result = new LinkedList();

		result.add( "" );
		while( it.hasNext() )
		{
			File file = (File)it.next();

			if( !file.isDirectory() )
				continue;

			result.add( file.getName() );
		}
		return result;
	}
}
