
import javax.swing.*;

import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;

public class SkinIndexSection extends SkinAbstractSection
{
	public SkinIndexSection(SkinPanel ui)
	{
		super(new RiverLayout(0, 0), ui);

		add("p vtop hfill", getIndexEffectsPanel());
		add("p hfill", getIndexContentPanel());
	}

	private ControlPanel getIndexContentPanel()
	{
		ControlPanel ccIndexContent = createControlPanel("Index Displayed Information", 3);

		ccIndexContent.add(new JLabel("Thumbnail Tooltip Content"));
		ccIndexContent.add("tab hfill", ui.thumbnailTooltipContent);
		ccIndexContent.add("br", new JLabel("Thumbnail Caption Content"));
		ccIndexContent.add("tab hfill", ui.thumbnailCaptionContent);

		ccIndexContent.add("br", new JLabel("Folder Tooltip Content"));
		ccIndexContent.add("tab hfill", ui.folderTooltipContent);
		ccIndexContent.add("br", new JLabel("Folder Caption Content"));
		ccIndexContent.add("tab hfill", ui.folderCaptionContent);
		return ccIndexContent;
	}

	private ControlPanel getIndexEffectsPanel()
	{
		ControlPanel ccIndexEffects = createControlPanel("Page Effects", 3);

		ccIndexEffects.add(ui.includeBlendingEffectOnIndexes);
		return ccIndexEffects;
	}
}
