
import java.io.File;
import javax.swing.*;

import se.datadosen.component.ControlPanel;
import se.datadosen.component.JColorSelector;
import se.datadosen.jalbum.AlbumBean;

public class SkinPanel extends ControlPanel
{
	public SkinPanel(AlbumBean albumBean)
	{
		File skinDirectory = new BPPCompiledScript(albumBean).skinDirectory;
		File framesDirectory = new File(skinDirectory, Constants.SKIN_FRAME_CONFIG_DIR);
		File languagesDirectory = new File(skinDirectory, "texts");

		slideFrameType = new FrameTypeComboBox(framesDirectory);
		movieSlideFrameType = new FrameTypeComboBox(framesDirectory);
		thumbnailFrameType = new FrameTypeComboBox(framesDirectory);
		folderThumbnailFrameType = new FrameTypeComboBox(framesDirectory);

		language = new LanguageComboBox(languagesDirectory);
	}

	JCheckBox includeViewerRemarksOnSlides = new JCheckBox("Include Viewer Remarks Feature On Slides");
	JCheckBox includeViewerRemarksOnFolders = new JCheckBox("Include Viewer Remarks Feature On Folders");
	JCheckBox remarksForceVisible = new JCheckBox("Open Remarks Section by default");
	JTextField remarksDatabaseUrl = new JTextField(15);
	JTextField remarksDatabaseName = new JTextField(10);
	JTextField remarksDatabaseUserName = new JTextField(10);
	JTextField remarksDatabasePassword = new JTextField(10);
	JTextField remarksDatabaseTableName = new JTextField(10);
	JTextField remarksAdminUser = new JTextField(10);
	JTextField remarksAdminPassword = new JTextField(10);
	JTextField remarksDateFormat = new JTextField(8);
	JTextField remarksDateSuffix = new JTextField(8);
	JCheckBox remarksNotifyViaEmail = new JCheckBox("Notify via E-Mail");
	JTextField remarksNotifyToEmail = new JTextField(20);
	JTextField remarksNotifyFromEmail = new JTextField(20);

	JCheckBox includeKeyboardSupport = new JCheckBox("Include Keyboard Support");
	//JCheckBox chooseRandomIconForFolder = new JCheckBox("Choose Random Icon For Folders");
	JCheckBox includeJumpToPageAction = new JCheckBox("Include Jump-To-Page Facility");
	JCheckBox includeFirstLastPageActions = new JCheckBox("Include First & Last Page Actions");
	JCheckBox includeSaveProtection = new JCheckBox("Include Image Save-Protection");
	JCheckBox includeNavigationHelpTips = new JCheckBox("Include Navigation Tips (mostly shortcuts)");
	JComboBox contextHelpStyle = new JComboBox( new Object[]
		{ "None", "ToolTip", "StatusBar", "Both" }
	);
	JComboBox navigationBarVerticalLocation = new JComboBox( new Object[]
		{ "", "Top", "Bottom", "Both" }
	);
	JTextField externalHomePath = new JTextField(20);
	JTextField title = new JTextField(20);
	JComboBox iconSet = new JComboBox();
	JTextField albumCopyright = new JTextField(20);
	JComboBox language = null;
	JCheckBox prefetchSiblingSlides = new JCheckBox("Prefetch/Preload Sibling Slides");

	JCheckBox showAudioConsole = new JCheckBox("Show Audio Console");
	JTextField audioConsoleDimension = new JTextField(5);

	JComboBox printing = Printing.getPrintingComboBox();

	JCheckBox includeMoveForwardFacility = new JCheckBox("Include Move-Forward Facility");

	JCheckBox includeSlideShow = new JCheckBox("Include Slide Show");
	JCheckBox cyclicSlideShow = new JCheckBox("Cyclic Slide Show");
	JTextField slideShowDelay = new JTextField(2);
	JTextField slideShowCommentDelay = new JTextField(2);
	JTextField slideShowMovieDelay = new JTextField(2);

	JCheckBox includeSlidePageThumbnails = new JCheckBox("Include Thumbnails");
	JTextField slidePageThumbnailCount = new JTextField(2);
	JTextField slidePageThumbnailRatio = new JTextField(3);
	JComboBox movieSlideDimension = new JComboBox(new Object[]
		{ "", "160x120", "320x240", "640x480", "800x600", "1024x768" }
	);

	JCheckBox enableDedicatedSlideCommentSection = new JCheckBox("Enable Dedicated Comment Section");
	JComboBox slideCommentHorizontalAlign = new JComboBox(new Object[]
		{ "", "Left", "Center", "Right" }
	);
	JComboBox slideCommentVerticalPosition = new JComboBox(new Object[]
		{ "", "TOP_ABOVE_NAVIGATION", "TOP_UNDER_NAVIGATION", "BOTTOM" }
	);

	JComboBox metadataDisplayMode = new JComboBox(new Object[]
		{ "", "all", "verbose", "custom", "iptc-only" }
	);
	JTextArea customMetadataFields = new JTextArea(4, 20);

	JCheckBox includeBlendingEffectOnSlides = new JCheckBox("Include Page Blending/Fading");
	JCheckBox includeBlendingEffectOnIndexes = new JCheckBox("Include Page Blending/Fading");

	JComboBox slideFrameType = null;
	JComboBox movieSlideFrameType = null;
	JComboBox thumbnailFrameType = null;
	JComboBox folderThumbnailFrameType = null;
	JTextField slideFrameRatio = new JTextField(3);
	JTextField movieSlideFrameRatio = new JTextField(3);
	JTextField thumbnailFrameRatio = new JTextField(3);
	JTextField folderThumbnailFrameRatio = new JTextField(3);

	JTextField thumbnailTooltipContent = new JTextField(20);
	JTextField thumbnailCaptionContent = new JTextField(20);
	JTextField folderTooltipContent = new JTextField(20);
	JTextField folderCaptionContent = new JTextField(20);
	JTextField slideCaptionContent = new JTextField(20);
	JTextField slideBreadcrumbTrailContent = new JTextField(10);

	JCheckBox enableTextTruncation = new JCheckBox("Enable Text Truncation");
	JTextField maximumFolderLengthOnPathBar = new JTextField(3);
	JTextField maximumThumbnailCaptionLength = new JTextField(3);

	/////////////// Filters
	JCheckBox keepFiltersDefinedOutsideFMTabs = new JCheckBox("Keep filters defined outside of Filter Management Tabs");

	JCheckBox includeFixedShapeFilterOnThumbnails = new JCheckBox("Crop thumbs to fixed size");
	JCheckBox prescaleFixedShapeFilterOnThumbnails = new JCheckBox("Prescale");
	JCheckBox includeFixedShapeFilterOnSlides = new JCheckBox("Crop slides to fixed size");
	JCheckBox prescaleFixedShapeFilterOnSlides = new JCheckBox("Prescale");

	JCheckBox includeGrayScaleFilterOnThumbnails = new JCheckBox("Grayscale thumbs");
	JCheckBox includeGrayScaleFilterOnSlides = new JCheckBox("Grayscale slides");

	JCheckBox includeZoomFilterOnThumbnails = new JCheckBox("Thumbnails zoom");
	JCheckBox prescaleZoomFilterOnThumbnails = new JCheckBox("Prescale");
	JTextField zoomFilterPercentOnThumbnails = new JTextField(2);
	JCheckBox includeZoomFilterOnSlides = new JCheckBox("Slides zoom");
	JCheckBox prescaleZoomFilterOnSlides = new JCheckBox("Prescale");
	JTextField zoomFilterPercentOnSlides = new JTextField(2);

	JCheckBox includeLogoFilterOnThumbnails = new JCheckBox("Logo on thumbs");
	JCheckBox prescaleLogoFilterOnThumbnails = new JCheckBox("Prescale");
	JTextField logoFilterSourceOnThumbnails = new JTextField(15);
	JTextField logoFilterMarginOnThumbnails = new JTextField(2);
	JTextField logoFilterHorizontalOffsetOnThumbnails = new JTextField(2);
	JTextField logoFilterVerticalOffsetOnThumbnails = new JTextField(2);
	JComboBox logoFilterHorizontalAlignOnThumbnails = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox logoFilterVerticalAlignOnThumbnails = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);
	JCheckBox includeLogoFilterOnSlides = new JCheckBox("Logo on slides");
	JCheckBox prescaleLogoFilterOnSlides = new JCheckBox("Prescale");
	JTextField logoFilterSourceOnSlides = new JTextField(15);
	JTextField logoFilterMarginOnSlides = new JTextField(2);
	JTextField logoFilterHorizontalOffsetOnSlides = new JTextField(2);
	JTextField logoFilterVerticalOffsetOnSlides = new JTextField(2);
	JComboBox logoFilterHorizontalAlignOnSlides = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox logoFilterVerticalAlignOnSlides = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);

	JCheckBox includeTextFilterOnThumbnails = new JCheckBox("Text on thumbs");
	JCheckBox prescaleTextFilterOnThumbnails = new JCheckBox("Prescale");
	JTextField textFilterTextOnThumbnails = new JTextField(15);
	JComboBox textFilterFontFaceOnThumbnails = new JComboBox();
	JComboBox textFilterFontStyleOnThumbnails = new JComboBox( new Object[]
		{"plain", "bold", "italic", "bolditalic"}
	);
	JTextField textFilterFontSizeOnThumbnails = new JTextField(2);
	JColorSelector textFilterColorOnThumbnails = new JColorSelector("Text Color");
	JCheckBox textFilterAntiAliasOnThumbnails = new JCheckBox("Anti-alias");
	JTextField textFilterMarginOnThumbnails = new JTextField(2);
	JTextField textFilterHorizontalOffsetOnThumbnails = new JTextField(2);
	JTextField textFilterVerticalOffsetOnThumbnails = new JTextField(2);
	JComboBox textFilterHorizontalAlignOnThumbnails = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox textFilterVerticalAlignOnThumbnails = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);
	JCheckBox includeTextFilterOnSlides = new JCheckBox("Text on slides");
	JCheckBox prescaleTextFilterOnSlides = new JCheckBox("Prescale");
	JTextField textFilterTextOnSlides = new JTextField(15);
	JComboBox textFilterFontFaceOnSlides = new JComboBox();
	JComboBox textFilterFontStyleOnSlides = new JComboBox( new Object[]
		{"plain", "bold", "italic", "bolditalic"}
	);
	JTextField textFilterFontSizeOnSlides = new JTextField(2);
	JColorSelector textFilterColorOnSlides = new JColorSelector("Text Color");
	JCheckBox textFilterAntiAliasOnSlides = new JCheckBox("Anti-alias");
	JTextField textFilterMarginOnSlides = new JTextField(2);
	JTextField textFilterHorizontalOffsetOnSlides = new JTextField(2);
	JTextField textFilterVerticalOffsetOnSlides = new JTextField(2);
	JComboBox textFilterHorizontalAlignOnSlides = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox textFilterVerticalAlignOnSlides = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);

	JCheckBox includeShadowTextFilterOnThumbnails = new JCheckBox("Shadow Text on thumbs");
	JCheckBox prescaleShadowTextFilterOnThumbnails = new JCheckBox("Prescale");
	JTextField shadowTextFilterTextOnThumbnails = new JTextField(15);
	JComboBox shadowTextFilterFontFaceOnThumbnails = new JComboBox();
	JComboBox shadowTextFilterFontStyleOnThumbnails = new JComboBox( new Object[]
		{"plain", "bold", "italic", "bolditalic"}
	);
	JTextField shadowTextFilterFontSizeOnThumbnails = new JTextField(2);
	JColorSelector shadowTextFilterTextColorOnThumbnails = new JColorSelector("Text Color");
	JColorSelector shadowTextFilterShadowColorOnThumbnails = new JColorSelector("Shadow Color");
	JTextField shadowTextFilterShadowDistanceOnThumbnails = new JTextField(2);
	JCheckBox shadowTextFilterAntiAliasOnThumbnails = new JCheckBox("Anti-alias");
	JTextField shadowTextFilterMarginOnThumbnails = new JTextField(2);
	JTextField shadowTextFilterHorizontalOffsetOnThumbnails = new JTextField(2);
	JTextField shadowTextFilterVerticalOffsetOnThumbnails = new JTextField(2);
	JComboBox shadowTextFilterHorizontalAlignOnThumbnails = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox shadowTextFilterVerticalAlignOnThumbnails = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);
	JCheckBox includeShadowTextFilterOnSlides = new JCheckBox("Shadow Text on slides");
	JCheckBox prescaleShadowTextFilterOnSlides = new JCheckBox("Prescale");
	JTextField shadowTextFilterTextOnSlides = new JTextField(15);
	JComboBox shadowTextFilterFontFaceOnSlides = new JComboBox();
	JComboBox shadowTextFilterFontStyleOnSlides = new JComboBox( new Object[]
		{"plain", "bold", "italic", "bolditalic"}
	);
	JTextField shadowTextFilterFontSizeOnSlides = new JTextField(2);
	JColorSelector shadowTextFilterTextColorOnSlides = new JColorSelector("Text Color");
	JColorSelector shadowTextFilterShadowColorOnSlides = new JColorSelector("Shadow Color");
	JTextField shadowTextFilterShadowDistanceOnSlides = new JTextField(2);
	JCheckBox shadowTextFilterAntiAliasOnSlides = new JCheckBox("Anti-alias");
	JTextField shadowTextFilterMarginOnSlides = new JTextField(2);
	JTextField shadowTextFilterHorizontalOffsetOnSlides = new JTextField(2);
	JTextField shadowTextFilterVerticalOffsetOnSlides = new JTextField(2);
	JComboBox shadowTextFilterHorizontalAlignOnSlides = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox shadowTextFilterVerticalAlignOnSlides = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);

	JCheckBox includeWatermarkTextFilterOnThumbnails = new JCheckBox("Watermark Text on thumbs");
	JCheckBox prescaleWatermarkTextFilterOnThumbnails = new JCheckBox("Prescale");
	JTextField watermarkTextFilterTextOnThumbnails = new JTextField(15);
	JComboBox watermarkTextFilterFontFaceOnThumbnails = new JComboBox();
	JComboBox watermarkTextFilterFontStyleOnThumbnails = new JComboBox( new Object[]
		{"plain", "bold", "italic", "bolditalic"}
	);
	JTextField watermarkTextFilterFontSizeOnThumbnails = new JTextField(2);
	JColorSelector watermarkTextFilterColorOnThumbnails = new JColorSelector("Text Color");
	JCheckBox watermarkTextFilterAntiAliasOnThumbnails = new JCheckBox("Anti-alias");
	JTextField watermarkTextFilterMarginOnThumbnails = new JTextField(2);
	JTextField watermarkTextFilterHorizontalOffsetOnThumbnails = new JTextField(2);
	JTextField watermarkTextFilterVerticalOffsetOnThumbnails = new JTextField(2);
	JComboBox watermarkTextFilterHorizontalAlignOnThumbnails = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox watermarkTextFilterVerticalAlignOnThumbnails = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);
	JTextField watermarkTextFilterStrengthPercentOnThumbnails = new JTextField(2);
	JCheckBox includeWatermarkTextFilterOnSlides = new JCheckBox("Watermark Text on slides");
	JCheckBox prescaleWatermarkTextFilterOnSlides = new JCheckBox("Prescale");
	JTextField watermarkTextFilterTextOnSlides = new JTextField(15);
	JComboBox watermarkTextFilterFontFaceOnSlides = new JComboBox();
	JComboBox watermarkTextFilterFontStyleOnSlides = new JComboBox( new Object[]
		{"plain", "bold", "italic", "bolditalic"}
	);
	JTextField watermarkTextFilterFontSizeOnSlides = new JTextField(2);
	JColorSelector watermarkTextFilterColorOnSlides = new JColorSelector("Shadow Color");
	JCheckBox watermarkTextFilterAntiAliasOnSlides = new JCheckBox("Anti-alias");
	JTextField watermarkTextFilterMarginOnSlides = new JTextField(2);
	JTextField watermarkTextFilterHorizontalOffsetOnSlides = new JTextField(2);
	JTextField watermarkTextFilterVerticalOffsetOnSlides = new JTextField(2);
	JComboBox watermarkTextFilterHorizontalAlignOnSlides = new JComboBox( new Object[]
		{"left", "right", "center"}
	);
	JComboBox watermarkTextFilterVerticalAlignOnSlides = new JComboBox( new Object[]
		{"top", "bottom", "center"}
	);
	JTextField watermarkTextFilterStrengthPercentOnSlides = new JTextField(2);
}
