
import javax.swing.*;

import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;

public class SkinRemarksSection extends SkinAbstractSection
{
	public SkinRemarksSection(SkinPanel ui)
	{
		super(new RiverLayout(0, 0), ui);

		ControlPanel ccDatabase = createControlPanel("Database", 5, 3);
		ControlPanel ccNotification = createControlPanel("Notification", 5, 3);
		ControlPanel ccAlbum = createControlPanel("Album", 5, 3);

		ccDatabase.add(new JLabel("URL:"));
		ccDatabase.add("tab", ui.remarksDatabaseUrl);
		ccDatabase.add("tab", new JLabel("User Name:"));
		ccDatabase.add("tab", ui.remarksDatabaseUserName);
		ccDatabase.add("br", new JLabel("DB Name:"));
		ccDatabase.add("tab", ui.remarksDatabaseName);
		ccDatabase.add("tab", new JLabel("Password:"));
		ccDatabase.add("tab", ui.remarksDatabasePassword);
		ccDatabase.add("br", new JLabel("Table Name:"));
		ccDatabase.add("tab", ui.remarksDatabaseTableName);

		ccAlbum.add(new JLabel("Admin Username:"));
		ccAlbum.add("tab", ui.remarksAdminUser);
		ccAlbum.add("tab", new JLabel("Admin Password:"));
		ccAlbum.add("tab", ui.remarksAdminPassword);
		ccAlbum.add("br", new JLabel("Date Format:"));
		ccAlbum.add("tab", ui.remarksDateFormat);
		ccAlbum.add("tab", new JLabel("Date Suffix:"));
		ccAlbum.add("tab", ui.remarksDateSuffix);

		ccNotification.add(ui.remarksNotifyViaEmail);
		ccNotification.add("br", new JLabel("'To' E-Mail:"));
		ccNotification.add("tab", ui.remarksNotifyToEmail);
		ccNotification.add("tab", new JLabel("'From' E-Mail:"));
		ccNotification.add("tab", ui.remarksNotifyFromEmail);

		add(new JLabel("Note: This feature needs server side PHP support as well as a MySQL database server; the album"));
		add("br", new JLabel("           will need to be viewed from a web server for the feature to function."));
		add("br", ui.includeViewerRemarksOnSlides );
		add("tab", ui.includeViewerRemarksOnFolders );
		add("br", ui.remarksForceVisible);
		add("br hfill", ccDatabase);
		add("br hfill", ccAlbum);
		add("br hfill", ccNotification);
	}
}
