import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.*;
import java.awt.color.*;

/**
 * Title:        JAlbum ColorMap image filter
 * Copyright:    Copyright (c) 2006
 * Company:      LazaDezign
 * @author Molnar Laszlo
 * @version 1.0
 */

public class ColorMapFilter implements JAFilter {

	private long r0 = 32;
	private long g0 = 28;
	private long b0 = 11;

	private long r1 = 136;
	private long g1 = 127;
	private long b1 = 100;
	
	private long r2 = 246;
	private long g2 = 238;
	private long b2 = 203;

	public void setDarkColor(String s) {
	if(s.length() == 7 && s.charAt(0) == '#') {
		r0 = Integer.parseInt(s.substring(1,3), 16);
		g0 = Integer.parseInt(s.substring(3,5), 16);
		b0 = Integer.parseInt(s.substring(5,7), 16);
	}}

	public void setMediumColor(String s) {
	if(s.length() == 7 && s.charAt(0) == '#') {
		r1 = Integer.parseInt(s.substring(1,3), 16);
		g1 = Integer.parseInt(s.substring(3,5), 16);
		b1 = Integer.parseInt(s.substring(5,7), 16);
	}}

	public void setLightColor(String s) {
	if(s.length() == 7 && s.charAt(0) == '#') {
		r2 = Integer.parseInt(s.substring(1,3), 16);
		g2 = Integer.parseInt(s.substring(3,5), 16);
		b2 = Integer.parseInt(s.substring(5,7), 16);
	}}

	public String getName() {
		return "ColorMap filter";
	}

	public String getDescription() {
		return "Makes a color gradient map beetween three colors";
	}

	public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
		byte[][] colorBytes = new byte[3][256];

		for (int i = 0; i < 128; i++) {
			colorBytes[0][i] = (byte)(r0 + ((r1-r0) * i) / 128);
			colorBytes[1][i] = (byte)(g0 + ((g1-g0) * i) / 128);
			colorBytes[2][i] = (byte)(b0 + ((b1-b0) * i) / 128);
		}

		for (int i = 128; i < 256; i++) {
			colorBytes[0][i] = (byte)(r1 + ((r2-r1) * (i-128)) / 128);
			colorBytes[1][i] = (byte)(g1 + ((g2-g1) * (i-128)) / 128);
			colorBytes[2][i] = (byte)(b1 + ((b2-b1) * (i-128)) / 128);
		}

		ByteLookupTable colorLookup = new ByteLookupTable(0, colorBytes);
		LookupOp theOp = new LookupOp(colorLookup, null);
		return theOp.filter(bi, null);
    }
}
