<%
  // Try to replace folder icons with prepresentative image from subdirectory
  import se.datadosen.util.*;

  if (currentFile.isDirectory()) {
    File subDir = currentFile;
    File iconFile = null;

    // If meta.properties exists and points to an icon file, use it
    File propsFile = new File(subDir, "meta.properties");
    if (propsFile.exists()) {
      Properties props = IO.readPropertyFile(propsFile);

      String newComment = props.get("description");
      if (newComment != null) {
         dirDescription = newComment;
      }
      String newLabel = props.get("title");
      if (newLabel != null) {
         label = newLabel;
      }
      String newIcon = props.get("folderIcon");
      if (newIcon != null) {
          iconFile = new File(subDir, props.get("folderIcon"));
      }

    }
    else {
      // Try to use the first image as folder icon
      File[] list = subDir.listFiles();
      for (int i=0; i<list.length; i++) {
        if (FileFilters.isFileSupported(list[i])) {
          iconFile = list[i];
          break;
        }
      }
    }

    if (iconFile != null) {
      // Process this image so we can extract width and height
      setAccessibility(true);  // Turn on access to private methods
      engine.registerVariables(iconFile, outputDirectory);  // Private = might change
      Map vars = fileVariables.get(iconFile);
      // Redefine variables
      iconPath = engine.encode(subDir.getName() + "/thumbs/" +
       engine.jpegName(iconFile.getName()));
      thumbWidth = vars.get("thumbWidth");
      thumbHeight = vars.get("thumbHeight");
    }

  }
%>
