/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo;

import java.awt.Color;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

class ComplexDemo {
    private static final String filename = "complexdemo";

    ComplexDemo() {
    }

    private static String getPath(String string) {
        return Util.getJRobinDemoPath("complexdemo." + string);
    }

    private static String getPath(int n, String string) {
        return Util.getJRobinDemoPath(filename + n + "." + string);
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void createDatabase(String string) throws IOException, RrdException {
        String string2 = ComplexDemo.getPath("rrd");
        ComplexDemo.println("-- Importing XML file: " + string);
        ComplexDemo.println("-- to RRD file: " + string2);
        RrdDbPool rrdDbPool = RrdDbPool.getInstance();
        RrdDb rrdDb = rrdDbPool.requestRrdDb(string2, string);
        ComplexDemo.println("-- RRD file created");
        rrdDbPool.release(rrdDb);
    }

    private static void createGraphs() throws RrdException, IOException {
        RrdGraph rrdGraph = new RrdGraph(true);
        String string = ComplexDemo.getPath("rrd");
        ComplexDemo.println("-- Creating graph 1");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2003, 7, 20);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2003, 7, 27);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(gregorianCalendar, gregorianCalendar2);
        rrdGraphDef.setImageBorder(Color.GRAY, 1);
        rrdGraphDef.setTitle("JRobinComplexDemo@Ldemo graph 1@r\nNetwork traffic overview");
        rrdGraphDef.setVerticalLabel("bits per second");
        rrdGraphDef.datasource("ifInOctets", string, "ifInOctets", "AVERAGE");
        rrdGraphDef.datasource("ifOutOctets", string, "ifOutOctets", "AVERAGE");
        rrdGraphDef.datasource("bitIn", "ifInOctets,8,*");
        rrdGraphDef.datasource("bitOut", "ifOutOctets,8,*");
        rrdGraphDef.comment(" ");
        rrdGraphDef.area("bitIn", new Color(0, 255, 0), "Incoming traffic ");
        rrdGraphDef.line("bitOut", new Color(0, 0, 51), "Outgoing traffic\n\n");
        rrdGraphDef.gprint("bitIn", "MAX", "Max:   @6.1 @sbit/s");
        rrdGraphDef.gprint("bitOut", "MAX", "      @6.1 @sbit/s\n");
        rrdGraphDef.gprint("bitIn", "MIN", "Min:   @6.1 @sbit/s");
        rrdGraphDef.gprint("bitOut", "MIN", "      @6.1 @sbit/s");
        rrdGraphDef.comment("       Connection:  100 Mbit/s\n");
        rrdGraphDef.gprint("bitIn", "AVG", "Avg:   @6.1 @sbit/s");
        rrdGraphDef.gprint("bitOut", "AVG", "      @6.1 @sbit/s");
        rrdGraphDef.comment("       Duplex mode: FD - fixed\n\n");
        rrdGraphDef.gprint("bitIn", "LAST", "Cur:   @6.1 @sbit/s");
        rrdGraphDef.gprint("bitOut", "LAST", "      @6.1 @sbit/s\n\n");
        rrdGraphDef.comment("[ courtesy of www.cherrymon.org ]@L");
        rrdGraphDef.comment("Generated: " + ComplexDemo.timestamp() + "  @r");
        rrdGraph.setGraphDef(rrdGraphDef);
        String string2 = ComplexDemo.getPath(1, "png");
        rrdGraph.saveAsPNG(string2);
        String string3 = ComplexDemo.getPath(1, "gif");
        rrdGraph.saveAsGIF(string3);
        String string4 = ComplexDemo.getPath(1, "jpg");
        rrdGraph.saveAsJPEG(string4, 0.6f);
        ComplexDemo.println("-- Creating graph 2");
        gregorianCalendar = new GregorianCalendar(2003, 7, 19);
        gregorianCalendar2 = new GregorianCalendar(2003, 7, 20);
        rrdGraphDef = new RrdGraphDef(gregorianCalendar, gregorianCalendar2);
        rrdGraphDef.setImageBorder(Color.GRAY, 1);
        rrdGraphDef.setTitle("JRobinComplexDemo@Ldemo graph 2@r\nServer load and CPU utilization");
        rrdGraphDef.datasource("load", string, "serverLoad", "AVERAGE");
        rrdGraphDef.datasource("user", string, "serverCPUUser", "AVERAGE");
        rrdGraphDef.datasource("nice", string, "serverCPUNice", "AVERAGE");
        rrdGraphDef.datasource("system", string, "serverCPUSystem", "AVERAGE");
        rrdGraphDef.datasource("idle", string, "serverCPUIdle", "AVERAGE");
        rrdGraphDef.datasource("total", "user,nice,+,system,+,idle,+");
        rrdGraphDef.datasource("busy", "user,nice,+,system,+,total,/,100,*");
        rrdGraphDef.datasource("p25t50", "busy,25,GT,busy,50,LE,load,0,IF,0,IF");
        rrdGraphDef.datasource("p50t75", "busy,50,GT,busy,75,LE,load,0,IF,0,IF");
        rrdGraphDef.datasource("p75t90", "busy,75,GT,busy,90,LE,load,0,IF,0,IF");
        rrdGraphDef.datasource("p90t100", "busy,90,GT,load,0,IF");
        rrdGraphDef.comment("CPU utilization (%)\n ");
        rrdGraphDef.area("load", new Color(102, 153, 204), " 0 - 25%");
        rrdGraphDef.area("p25t50", new Color(0, 102, 153), "25 - 50%@L");
        rrdGraphDef.gprint("busy", "MIN", "Minimum:@5.1@s%");
        rrdGraphDef.gprint("busy", "MAX", "Maximum:@5.1@s% @r ");
        rrdGraphDef.area("p50t75", new Color(102, 102, 0), "50 - 75%");
        rrdGraphDef.area("p75t90", new Color(255, 102, 0), "75 - 90%");
        rrdGraphDef.area("p90t100", new Color(204, 51, 0), "90 - 100%@L");
        rrdGraphDef.gprint("busy", "AVG", " Average:@5.1@s%");
        rrdGraphDef.gprint("busy", "LAST", "Current:@5.1@s% @r ");
        rrdGraphDef.comment("\nServer load\n ");
        rrdGraphDef.line("load", new Color(0, 0, 0), "Load average (5 min)@L");
        rrdGraphDef.gprint("load", "MIN", "Minimum:@5.2@s%");
        rrdGraphDef.gprint("load", "MAX", "Maximum:@5.2@s% @r ");
        rrdGraphDef.gprint("load", "AVG", "Average:@5.2@s%");
        rrdGraphDef.gprint("load", "LAST", "Current:@5.2@s% @r");
        rrdGraphDef.comment("\n\n[ courtesy of www.cherrymon.org ]@L");
        rrdGraphDef.comment("Generated: " + ComplexDemo.timestamp() + "  @r");
        rrdGraph.setGraphDef(rrdGraphDef);
        string2 = ComplexDemo.getPath(2, "png");
        rrdGraph.saveAsPNG(string2);
        string3 = ComplexDemo.getPath(2, "gif");
        rrdGraph.saveAsGIF(string3);
        string4 = ComplexDemo.getPath(2, "jpg");
        rrdGraph.saveAsJPEG(string4, 0.6f);
        ComplexDemo.println("-- Creating graph 3");
        gregorianCalendar = new GregorianCalendar(2003, 7, 19, 12, 0);
        gregorianCalendar2 = new GregorianCalendar(2003, 7, 20, 12, 0);
        rrdGraphDef = new RrdGraphDef(gregorianCalendar, gregorianCalendar2);
        rrdGraphDef.setImageBorder(Color.GRAY, 1);
        rrdGraphDef.setFrontGrid(false);
        rrdGraphDef.setTitle("JRobinComplexDemo@Ldemo graph 3@r\nFTP Usage");
        rrdGraphDef.datasource("ftp", string, "ftpUsers", "AVERAGE");
        rrdGraphDef.line("ftp", new Color(0, 0, 51), "FTP connections");
        rrdGraphDef.gprint("ftp", "AVG", "( average: @0,");
        rrdGraphDef.gprint("ftp", "MIN", "never below: @0 )\n\n");
        rrdGraphDef.comment("  Usage spread:");
        rrdGraphDef.area(new GregorianCalendar(2003, 7, 19, 17, 0), Double.MIN_VALUE, new GregorianCalendar(2003, 7, 19, 23, 0), Double.MAX_VALUE, Color.RED, "peak period");
        rrdGraphDef.area(new GregorianCalendar(2003, 7, 20, 5, 0), Double.MIN_VALUE, new GregorianCalendar(2003, 7, 20, 8, 30), Double.MAX_VALUE, Color.LIGHT_GRAY, "quiet period\n");
        rrdGraphDef.comment("  Rise/descend:");
        rrdGraphDef.area("ftp", new Color(0, 0, 51), null);
        rrdGraphDef.line(new GregorianCalendar(2003, 7, 19, 12, 0), 110.0, new GregorianCalendar(2003, 7, 19, 20, 30), 160.0, Color.PINK, "climb slope", 2);
        rrdGraphDef.line(new GregorianCalendar(2003, 7, 19, 20, 30), 160.0, new GregorianCalendar(2003, 7, 20, 8, 0), 45.0, Color.CYAN, "fall-back slope\n", 2);
        rrdGraphDef.vrule(new GregorianCalendar(2003, 7, 20), Color.YELLOW, null);
        rrdGraphDef.comment("\n\n[ courtesy of www.cherrymon.org ]@L");
        rrdGraphDef.comment("Generated: " + ComplexDemo.timestamp() + "  @r");
        rrdGraph.setGraphDef(rrdGraphDef);
        string2 = ComplexDemo.getPath(3, "png");
        rrdGraph.saveAsPNG(string2, 500, 300);
        string3 = ComplexDemo.getPath(3, "gif");
        rrdGraph.saveAsGIF(string3, 500, 300);
        string4 = ComplexDemo.getPath(3, "jpg");
        rrdGraph.saveAsJPEG(string4, 500, 300, 0.6f);
        ComplexDemo.println("-- Finished");
        ComplexDemo.println("**************************************");
        ComplexDemo.println("Check your " + Util.getJRobinDemoDirectory() + " directory.");
        ComplexDemo.println("You should see nine nice looking graphs starting with [complexdemo],");
        ComplexDemo.println("three different graphs, each in three different image formats");
        ComplexDemo.println("**************************************");
    }

    private static String timestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        return simpleDateFormat.format(new Date());
    }

    public static void main(String[] stringArray) throws IOException, RrdException {
        if (stringArray.length == 0) {
            ComplexDemo.println("Usage: ComplexDemo [path to rrdtool_dump.xml file]");
            ComplexDemo.println("You can download separate rrdtool_dump.xml file from:");
            ComplexDemo.println("http://www.sourceforge.net/projects/jrobin");
            System.exit(-1);
        }
        long l = System.currentTimeMillis();
        ComplexDemo.println("********************************************************************");
        ComplexDemo.println("* JRobinComplexDemo                                                *");
        ComplexDemo.println("*                                                                  *");
        ComplexDemo.println("* This demo creates 3 separate graphs and stores them under        *");
        ComplexDemo.println("* several formats in 9 files.  Values are selected from a large    *");
        ComplexDemo.println("* RRD file that will be created by importing an XML dump           *");
        ComplexDemo.println("* of approx. 7 MB.                                                 *");
        ComplexDemo.println("*                                                                  *");
        ComplexDemo.println("* Graphs are created using real-life values, original RRD file     *");
        ComplexDemo.println("* provided by www.cherrymon.org. See the ComplexDemo               *");
        ComplexDemo.println("* sourcecode on how to create the graphs generated by this demo.   *");
        ComplexDemo.println("********************************************************************");
        ComplexDemo.createDatabase(stringArray[0]);
        ComplexDemo.createGraphs();
        long l2 = System.currentTimeMillis();
        ComplexDemo.println("-- Demo finished in " + (double)(l2 - l) / 1000.0 + " seconds.");
    }
}

