/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

class Demo {
    static final long SEED = 1909752002L;
    static final Random RANDOM = new Random(1909752002L);
    static final String FILE = "demo";
    static final long START = Util.getTimestamp(2003, 4, 1);
    static final long END = Util.getTimestamp(2003, 5, 1);
    static final int MAX_STEP = 300;

    Demo() {
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        Demo.println("== Starting demo");
        RrdDb.setLockMode(0);
        long l = System.currentTimeMillis();
        long l2 = START;
        long l3 = END;
        String string = Util.getJRobinDemoPath("demo.rrd");
        String string2 = Util.getJRobinDemoPath("demo.xml");
        String string3 = Util.getJRobinDemoPath("demo_restored.rrd");
        String string4 = Util.getJRobinDemoPath("demo.png");
        String string5 = Util.getJRobinDemoPath("demo.jpeg");
        String string6 = Util.getJRobinDemoPath("demo.gif");
        String string7 = Util.getJRobinDemoPath("demo.log");
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(string7, false)));
        Demo.println("== Creating RRD file " + string);
        RrdDef rrdDef = new RrdDef(string, l2 - 1L, 300L);
        rrdDef.addDatasource("sun", "GAUGE", 600L, 0.0, Double.NaN);
        rrdDef.addDatasource("shade", "GAUGE", 600L, 0.0, Double.NaN);
        rrdDef.addArchive("AVERAGE", 0.5, 1, 600);
        rrdDef.addArchive("AVERAGE", 0.5, 6, 700);
        rrdDef.addArchive("AVERAGE", 0.5, 24, 775);
        rrdDef.addArchive("AVERAGE", 0.5, 288, 797);
        rrdDef.addArchive("MAX", 0.5, 1, 600);
        rrdDef.addArchive("MAX", 0.5, 6, 700);
        rrdDef.addArchive("MAX", 0.5, 24, 775);
        rrdDef.addArchive("MAX", 0.5, 288, 797);
        Demo.println(rrdDef.dump());
        printWriter.println(rrdDef.dump());
        Demo.println("Estimated file size: " + rrdDef.getEstimatedSize());
        RrdDb rrdDb = new RrdDb(rrdDef);
        Demo.println("== RRD file created.");
        if (!rrdDb.getRrdDef().equals(rrdDef)) {
            Demo.println("Invalid RRD file created. This is a serious bug, bailing out");
            return;
        }
        Demo.println("Checking RRD file structure... OK");
        rrdDb.close();
        Demo.println("== RRD file closed.");
        GaugeSource gaugeSource = new GaugeSource(1200.0, 20.0);
        GaugeSource gaugeSource2 = new GaugeSource(300.0, 10.0);
        Demo.println("== Simulating one month of RRD file updates with step not larger than 300 seconds (* denotes 1000 updates)");
        long l4 = l2;
        int n = 0;
        rrdDb = new RrdDb(string);
        Sample sample = rrdDb.createSample();
        while (l4 <= l3 + 86400L) {
            sample.setTime(l4);
            sample.setValue("sun", (double)gaugeSource.getValue());
            sample.setValue("shade", (double)gaugeSource2.getValue());
            printWriter.println(sample.dump());
            sample.update();
            l4 = (long)((double)l4 + (RANDOM.nextDouble() * 300.0 + 1.0));
            if (++n % 1000 != 0) continue;
            System.out.print("*");
        }
        Demo.println("");
        Demo.println("== Finished. RRD file updated " + n + " times");
        Demo.println("== Last update time was: " + rrdDb.getLastUpdateTime());
        rrdDb.close();
        rrdDb = new RrdDb(string, true);
        Demo.println("File reopen in read-only mode");
        Demo.println("== Fetching data for the whole month");
        FetchRequest fetchRequest = rrdDb.createFetchRequest("AVERAGE", l2, l3);
        Demo.println(fetchRequest.dump());
        printWriter.println(fetchRequest.dump());
        FetchData fetchData = fetchRequest.fetchData();
        Demo.println("== Data fetched. " + fetchData.getRowCount() + " points obtained");
        for (int i = 0; i < fetchData.getRowCount(); ++i) {
            Demo.println(fetchData.getRow(i).dump());
        }
        Demo.println("== Dumping fetch data to XML format");
        Demo.println(fetchData.exportXml());
        Demo.println("== Fetch completed");
        Demo.println("== Dumping RRD file to XML file " + string2 + " (can be restored with RRDTool)");
        rrdDb.exportXml(string2);
        Demo.println("== Creating RRD file " + string3 + " from XML file " + string2);
        RrdDb rrdDb2 = new RrdDb(string3, string2);
        Demo.println("== Closing both RRD files");
        rrdDb.close();
        Demo.println("== First file closed");
        rrdDb2.close();
        Demo.println("== Second file closed");
        Demo.println("== Creating graph from the second file");
        RrdGraphDef rrdGraphDef = new RrdGraphDef();
        rrdGraphDef.setTimePeriod(l2, l3);
        rrdGraphDef.setTitle("Temperatures in May 2003");
        rrdGraphDef.setVerticalLabel("temperature");
        rrdGraphDef.datasource("sun", string3, "sun", "AVERAGE");
        rrdGraphDef.datasource("shade", string3, "shade", "AVERAGE");
        rrdGraphDef.datasource("median", "sun,shade,+,2,/");
        rrdGraphDef.datasource("diff", "sun,shade,-,ABS,-1,*");
        rrdGraphDef.datasource("sine", "TIME," + l2 + ",-," + (l3 - l2) + ",/,2,PI,*,*,SIN,1000,*");
        rrdGraphDef.line("sun", Color.GREEN, "sun temp");
        rrdGraphDef.line("shade", Color.BLUE, "shade temp");
        rrdGraphDef.line("median", Color.MAGENTA, "median value@L");
        rrdGraphDef.area("diff", Color.YELLOW, "difference@r");
        rrdGraphDef.line("diff", Color.RED, null);
        rrdGraphDef.line("sine", Color.CYAN, "sine function demo@L");
        rrdGraphDef.gprint("sun", "MAX", "maxSun = @3@s");
        rrdGraphDef.gprint("sun", "AVERAGE", "avgSun = @3@S@r");
        rrdGraphDef.gprint("shade", "MAX", "maxShade = @3@S");
        rrdGraphDef.gprint("shade", "AVERAGE", "avgShade = @3@S@r");
        RrdGraph rrdGraph = new RrdGraph(rrdGraphDef);
        Demo.println("== Graph created");
        rrdGraph.saveAsPNG(string4, 400, 250);
        Demo.println("== Graph saved as a PNG file " + string4);
        rrdGraph.saveAsJPEG(string5, 400, 250, 0.5f);
        Demo.println("== Graph saved as a JPEG file " + string5);
        rrdGraph.saveAsGIF(string6, 400, 250);
        Demo.println("== Graph saved as a GIF file " + string6);
        printWriter.close();
        Demo.println("== Demo completed in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec");
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void print(String string) {
        System.out.print(string);
    }

    static class GaugeSource {
        private double value;
        private double step;

        GaugeSource(double d, double d2) {
            this.value = d;
            this.step = d2;
        }

        long getValue() {
            double d = this.value;
            double d2 = RANDOM.nextDouble() * this.step;
            if (RANDOM.nextDouble() > 0.5) {
                d2 *= -1.0;
            }
            this.value += d2;
            if (this.value <= 0.0) {
                this.value = 0.0;
            }
            return Math.round(d);
        }
    }
}

