/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo;

import java.awt.Color;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.CubicSplineInterpolator;
import org.jrobin.graph.LinearInterpolator;
import org.jrobin.graph.Plottable;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

class PlottableDemo {
    static final double[] SF_DOWNLOAD_COUNT = new double[]{0.0, 0.0, 13.0, 34.0, 76.0, 72.0, 255.0, 144.0, 135.0, 194.0, 358.0, 304.0, 293.0};
    static final double[] SF_PAGE_HITS = new double[]{0.0, 1072.0, 517.0, 979.0, 2132.0, 2532.0, 5515.0, 3519.0, 3500.0, 4942.0, 7858.0, 7797.0, 6570.0};
    static final GregorianCalendar[] SF_TIMESTAMPS = new GregorianCalendar[SF_DOWNLOAD_COUNT.length];
    static final Date SF_START_DATE = new GregorianCalendar(2003, 4, 1).getTime();
    private static int count;

    private PlottableDemo() throws RrdException, IOException {
        this.createGraph1();
        this.createGraph2();
        this.createGraph3();
        this.createGraph4();
        this.createGraph5();
        this.createGraph6();
        this.createGraph7();
        this.createGraph8();
        this.createGraph9();
        this.createGraph10();
        this.createGraph11();
        this.createGraph12();
        this.createGraph13();
        this.createGraph14();
        this.createGraph15();
        this.createGraph16();
        this.createGraph17();
    }

    private void createGraph1() throws RrdException, IOException {
        final long l = new Date().getTime() / 1000L;
        final long l2 = l + 777600L;
        Plottable plottable = new Plottable(){

            public double getValue(long l3) {
                double d = (double)(l3 - l) / (double)(l2 - l);
                return Math.exp(-d * 2.0) * Math.cos(d * 7.0 * Math.PI);
            }
        };
        long[] lArray = new long[10];
        double[] dArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            lArray[i] = l + (long)i * 86400L;
            dArray[i] = plottable.getValue(lArray[i]);
        }
        LinearInterpolator linearInterpolator = new LinearInterpolator(lArray, dArray);
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(lArray, dArray);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(l, l2);
        rrdGraphDef.setTitle("Plottable demonstration");
        rrdGraphDef.setTimeAxisLabel("days of our lives");
        rrdGraphDef.setVerticalLabel("inspiration");
        rrdGraphDef.datasource("real", plottable);
        rrdGraphDef.datasource("linear", linearInterpolator);
        rrdGraphDef.datasource("spline", cubicSplineInterpolator);
        rrdGraphDef.line("real", Color.BLUE, "Real values", 1);
        rrdGraphDef.line("linear", Color.RED, "Linear interpolation", 1);
        rrdGraphDef.line("spline", Color.MAGENTA, "Spline interpolation@r", 1);
        rrdGraphDef.setTimeAxis(3, 1, 3, 1, "dd", true);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph2() throws RrdException, IOException {
        GregorianCalendar[] gregorianCalendarArray = new GregorianCalendar[]{new GregorianCalendar(2004, 2, 1, 0, 0, 0), new GregorianCalendar(2004, 2, 1, 2, 0, 0), new GregorianCalendar(2004, 2, 1, 7, 0, 0), new GregorianCalendar(2004, 2, 1, 14, 0, 0), new GregorianCalendar(2004, 2, 1, 17, 0, 0), new GregorianCalendar(2004, 2, 1, 19, 0, 0), new GregorianCalendar(2004, 2, 1, 23, 0, 0), new GregorianCalendar(2004, 2, 1, 24, 0, 0)};
        double[] dArray = new double[]{100.0, 250.0, 230.0, 370.0, 350.0, 300.0, 340.0, 350.0};
        LinearInterpolator linearInterpolator = new LinearInterpolator(gregorianCalendarArray, dArray);
        linearInterpolator.setInterpolationMethod(0);
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(gregorianCalendarArray, dArray);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(gregorianCalendarArray[0], gregorianCalendarArray[gregorianCalendarArray.length - 1]);
        rrdGraphDef.setTitle("Plottable demonstration");
        rrdGraphDef.setTimeAxisLabel("time");
        rrdGraphDef.setVerticalLabel("water level [inches]");
        rrdGraphDef.datasource("linear", linearInterpolator);
        rrdGraphDef.datasource("spline", cubicSplineInterpolator);
        rrdGraphDef.area("spline", Color.ORANGE, "Spline interpolation");
        rrdGraphDef.line("linear", Color.RED, "Linear inteprolation@r", 2);
        rrdGraphDef.gprint("spline", "AVERAGE", "Average spline value: @0 inches@r");
        rrdGraphDef.gprint("linear", "AVERAGE", "Average linear value: @0 inches@r");
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph3() throws RrdException, IOException {
        LinearInterpolator linearInterpolator = new LinearInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("JRobin page hits per month");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("page hits");
        rrdGraphDef.datasource("linear", linearInterpolator);
        rrdGraphDef.area("linear", Color.GREEN, null);
        rrdGraphDef.line("linear", Color.RED, "page hits@L", 2);
        rrdGraphDef.vrule(new GregorianCalendar(2004, 0, 1), Color.BLUE, null, 3);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        rrdGraphDef.comment("Data provided by SourceForge.net@r");
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph4() throws RrdException, IOException {
        LinearInterpolator linearInterpolator = new LinearInterpolator(SF_TIMESTAMPS, SF_DOWNLOAD_COUNT);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("JRobin download count per month");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("download count");
        rrdGraphDef.datasource("linear", linearInterpolator);
        rrdGraphDef.area("linear", Color.GREEN, null);
        rrdGraphDef.line("linear", Color.RED, "download count@L", 2);
        rrdGraphDef.vrule(new GregorianCalendar(2004, 0, 1), Color.BLUE, null, 3);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        rrdGraphDef.comment("Data provided by SourceForge.net@r");
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph5() throws RrdException, IOException {
        LinearInterpolator linearInterpolator = new LinearInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        LinearInterpolator linearInterpolator2 = new LinearInterpolator(SF_TIMESTAMPS, SF_DOWNLOAD_COUNT);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("JRobin statistics at SourceForge");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits/downloads");
        rrdGraphDef.datasource("hits", linearInterpolator);
        rrdGraphDef.datasource("downloads", linearInterpolator2);
        rrdGraphDef.datasource("ratio", "downloads,0,EQ,UNKN,hits,downloads,/,IF");
        rrdGraphDef.area("hits", Color.GREEN, null);
        rrdGraphDef.line("hits", Color.RED, "page hits", 2);
        rrdGraphDef.area("downloads", Color.MAGENTA, "downloads@L");
        rrdGraphDef.vrule(new GregorianCalendar(2004, 0, 1), Color.BLUE, null, 3);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        rrdGraphDef.gprint("ratio", "AVERAGE", "Average number of page hits per download: @0@r");
        rrdGraphDef.comment("Data provided by SourceForge.net@r");
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph6() throws RrdException, IOException {
        LinearInterpolator linearInterpolator = new LinearInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        LinearInterpolator linearInterpolator2 = new LinearInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        linearInterpolator2.setInterpolationMethod(3);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trend report");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", linearInterpolator);
        rrdGraphDef.datasource("trend", linearInterpolator2);
        rrdGraphDef.datasource("diff", "hits,trend,-");
        rrdGraphDef.datasource("absdiff", "diff,ABS");
        rrdGraphDef.area("trend", null, null);
        rrdGraphDef.stack("diff", Color.YELLOW, "difference");
        rrdGraphDef.line("hits", Color.RED, "real page hits");
        rrdGraphDef.line("trend", Color.BLUE, "trend@L");
        rrdGraphDef.gprint("absdiff", "AVERAGE", "Average difference: @0@r");
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph7() throws RrdException, IOException {
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        rrdGraphDef.datasource("hits2", "hits,1000,-");
        rrdGraphDef.datasource("invisible", "hits2,0,GE,hits2,0,IF");
        rrdGraphDef.datasource("margin", "hits,invisible,-");
        rrdGraphDef.area("invisible", null, null);
        rrdGraphDef.stack("margin", Color.YELLOW, "yellow margin");
        rrdGraphDef.line("hits", Color.RED, "page hits", 3);
        rrdGraphDef.line("hits", Color.WHITE, null, 1);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph8() throws RrdException, IOException {
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        rrdGraphDef.datasource("avg", "hits", "AVERAGE");
        rrdGraphDef.datasource("diff", "avg,hits,-");
        rrdGraphDef.datasource("diffpos", "diff,0,GE,diff,0,IF");
        rrdGraphDef.datasource("diffneg", "diff,0,LT,diff,0,IF");
        rrdGraphDef.area("hits", null, null);
        rrdGraphDef.stack("diffpos", Color.RED, "bad");
        rrdGraphDef.stack("diffneg", Color.GREEN, "good");
        rrdGraphDef.line("hits", Color.BLUE, "hits", 3);
        rrdGraphDef.line("hits", Color.WHITE, null, 1);
        rrdGraphDef.line("avg", Color.MAGENTA, "average@L", 3);
        rrdGraphDef.line("avg", Color.WHITE, null, 1);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        rrdGraphDef.gprint("hits", "AVERAGE", "Average: @0@r");
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph9() throws RrdException, IOException {
        GregorianCalendar[] gregorianCalendarArray = new GregorianCalendar[]{SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]};
        double[] dArray = new double[]{SF_PAGE_HITS[0], SF_PAGE_HITS[SF_PAGE_HITS.length - 1]};
        LinearInterpolator linearInterpolator = new LinearInterpolator(gregorianCalendarArray, dArray);
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        rrdGraphDef.datasource("trend", linearInterpolator);
        rrdGraphDef.datasource("diff", "trend,hits,-");
        rrdGraphDef.area("hits", null, null);
        rrdGraphDef.stack("diff", Color.YELLOW, "difference");
        rrdGraphDef.line("hits", Color.BLUE, "hits");
        rrdGraphDef.line("trend", Color.RED, "trend@L");
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph10() throws RrdException, IOException {
        int n;
        Color color = Color.RED;
        Color color2 = Color.YELLOW;
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        for (n = 0; n <= 30; ++n) {
            rrdGraphDef.datasource("hits" + n, "hits," + n + ",*," + 30 + ",/");
        }
        for (n = 30; n >= 0; --n) {
            Color color3 = this.interpolateColor(color, color2, (double)n / 30.0);
            rrdGraphDef.area("hits" + n, color3, null);
        }
        rrdGraphDef.line("hits", Color.BLACK, "Number of page hits");
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph11() throws RrdException, IOException {
        int n;
        Color color = Color.RED;
        Color color2 = Color.YELLOW;
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        for (n = 0; n <= 30; ++n) {
            rrdGraphDef.datasource("hits" + n, "hits," + n + ",*," + 30 + ",/");
        }
        for (n = 30; n >= 0; --n) {
            Color color3 = this.interpolateColor(color, color2, (double)n / 30.0);
            rrdGraphDef.area("hits" + n, color3, null);
        }
        rrdGraphDef.line("hits", color2, "Estimated number of page hits");
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        rrdGraphDef.setCanvasColor(color);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph12() throws RrdException, IOException {
        int n;
        Color color = Color.YELLOW;
        Color color2 = Color.RED;
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        rrdGraphDef.datasource("top", "hits", "MAX");
        for (n = 1; n <= 30; ++n) {
            rrdGraphDef.datasource("hits" + n, "hits,top," + n + ",*," + 30 + ",/,MIN");
        }
        for (n = 30; n >= 1; --n) {
            Color color3 = n % 2 == 0 ? color : color2;
            rrdGraphDef.area("hits" + n, color3, null);
        }
        rrdGraphDef.line("hits", color2, "Estimated number of page hits");
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph13() throws RrdException, IOException {
        Color color = Color.LIGHT_GRAY;
        Color color2 = Color.WHITE;
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        for (int i = 15; i >= 1; --i) {
            Color color3 = this.interpolateColor(color, color2, (double)i / 15.0);
            rrdGraphDef.line("hits", color3, null, i);
        }
        rrdGraphDef.line("hits", color, "Estimated number of page hits");
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph14() throws RrdException, IOException {
        int n;
        Color color = Color.RED;
        Color color2 = Color.WHITE;
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        for (n = 0; n <= 20; ++n) {
            rrdGraphDef.datasource("hits" + n, "hits,2000.0," + n + ",*," + 20 + ",/,-,0,MAX");
        }
        for (n = 0; n <= 20; ++n) {
            rrdGraphDef.area("hits" + n, this.interpolateColor(color, color2, (double)n / 20.0), null);
        }
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph15() throws RrdException, IOException {
        int n;
        Color color = Color.BLACK;
        Color color2 = Color.RED;
        CubicSplineInterpolator cubicSplineInterpolator = new CubicSplineInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", cubicSplineInterpolator);
        rrdGraphDef.datasource("maxhits", "hits", "MAX");
        for (n = 1; n <= 20; ++n) {
            rrdGraphDef.datasource("hits" + n, "maxhits," + n + ",*," + 20 + ",/,hits,GE,hits,0,IF");
        }
        for (n = 20; n >= 1; --n) {
            rrdGraphDef.area("hits" + n, this.interpolateColor(color, color2, (double)n / 20.0), null);
        }
        rrdGraphDef.line("hits", Color.BLUE, "page hits", 2);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph16() throws RrdException, IOException {
        int n;
        Color color = Color.BLACK;
        Color color2 = Color.RED;
        LinearInterpolator linearInterpolator = new LinearInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        linearInterpolator.setInterpolationMethod(0);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("hits");
        rrdGraphDef.datasource("hits", linearInterpolator);
        rrdGraphDef.datasource("maxhits", "hits", "MAX");
        for (n = 1; n <= 20; ++n) {
            rrdGraphDef.datasource("hits" + n, "maxhits," + n + ",*," + 20 + ",/,hits,GE,hits,0,IF");
        }
        for (n = 20; n >= 1; --n) {
            rrdGraphDef.area("hits" + n, this.interpolateColor(color, color2, (double)n / 20.0), null);
        }
        rrdGraphDef.line("hits", Color.BLUE, "page hits", 2);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private void createGraph17() throws RrdException, IOException {
        int n;
        Color color = Color.YELLOW;
        Color color2 = Color.RED;
        LinearInterpolator linearInterpolator = new LinearInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        LinearInterpolator linearInterpolator2 = new LinearInterpolator(SF_TIMESTAMPS, SF_PAGE_HITS);
        linearInterpolator2.setInterpolationMethod(3);
        RrdGraphDef rrdGraphDef = new RrdGraphDef(SF_TIMESTAMPS[0], SF_TIMESTAMPS[SF_TIMESTAMPS.length - 1]);
        rrdGraphDef.setTitle("Trick graph");
        rrdGraphDef.setTimeAxisLabel("month");
        rrdGraphDef.setVerticalLabel("difference");
        rrdGraphDef.datasource("hits", linearInterpolator);
        rrdGraphDef.datasource("trend", linearInterpolator2);
        rrdGraphDef.datasource("diff", "hits,trend,-");
        for (n = 1; n <= 20; ++n) {
            rrdGraphDef.datasource("diff" + n, "diff," + n + ",*," + 20 + ",/");
        }
        for (n = 20; n >= 1; --n) {
            String string = "diff" + n;
            Color color3 = this.interpolateColor(color, color2, (double)n / 20.0);
            String string2 = n == 1 ? "dissipation" : null;
            rrdGraphDef.area(string, color3, string2);
        }
        rrdGraphDef.setCanvasColor(color2);
        rrdGraphDef.setTimeAxis(5, 1, 5, 1, "MMM", false);
        PlottableDemo.createGraph(rrdGraphDef);
    }

    private Color interpolateColor(Color color, Color color2, double d) {
        int n = color.getRed() + (int)((double)(color2.getRed() - color.getRed()) * d);
        int n2 = color.getGreen() + (int)((double)(color2.getGreen() - color.getGreen()) * d);
        int n3 = color.getBlue() + (int)((double)(color2.getBlue() - color.getBlue()) * d);
        return new Color(n, n2, n3);
    }

    private static void createGraph(RrdGraphDef rrdGraphDef) throws IOException, RrdException {
        RrdGraph rrdGraph = new RrdGraph(rrdGraphDef);
        String string = Util.getJRobinDemoPath("plottable" + ++count + ".png");
        rrdGraph.saveAsPNG(string, 400, 200);
        System.out.println("Saved to: " + string);
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        new PlottableDemo();
    }

    static {
        for (int i = 0; i < SF_TIMESTAMPS.length; ++i) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(SF_START_DATE);
            gregorianCalendar.add(2, i);
            PlottableDemo.SF_TIMESTAMPS[i] = gregorianCalendar;
        }
    }
}

