/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdExportDef;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

class StressTest {
    static final String FACTORY_NAME = "NIO";
    static final String RRD_PATH = Util.getJRobinDemoPath("stress.rrd");
    static final long RRD_START = 946710000L;
    static final long RRD_STEP = 30L;
    static final String RRD_DATASOURCE_NAME = "T";
    static final int RRD_DATASOURCE_COUNT = 6;
    static final long TIME_START = 1060142010L;
    static final long TIME_END = 1080013472L;
    static final String PNG_PATH = Util.getJRobinDemoPath("stress.png");
    static final int PNG_WIDTH = 400;
    static final int PNG_HEIGHT = 250;

    StressTest() {
    }

    static void printLapTime(String string) {
        System.out.println(string + " " + Util.getLapTime());
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        int n;
        Color[] colorArray;
        Object object;
        if (stringArray.length == 0) {
            System.out.println("Usage: StressTest [path to stress-test.txt file]");
            System.out.println("You can download separate stress-test.txt file from:");
            System.out.println("http://www.sourceforge.net/projects/jrobin");
            System.exit(-1);
        }
        System.out.println("********************************************************************");
        System.out.println("* JRobinStressTest                                                 *");
        System.out.println("*                                                                  *");
        System.out.println("* This demo creates single RRD file and tries to update it         *");
        System.out.println("* more than 600.000 times. Real data (> 20Mb) is obtained from the *");
        System.out.println("* stress-test.txt file provided by Vadim Tkachenko                 *");
        System.out.println("* (http://diy-zoning.sourceforge.net).                             *");
        System.out.println("*                                                                  *");
        System.out.println("* Finally, a single PNG graph will be created from the RRD file.   *");
        System.out.println("* The stress test takes about one hour to complete on a 1.6GHz     *");
        System.out.println("* computer with 256MB of RAM.                                      *");
        System.out.println("********************************************************************");
        StressTest.printLapTime("Starting demo at " + new Date());
        RrdDb.setDefaultFactory(FACTORY_NAME);
        StressTest.printLapTime("Backend factory set to NIO");
        StressTest.printLapTime("Creating RRD definition");
        RrdDef rrdDef = new RrdDef(RRD_PATH);
        rrdDef.setStartTime(946710000L);
        rrdDef.setStep(30L);
        for (int i = 0; i < 6; ++i) {
            rrdDef.addDatasource(RRD_DATASOURCE_NAME + i, "GAUGE", 90L, -60.0, 85.0);
        }
        rrdDef.addArchive("LAST", 0.5, 1, 5760);
        rrdDef.addArchive("MIN", 0.5, 1, 5760);
        rrdDef.addArchive("MAX", 0.5, 1, 5760);
        rrdDef.addArchive("AVERAGE", 0.5, 5, 13824);
        rrdDef.addArchive("MIN", 0.5, 5, 13824);
        rrdDef.addArchive("MAX", 0.5, 5, 13824);
        rrdDef.addArchive("AVERAGE", 0.5, 60, 16704);
        rrdDef.addArchive("MIN", 0.5, 60, 16704);
        rrdDef.addArchive("MAX", 0.5, 60, 16704);
        rrdDef.addArchive("AVERAGE", 0.5, 1440, 50000);
        rrdDef.addArchive("MIN", 0.5, 1440, 50000);
        rrdDef.addArchive("MAX", 0.5, 1440, 50000);
        StressTest.printLapTime("Definition created, creating RRD file");
        RrdDb rrdDb = RrdDbPool.getInstance().requestRrdDb(rrdDef);
        StressTest.printLapTime("RRD file created: " + RRD_PATH);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
        StressTest.printLapTime("Buffered reader created, processing data");
        int n2 = 0;
        Date date = new Date();
        while ((object = bufferedReader.readLine()) != null) {
            colorArray = rrdDb.createSample();
            try {
                colorArray.setAndUpdate((String)object);
                if (++n2 % 1000 != 0) continue;
                Date date2 = new Date();
                long l = (long)((double)n2 * 1000.0 / (double)(date2.getTime() - date.getTime()));
                StressTest.printLapTime(n2 + " samples stored, " + l + " updates/sec");
            }
            catch (RrdException rrdException) {
                StressTest.printLapTime("RRD ERROR: " + (String)object);
            }
        }
        RrdDbPool.getInstance().release(rrdDb);
        StressTest.printLapTime("FINISHED: " + n2 + " samples stored");
        StressTest.printLapTime("Creating composite graph definition");
        object = new RrdGraphDef(1060142010L, 1080013472L);
        ((RrdGraphDef)object).setTitle("Temperatures");
        ((RrdGraphDef)object).setVerticalLabel("Fahrenheits");
        colorArray = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.ORANGE};
        for (n = 0; n < 6; ++n) {
            String string = RRD_DATASOURCE_NAME + n;
            ((RrdExportDef)object).datasource(string, RRD_PATH, string, "AVERAGE");
        }
        for (n = 0; n < 6; ++n) {
            String string = RRD_DATASOURCE_NAME + n;
            ((RrdGraphDef)object).line(string, colorArray[n], string);
        }
        ((RrdGraphDef)object).comment("@c");
        ((RrdGraphDef)object).comment("\nOriginal data provided by diy-zoning.sf.net@c");
        StressTest.printLapTime("Graph definition created");
        RrdGraph rrdGraph = new RrdGraph((RrdGraphDef)object, true);
        rrdGraph.saveAsPNG(PNG_PATH, 400, 250);
        StressTest.printLapTime("Graph saved: " + PNG_PATH);
        StressTest.printLapTime("Finished at " + new Date());
    }
}

