/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdDefTemplate;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphDefTemplate;

class TemplatesDemo {
    static final String RRD_TEMPLATE = "<rrd_def>                                  <path>${path}</path>                   <start>${start}</start>            \t <step>300</step>                       <datasource>                        \t     <name>sun</name>                       <type>GAUGE</type>                     <heartbeat>600</heartbeat>             <min>0</min>                   \t\t <max>U</max>                       </datasource>                          <datasource>                        \t     <name>shade</name>                     <type>GAUGE</type>                     <heartbeat>600</heartbeat>             <min>0</min>                   \t\t <max>U</max>                       </datasource>                          <archive>                                  <cf>AVERAGE</cf>                       <xff>0.5</xff>                         <steps>1</steps>               \t     <rows>600</rows>                   </archive>                             <archive>                                  <cf>AVERAGE</cf>                       <xff>0.5</xff>                         <steps>6</steps>               \t     <rows>700</rows>                   </archive>                             <archive>                                  <cf>AVERAGE</cf>                       <xff>0.5</xff>                         <steps>24</steps>              \t     <rows>775</rows>                   </archive>                             <archive>                                  <cf>AVERAGE</cf>                       <xff>0.5</xff>                         <steps>288</steps>             \t     <rows>797</rows>                   </archive>                             <archive>                                  <cf>MAX</cf>                           <xff>0.5</xff>                         <steps>1</steps>               \t     <rows>600</rows>                   </archive>                             <archive>                                  <cf>MAX</cf>                           <xff>0.5</xff>                         <steps>6</steps>               \t     <rows>700</rows>                   </archive>                             <archive>                                  <cf>MAX</cf>                           <xff>0.5</xff>                         <steps>24</steps>              \t     <rows>775</rows>                   </archive>                             <archive>                                  <cf>MAX</cf>                           <xff>0.5</xff>                         <steps>288</steps>             \t     <rows>797</rows>                   </archive>                         </rrd_def>                             ";
    static final String GRAPH_TEMPLATE = "<rrd_graph_def>                                          <span>                                                   <start>${start}</start>                              <end>${end}</end>                                </span>                                              <options>                                                <title>${title}</title>                              <vertical_label>temperature</vertical_label>     </options>                                           <datasources>                                            <def>                                                    <name>sun</name>                                     <rrd>${rrd}</rrd>                                    <source>sun</source>                                 <cf>AVERAGE</cf>                                 </def>                                               <def>                                                    <name>shade</name>                                   <rrd>${rrd}</rrd>                                    <source>shade</source>                               <cf>AVERAGE</cf>                                 </def>                                               <def>                                                    <name>median</name>                                  <rpn>sun,shade,+,2,/</rpn>                       </def>                                               <def>                                                    <name>diff</name>                                    <rpn>sun,shade,-,ABS,-1,*</rpn>                  </def>                                               <def>                                                    <name>sine</name>                                    <rpn>${sine}</rpn>                               </def>                                           </datasources>                                       <graph>                                                  <line>                                                   <datasource>sun</datasource>                         <color>#00FF00</color>                               <legend>sun temp</legend>                        </line>                                              <line>                                                   <datasource>shade</datasource>                       <color>#0000FF</color>                               <legend>shade temp</legend>                      </line>                                              <line>                                                   <datasource>median</datasource>                      <color>#FF00FF</color>                               <legend>median value@L</legend>                  </line>                                              <area>                                                   <datasource>diff</datasource>                        <color>#FFFF00</color>                               <legend>difference@r</legend>                    </area>                                              <line>                                                   <datasource>diff</datasource>                        <color>#FF0000</color>                               <legend/>                                        </line>                                              <line>                                                   <datasource>sine</datasource>                        <color>#00FFFF</color>                               <legend>sine function demo@L</legend>            </line>                                              <gprint>                                                 <datasource>sun</datasource>                         <cf>MAX</cf>                                         <format>maxSun = @3@s</format>                   </gprint>                                            <gprint>                                                 <datasource>sun</datasource>                         <cf>AVERAGE</cf>                                     <format>avgSun = @3@S@r</format>                 </gprint>                                            <gprint>                                                 <datasource>shade</datasource>                       <cf>MAX</cf>                                         <format>maxShade = @3@S</format>                 </gprint>                                            <gprint>                                                 <datasource>shade</datasource>                       <cf>AVERAGE</cf>                                     <format>avgShade = @3@S@r</format>               </gprint>                                        </graph>                                         </rrd_graph_def>                                     ";
    static final long SEED = 1909752002L;
    static final Random RANDOM = new Random(1909752002L);
    static final String FILE = "templates_demo";
    static final long START = Util.getTimestamp(2003, 4, 1);
    static final long END = Util.getTimestamp(2003, 5, 1);
    static final int MAX_STEP = 300;

    TemplatesDemo() {
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        TemplatesDemo.println("== Starting demo");
        RrdDb.setLockMode(0);
        long l = System.currentTimeMillis();
        long l2 = START;
        long l3 = END;
        String string = Util.getJRobinDemoPath("templates_demo.rrd");
        String string2 = Util.getJRobinDemoPath("templates_demo.xml");
        String string3 = Util.getJRobinDemoPath("templates_demo_restored.rrd");
        String string4 = Util.getJRobinDemoPath("templates_demo.png");
        String string5 = Util.getJRobinDemoPath("templates_demo.jpeg");
        String string6 = Util.getJRobinDemoPath("templates_demo.gif");
        String string7 = Util.getJRobinDemoPath("templates_demo.log");
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(string7, false)));
        TemplatesDemo.println("== Creating RRD file " + string);
        RrdDefTemplate rrdDefTemplate = new RrdDefTemplate(RRD_TEMPLATE);
        rrdDefTemplate.setVariable("path", string);
        rrdDefTemplate.setVariable("start", l2 - 1L);
        RrdDef rrdDef = rrdDefTemplate.getRrdDef();
        TemplatesDemo.println(rrdDef.dump());
        printWriter.println(rrdDef.dump());
        RrdDb rrdDb = new RrdDb(rrdDef);
        rrdDb.close();
        TemplatesDemo.println("== RRD file created and closed.");
        GaugeSource gaugeSource = new GaugeSource(1200.0, 20.0);
        GaugeSource gaugeSource2 = new GaugeSource(300.0, 10.0);
        TemplatesDemo.println("== Simulating one month of RRD file updates with step not larger than 300 seconds (* denotes 1000 updates)");
        long l4 = l2;
        int n = 0;
        rrdDb = new RrdDb(string);
        Sample sample = rrdDb.createSample();
        while (l4 <= l3 + 86400L) {
            sample.setTime(l4);
            sample.setValue("sun", (double)gaugeSource.getValue());
            sample.setValue("shade", (double)gaugeSource2.getValue());
            printWriter.println(sample.dump());
            sample.update();
            l4 = (long)((double)l4 + (RANDOM.nextDouble() * 300.0 + 1.0));
            if (++n % 1000 != 0) continue;
            System.out.print("*");
        }
        System.out.println("");
        TemplatesDemo.println("== Finished. RRD file updated " + n + " times");
        TemplatesDemo.println("== Last update time was: " + rrdDb.getLastUpdateTime());
        TemplatesDemo.println("== Fetching data for the whole month");
        FetchRequest fetchRequest = rrdDb.createFetchRequest("AVERAGE", l2, l3);
        TemplatesDemo.println(fetchRequest.dump());
        printWriter.println(fetchRequest.dump());
        FetchData fetchData = fetchRequest.fetchData();
        TemplatesDemo.println("== Data fetched. " + fetchData.getRowCount() + " points obtained");
        for (int i = 0; i < fetchData.getRowCount(); ++i) {
            TemplatesDemo.println(fetchData.getRow(i).dump());
        }
        TemplatesDemo.println("== Dumping fetch data to XML format");
        TemplatesDemo.println(fetchData.exportXml());
        TemplatesDemo.println("== Fetch completed");
        TemplatesDemo.println("== Dumping RRD file to XML file " + string2 + " (can be restored with RRDTool)");
        rrdDb.exportXml(string2);
        TemplatesDemo.println("== Creating RRD file " + string3 + " from XML file " + string2);
        RrdDb rrdDb2 = new RrdDb(string3, string2);
        TemplatesDemo.println("== Closing both RRD files");
        rrdDb.close();
        rrdDb2.close();
        TemplatesDemo.println("== Creating graph from the second file");
        RrdGraphDefTemplate rrdGraphDefTemplate = new RrdGraphDefTemplate(GRAPH_TEMPLATE);
        rrdGraphDefTemplate.setVariable("start", l2);
        rrdGraphDefTemplate.setVariable("end", l3);
        rrdGraphDefTemplate.setVariable("title", "Temperatures in May 2003");
        rrdGraphDefTemplate.setVariable("rrd", string3);
        rrdGraphDefTemplate.setVariable("sine", "TIME," + l2 + ",-," + (l3 - l2) + ",/,2,PI,*,*,SIN,1000,*");
        RrdGraphDef rrdGraphDef = rrdGraphDefTemplate.getRrdGraphDef();
        RrdGraph rrdGraph = new RrdGraph(rrdGraphDef);
        TemplatesDemo.println("== Graph created");
        TemplatesDemo.println("== Saving graph as PNG file " + string4);
        rrdGraph.saveAsPNG(string4, 400, 250);
        TemplatesDemo.println("== Saving graph as JPEG file " + string5);
        rrdGraph.saveAsJPEG(string5, 400, 250, 0.5f);
        TemplatesDemo.println("== Saving graph as GIF file " + string6);
        rrdGraph.saveAsGIF(string6, 400, 250);
        printWriter.close();
        TemplatesDemo.println("== Demo completed in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec");
    }

    static void println(String string) {
        System.out.println(string);
    }

    static class GaugeSource {
        private double value;
        private double step;

        GaugeSource(double d, double d2) {
            this.value = d;
            this.step = d2;
        }

        long getValue() {
            double d = this.value;
            double d2 = RANDOM.nextDouble() * this.step;
            if (RANDOM.nextDouble() > 0.5) {
                d2 *= -1.0;
            }
            this.value += d2;
            if (this.value <= 0.0) {
                this.value = 0.0;
            }
            return Math.round(d);
        }
    }
}

