/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo.graph;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.RrdExport;
import org.jrobin.graph.RrdExportDef;
import org.jrobin.graph.RrdExportDefTemplate;

public class ExportExportDemo {
    public static String exportRrd1 = Util.getJRobinDemoPath("export-eth0.xml");
    public static String exportRrd2 = Util.getJRobinDemoPath("export-eth1.xml");
    private static String demoResources = "";

    private static void println(String string) {
        System.out.println(string);
    }

    private static void prepare(String[] stringArray) {
        demoResources = Util.getJRobinHomeDirectory() + "/res/demo/";
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        ExportExportDemo.prepare(stringArray);
        ExportExportDemo.println("+----------------------------------------------------------------------------------+");
        ExportExportDemo.println("|                            JRobin ExportExportDemo                               |");
        ExportExportDemo.println("|                                                                                  |");
        ExportExportDemo.println("| This demo will perform the same export on two different rrd files.  In fact the  |");
        ExportExportDemo.println("| two RRD files contain the same data, they are data from a network interface and  |");
        ExportExportDemo.println("| contain a full days worth of samples on July 3rd 2004.  For this example the RRD |");
        ExportExportDemo.println("| are treated as if from two different interfaces: eth0 and eth1.                  |");
        ExportExportDemo.println("|                                                                                  |");
        ExportExportDemo.println("+----------------------------------------------------------------------------------+");
        long l = System.currentTimeMillis();
        ExportExportDemo.println(">>> Reading export def template\n");
        RrdExportDefTemplate rrdExportDefTemplate = new RrdExportDefTemplate(new File(demoResources + "exportdef.xml"));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2004, 6, 3);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2004, 6, 4);
        rrdExportDefTemplate.setVariable("start", gregorianCalendar);
        rrdExportDefTemplate.setVariable("end", gregorianCalendar2);
        Util.getLapTime();
        ExportExportDemo.println(">>> Exporting data from eth0 for July 3rd, 2004");
        ExportExportDemo.println(">>> Number of rows for the export is limited to 400.");
        rrdExportDefTemplate.setVariable("rrd", demoResources + "eth0.rrd");
        RrdExportDef rrdExportDef = rrdExportDefTemplate.getRrdExportDef();
        RrdExport rrdExport = new RrdExport(rrdExportDef);
        ExportData exportData = rrdExport.fetch();
        exportData.exportXml(exportRrd1);
        ExportExportDemo.println(">>> File saved: " + exportRrd1 + " " + Util.getLapTime() + "\n");
        ExportExportDemo.println(">>> Exporting data from eth1 for July 3rd, 2004");
        ExportExportDemo.println(">>> Number of rows for the export is limited to 20.");
        ExportExportDemo.println("    This means the same data as in the previous export (since in fact");
        ExportExportDemo.println("    both RRD files are the same) will be aggregated to around 20 rows.");
        rrdExportDefTemplate.setVariable("rrd", demoResources + "eth1.rrd");
        rrdExportDef = rrdExportDefTemplate.getRrdExportDef();
        rrdExport.setExportDef(rrdExportDef);
        ExportData exportData2 = rrdExport.fetch(20);
        exportData2.exportXml(exportRrd2);
        ExportExportDemo.println(">>> File saved: " + exportRrd2 + " " + Util.getLapTime() + "\n");
        long l2 = System.currentTimeMillis();
        ExportExportDemo.println(">>> Demo finished in " + (l2 - l) + " milliseconds");
    }
}

