/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo.graph;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.demo.graph.ExportExportDemo;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphDefTemplate;

public class ExportImportDemo {
    private static String exportRrd1 = ExportExportDemo.exportRrd1;
    private static String exportRrd2 = ExportExportDemo.exportRrd2;
    private static String exportCombined = Util.getJRobinDemoPath("export-combined.xml");
    private static String graphFile = Util.getJRobinDemoPath("export-graph.png");
    private static String demoResources = "";

    private static void println(String string) {
        System.out.println(string);
    }

    private static void prepare(String[] stringArray) {
        demoResources = Util.getJRobinHomeDirectory() + "/res/demo/";
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        ExportImportDemo.prepare(stringArray);
        ExportImportDemo.println("+-----------------------------------------------------------------------------------+");
        ExportImportDemo.println("|                             JRobin ExportImportDemo                               |");
        ExportImportDemo.println("|                                                                                   |");
        ExportImportDemo.println("| This demo supposes the ExportExportDemo has been run and the necessary data has   |");
        ExportImportDemo.println("| been exported to the jrobin-demo directory.  The ExportImportDemo creates a graph |");
        ExportImportDemo.println("| containing the data from the separate export XML files, the configuration of the  |");
        ExportImportDemo.println("| graph is in the RrdGraphDef xml file in the directory passed as argument on the   |");
        ExportImportDemo.println("| command line.                                                                     |");
        ExportImportDemo.println("|                                                                                   |");
        ExportImportDemo.println("+-----------------------------------------------------------------------------------+");
        long l = System.currentTimeMillis();
        RrdGraphDefTemplate rrdGraphDefTemplate = new RrdGraphDefTemplate(new File(demoResources + "export-graphdef.xml"));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2004, 6, 3);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2004, 6, 4);
        rrdGraphDefTemplate.setVariable("start", gregorianCalendar);
        rrdGraphDefTemplate.setVariable("end", gregorianCalendar2);
        rrdGraphDefTemplate.setVariable("export1", exportRrd1);
        rrdGraphDefTemplate.setVariable("export2", exportRrd2);
        Util.getLapTime();
        ExportImportDemo.println(">>> Creating graph image from XML graph def");
        RrdGraphDef rrdGraphDef = rrdGraphDefTemplate.getRrdGraphDef();
        RrdGraph rrdGraph = new RrdGraph(rrdGraphDef);
        rrdGraph.saveAsPNG(graphFile);
        ExportImportDemo.println(">>> File saved: " + graphFile + " " + Util.getLapTime() + "\n");
        ExportImportDemo.println(">>> Dumping combined export xml");
        ExportData exportData = rrdGraph.getExportData();
        exportData.exportXml(exportCombined);
        ExportImportDemo.println(">>> File saved: " + exportCombined + " " + Util.getLapTime() + "\n");
        ExportImportDemo.println(">>> Retrieving AVERAGE outoing traffic from combined export");
        ExportImportDemo.println(exportData.print("eth0-2", "AVERAGE", "  From eth0 data: @5.2 @sbit/s"));
        ExportImportDemo.println(exportData.print("eth1-2", "AVERAGE", "  From eth1 data: @5.2 @sbit/s"));
        long l2 = System.currentTimeMillis();
        ExportImportDemo.println("\n>>> Demo finished in " + (l2 - l) + " milliseconds");
    }
}

