/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jrobin.core.RrdException;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.RrdExport;
import org.jrobin.graph.RrdExportDefTemplate;

public class ExportTemplate {
    private static int maxRows = 400;
    private static String templateFile;
    private static String dumpFile;

    private static void die(String string) {
        System.err.println(string);
        System.exit(-1);
    }

    private static void parseArguments(String[] stringArray) {
        int n = stringArray.length - 1;
        templateFile = stringArray[n];
        if (n % 2 > 0) {
            ExportTemplate.die("Invalid number of arguments.");
        }
        for (int i = 0; i < n; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            try {
                if (string.equalsIgnoreCase("-m")) {
                    maxRows = Integer.parseInt(string2);
                    continue;
                }
                if (!string.equalsIgnoreCase("-f")) continue;
                dumpFile = string2;
                continue;
            }
            catch (Exception exception) {
                ExportTemplate.die("Error with option '" + string + "': " + exception.getMessage());
            }
        }
    }

    private static String readVariable(BufferedReader bufferedReader, String string) throws IOException {
        System.out.print("Variable '" + string + "' = ");
        return bufferedReader.readLine();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: ExportTemplate [-m maxRows] [-f <dump_file>] <template_file>");
            System.exit(0);
        }
        ExportTemplate.parseArguments(stringArray);
        try {
            System.out.println(">>> Reading XML template");
            RrdExportDefTemplate rrdExportDefTemplate = new RrdExportDefTemplate(new File(templateFile));
            System.out.println(">>> Setting template variables");
            if (rrdExportDefTemplate.hasVariables()) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String[] stringArray2 = rrdExportDefTemplate.getVariables();
                for (int i = 0; i < stringArray2.length; ++i) {
                    rrdExportDefTemplate.setVariable(stringArray2[i], ExportTemplate.readVariable(bufferedReader, stringArray2[i]));
                }
            }
            System.out.println(">>> Exporting data...");
            long l = System.currentTimeMillis();
            RrdExport rrdExport = new RrdExport(rrdExportDefTemplate.getRrdExportDef());
            ExportData exportData = rrdExport.fetch(maxRows);
            if (dumpFile != null) {
                exportData.exportXml(dumpFile);
            } else {
                exportData.exportXml(System.out);
            }
            long l2 = System.currentTimeMillis();
            System.out.println(">>> Data exported in " + (l2 - l) + " milliseconds");
        }
        catch (RrdException rrdException) {
            ExportTemplate.die("RrdException occurred: " + rrdException.getMessage());
        }
        catch (IOException iOException) {
            ExportTemplate.die("IOException occurred: " + iOException.getMessage());
        }
    }
}

