/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDefTemplate;

public class GraphTemplate {
    private static String format = "gif";
    private static int width = 0;
    private static int height = 0;
    private static float quality = 1.0f;
    private static String templateFile;
    private static String imageName;

    private static void die(String string) {
        System.err.println(string);
        System.exit(-1);
    }

    private static void parseArguments(String[] stringArray) {
        int n = stringArray.length - 1;
        imageName = stringArray[n--];
        templateFile = stringArray[n];
        if (n % 2 > 0) {
            GraphTemplate.die("Invalid number of arguments.");
        }
        for (int i = 0; i < n; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            try {
                if (string.equalsIgnoreCase("-img")) {
                    format = string2;
                    continue;
                }
                if (string.equalsIgnoreCase("-w")) {
                    width = Integer.parseInt(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("-h")) {
                    height = Integer.parseInt(string2);
                    continue;
                }
                if (!string.equalsIgnoreCase("-q")) continue;
                quality = Float.parseFloat(string2);
                continue;
            }
            catch (Exception exception) {
                GraphTemplate.die("Error with option '" + string + "': " + exception.getMessage());
            }
        }
    }

    private static String readVariable(BufferedReader bufferedReader, String string) throws IOException {
        System.out.print("Variable '" + string + "' = ");
        return bufferedReader.readLine();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: GraphTemplate [-img (png|gif|jpg)] [-w width] [-h height] [-q jpegQuality] <template_file> <image_name>");
            System.exit(0);
        }
        GraphTemplate.parseArguments(stringArray);
        try {
            System.out.println(">>> Reading XML template");
            RrdGraphDefTemplate rrdGraphDefTemplate = new RrdGraphDefTemplate(new File(templateFile));
            System.out.println(">>> Setting template variables");
            if (rrdGraphDefTemplate.hasVariables()) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String[] stringArray2 = rrdGraphDefTemplate.getVariables();
                for (int i = 0; i < stringArray2.length; ++i) {
                    rrdGraphDefTemplate.setVariable(stringArray2[i], GraphTemplate.readVariable(bufferedReader, stringArray2[i]));
                }
            }
            System.out.println(">>> Generating graph...");
            long l = System.currentTimeMillis();
            RrdGraph rrdGraph = new RrdGraph(rrdGraphDefTemplate.getRrdGraphDef());
            if (format.equalsIgnoreCase("png")) {
                rrdGraph.saveAsPNG(imageName, width, height);
            } else if (format.equalsIgnoreCase("gif")) {
                rrdGraph.saveAsGIF(imageName, width, height);
            } else if (format.equalsIgnoreCase("jpg")) {
                rrdGraph.saveAsJPEG(imageName, width, height, quality);
            }
            long l2 = System.currentTimeMillis();
            System.out.println(">>> Graph generated and saved in " + (l2 - l) + " milliseconds");
        }
        catch (RrdException rrdException) {
            GraphTemplate.die("RrdException occurred: " + rrdException.getMessage());
        }
        catch (IOException iOException) {
            GraphTemplate.die("IOException occurred: " + iOException.getMessage());
        }
    }
}

