/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo.graph;

import java.awt.Color;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.demo.graph.LazyDemoOpener;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

public class LazyDemo {
    private static String rrd1 = "eth0.rrd";
    private static String rrd2 = "eth1.rrd";
    private static String graph1 = Util.getJRobinDemoPath("lazy-graph1.png");
    private static String graph2 = Util.getJRobinDemoPath("lazy-graph2.png");
    private static String graph3 = Util.getJRobinDemoPath("lazy-graph3.png");
    private static String graph4 = Util.getJRobinDemoPath("lazy-graph4.png");
    private static String demoResources = "";
    private static int runCount = 0;
    private static long runStart;
    private static long runStop;
    private static long[] runTimes;
    private static RrdGraph graph;
    private static RrdGraphDef graphDef;
    private static GregorianCalendar start1;
    private static GregorianCalendar end1;
    private static GregorianCalendar start2;
    private static GregorianCalendar end2;
    private static GregorianCalendar start3;
    private static GregorianCalendar end3;
    private static GregorianCalendar start4;
    private static GregorianCalendar end4;

    private static void println(String string) {
        System.out.println(string);
    }

    private static void prepare(String[] stringArray) {
        demoResources = Util.getJRobinHomeDirectory() + "/res/demo/";
        rrd1 = demoResources + rrd1;
        rrd2 = demoResources + rrd2;
    }

    private static void createGraphs() throws RrdException, IOException {
        runStart = System.currentTimeMillis();
        graphDef.setTimePeriod(start1, end1);
        graph.saveAsPNG(graph1);
        graphDef.setTimePeriod(start2, end2);
        graph.saveAsPNG(graph2);
        graphDef.setTimePeriod(start3, end3);
        graph.saveAsPNG(graph3);
        graphDef.setTimePeriod(start4, end4);
        graph.saveAsPNG(graph4);
        runStop = System.currentTimeMillis();
        LazyDemo.runTimes[LazyDemo.runCount++] = runStop - runStart;
    }

    public static void main(String[] stringArray) throws RrdException, IOException {
        LazyDemo.prepare(stringArray);
        LazyDemo.println("+-----------------------------------------------------------------------------------+");
        LazyDemo.println("|                                JRobin LazyDemo                                    |");
        LazyDemo.println("|                                                                                   |");
        LazyDemo.println("| This demo illustrates the use of RrdOpener, FetchSourceList and the lazy flag of  |");
        LazyDemo.println("| the RrdGraphDef.                                                                  |");
        LazyDemo.println("|                                                                                   |");
        LazyDemo.println("+-----------------------------------------------------------------------------------+");
        long l = System.currentTimeMillis();
        graphDef = new RrdGraphDef();
        graphDef.area("bitsOutEth0", Color.RED, "Outgoing eth0");
        graphDef.stack("bitsOutEth1", Color.GREEN, "Outgoing eth1");
        graphDef.stack("bitsInEth0", Color.BLUE, "Incoming eth0");
        graphDef.stack("bitsInEth1", Color.YELLOW, "Incoming eth1");
        graph = new RrdGraph(graphDef);
        FetchSourceList fetchSourceList = new FetchSourceList(2, false, true, new LazyDemoOpener());
        fetchSourceList.add("bitsOutEth0", rrd1, "ifOutOctets", "AVERAGE");
        fetchSourceList.add("bitsInEth0", rrd1, "ifInOctets", "AVERAGE");
        fetchSourceList.add("bitsOutEth1", rrd2, "ifOutOctets", "AVERAGE");
        fetchSourceList.add("bitsInEth1", rrd2, "ifInOctets", "AVERAGE");
        graphDef.setDatasources(fetchSourceList);
        LazyDemo.println("\n>>> GRAPH RUN 1");
        graphDef.setLazy(false);
        LazyDemo.createGraphs();
        LazyDemo.println("\n>>> GRAPH RUN 2");
        graphDef.setLazy(true);
        LazyDemo.createGraphs();
        fetchSourceList.setPersistent(true);
        LazyDemo.println("\n>>> Manually opening all RRD references");
        fetchSourceList.openAll();
        LazyDemo.println("\n>>> GRAPH RUN 3");
        graphDef.setLazy(false);
        LazyDemo.createGraphs();
        LazyDemo.println("\n>>> GRAPH RUN 4");
        graphDef.setLazy(true);
        LazyDemo.createGraphs();
        fetchSourceList.setPersistent(false);
        LazyDemo.println("\n>>> Manually releasing all RRD references");
        fetchSourceList.releaseAll();
        LazyDemo.println("\n>>> Generation time results:");
        LazyDemo.println("  First run, no lazy, no persistence - normal generation: " + runTimes[0] + " ms");
        LazyDemo.println("  Second run, lazy, no persistence - generation skipped:  " + runTimes[1] + " ms");
        LazyDemo.println("  Third run, no lazy, persistence - normal generation:    " + runTimes[2] + " ms");
        LazyDemo.println("  Fourth run, lazy, persistence - generation skipped:     " + runTimes[3] + " ms");
    }

    static {
        runTimes = new long[4];
        start1 = new GregorianCalendar(2004, 6, 3);
        end1 = new GregorianCalendar(2004, 6, 4);
        start2 = new GregorianCalendar(2004, 6, 1);
        end2 = new GregorianCalendar(2004, 6, 8);
        start3 = new GregorianCalendar(2004, 5, 1);
        end3 = new GregorianCalendar(2004, 6, 1);
        start4 = new GregorianCalendar(2004, 6, 1);
        end4 = new GregorianCalendar(2004, 7, 1);
    }
}

