/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.Date;
import javax.swing.JFrame;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.demo.graph.SwingDemoPanel;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

public class SwingDemo {
    static JFrame frame = null;
    static SwingDemoPanel demoPanel = null;
    static RrdGraph graph = null;
    static RrdGraphDef gDef = null;
    static final String rrd = "SwingDemo.rrd";
    static final long START = Util.getTimestamp(2004, 1, 1);
    static Date end = new Date(START);

    static void prepareRrd() throws IOException, RrdException {
        RrdDef rrdDef = new RrdDef(rrd, START - 300L, 300L);
        rrdDef.addDatasource("a", "GAUGE", 600L, Double.NaN, Double.NaN);
        rrdDef.addArchive("AVERAGE", 0.5, 1, 300);
        rrdDef.addArchive("MIN", 0.5, 6, 300);
        rrdDef.addArchive("MAX", 0.5, 6, 300);
        RrdDb rrdDb = new RrdDb(rrdDef, RrdBackendFactory.getFactory("MEMORY"));
        rrdDb.close();
    }

    static void prepareFrame() throws RrdException {
        gDef = new RrdGraphDef();
        gDef.setImageBorder(Color.WHITE, 0);
        gDef.setTitle("JRobin Swing minmax demo");
        gDef.setVerticalLabel("value");
        gDef.setTimeAxisLabel("time");
        gDef.datasource("a", rrd, "a", "AVERAGE", "MEMORY");
        gDef.datasource("b", rrd, "a", "MIN", "MEMORY");
        gDef.datasource("c", rrd, "a", "MAX", "MEMORY");
        gDef.datasource("avg", "a", "AVERAGE");
        gDef.area("a", Color.decode("0xb6e4"), "real");
        gDef.line("b", Color.decode("0x22e9"), "min", 2);
        gDef.line("c", Color.decode("0xee22"), "max", 2);
        gDef.line("avg", Color.RED, "Average");
        gDef.time("@l@lTime period: @t", "MMM dd, yyyy   HH:mm:ss", START);
        gDef.time("to  @t@l", "HH:mm:ss", end);
        gDef.time("@lGenerated: @t@c", "HH:mm:ss");
        graph = new RrdGraph(gDef);
        frame = new JFrame("JRobin Swing Demo");
        frame.setDefaultCloseOperation(3);
        demoPanel = new SwingDemoPanel(graph);
        frame.getContentPane().add(demoPanel);
        frame.pack();
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = frame.getContentPane().getSize();
                demoPanel.setGraphDimension(dimension);
            }
        });
        frame.setBounds(10, 10, 504, 303);
        frame.show();
    }

    public static void main(String[] stringArray) throws Exception {
        long l;
        long l2;
        long l3;
        int n;
        SwingDemo.prepareRrd();
        SwingDemo.prepareFrame();
        RrdDb rrdDb = new RrdDb(rrd, RrdBackendFactory.getFactory("MEMORY"));
        Sample sample = rrdDb.createSample();
        long l4 = 0L;
        for (n = 1; n < 25; ++n) {
            l3 = System.currentTimeMillis();
            l4 = START + (long)(n * 300);
            sample.setTime(l4);
            sample.setValue("a", Math.sin((double)l4 / 3000.0) * 50.0 + 50.0);
            sample.update();
            gDef.setTimePeriod(START, l4);
            end.setTime(l4 * 1000L);
            frame.repaint();
            l2 = System.currentTimeMillis();
            l = l2 - l3;
            if (l >= 1000L) continue;
            Thread.sleep(1000L - l);
        }
        for (n = 0; n < 22; ++n) {
            l3 = System.currentTimeMillis();
            for (int i = 1; i < 13; ++i) {
                sample.setTime(l4 += 300L);
                sample.setValue("a", Math.sin((double)l4 / 3000.0) * 50.0 + 50.0);
                sample.update();
            }
            gDef.setTimePeriod(START, l4);
            end.setTime(l4 * 1000L);
            frame.repaint();
            l2 = System.currentTimeMillis();
            l = l2 - l3;
            if (l >= 1000L) continue;
            Thread.sleep(1000L - l);
        }
    }
}

