/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class XmlTemplate {
    private static final String PATTERN_STRING = "\\$\\{(\\w+)\\}";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    protected Element root;
    private HashMap valueMap = new HashMap();
    private HashSet validatedNodes = new HashSet();

    protected XmlTemplate(InputSource inputSource) throws IOException, RrdException {
        this.root = Util.Xml.getRootElement(inputSource);
    }

    protected XmlTemplate(String string) throws IOException, RrdException {
        this.root = Util.Xml.getRootElement(string);
    }

    protected XmlTemplate(File file) throws IOException, RrdException {
        this.root = Util.Xml.getRootElement(file);
    }

    public void clearValues() {
        this.valueMap.clear();
    }

    public void setVariable(String string, String string2) {
        this.valueMap.put(string, string2);
    }

    public void setVariable(String string, int n) {
        this.valueMap.put(string, new Integer(n));
    }

    public void setVariable(String string, long l) {
        this.valueMap.put(string, new Long(l));
    }

    public void setVariable(String string, double d) {
        this.valueMap.put(string, new Double(d));
    }

    public void setVariable(String string, Color color) {
        this.valueMap.put(string, "#" + Integer.toHexString(color.getRGB() & 0xFFFFFF));
    }

    public void setVariable(String string, Date date) {
        this.setVariable(string, Util.getTimestamp(date));
    }

    public void setVariable(String string, GregorianCalendar gregorianCalendar) {
        this.setVariable(string, Util.getTimestamp(gregorianCalendar));
    }

    public void setVariable(String string, boolean bl) {
        this.valueMap.put(string, "" + bl);
    }

    public boolean hasVariables() {
        return PATTERN.matcher(this.root.toString()).find();
    }

    public String[] getVariables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = PATTERN.matcher(this.root.toString());
        while (matcher.find()) {
            String string = matcher.group(1);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static Node[] getChildNodes(Node node, String string) {
        return Util.Xml.getChildNodes(node, string);
    }

    protected static Node[] getChildNodes(Node node) {
        return Util.Xml.getChildNodes(node, null);
    }

    protected static Node getFirstChildNode(Node node, String string) throws RrdException {
        return Util.Xml.getFirstChildNode(node, string);
    }

    protected boolean hasChildNode(Node node, String string) {
        return Util.Xml.hasChildNode(node, string);
    }

    protected String getChildValue(Node node, String string) throws RrdException {
        return this.getChildValue(node, string, true);
    }

    protected String getChildValue(Node node, String string, boolean bl) throws RrdException {
        String string2 = Util.Xml.getChildValue(node, string, bl);
        return this.resolveMappings(string2);
    }

    protected String getValue(Node node) {
        return this.getValue(node, true);
    }

    protected String getValue(Node node, boolean bl) {
        String string = Util.Xml.getValue(node, bl);
        return this.resolveMappings(string);
    }

    private String resolveMappings(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (this.valueMap.containsKey(string2)) {
                stringBuffer.append(string.substring(n, matcher.start()));
                stringBuffer.append(this.valueMap.get(string2).toString());
                n = matcher.end();
                continue;
            }
            throw new IllegalArgumentException("No mapping found for template variable ${" + string2 + "}");
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    protected int getChildValueAsInt(Node node, String string) throws RrdException {
        String string2 = this.getChildValue(node, string);
        return Integer.parseInt(string2);
    }

    protected int getValueAsInt(Node node) {
        String string = this.getValue(node);
        return Integer.parseInt(string);
    }

    protected long getChildValueAsLong(Node node, String string) throws RrdException {
        String string2 = this.getChildValue(node, string);
        return Long.parseLong(string2);
    }

    protected long getValueAsLong(Node node) {
        String string = this.getValue(node);
        return Long.parseLong(string);
    }

    protected double getChildValueAsDouble(Node node, String string) throws RrdException {
        String string2 = this.getChildValue(node, string);
        return Util.parseDouble(string2);
    }

    protected double getValueAsDouble(Node node) {
        String string = this.getValue(node);
        return Util.parseDouble(string);
    }

    protected boolean getChildValueAsBoolean(Node node, String string) throws RrdException {
        String string2 = this.getChildValue(node, string);
        return Util.parseBoolean(string2);
    }

    protected boolean getValueAsBoolean(Node node) {
        String string = this.getValue(node);
        return Util.parseBoolean(string);
    }

    protected boolean isEmptyNode(Node node) {
        return node.getNodeName().equals("#comment") || node.getNodeName().equals("#text") && node.getNodeValue().trim().length() == 0;
    }

    protected void validateTagsOnlyOnce(Node node, String[] stringArray) throws RrdException {
        if (this.validatedNodes.contains(node)) {
            return;
        }
        Node[] nodeArray = XmlTemplate.getChildNodes(node);
        block0: for (int i = 0; i < nodeArray.length; ++i) {
            String string = nodeArray[i].getNodeName();
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals(string)) {
                    stringArray[j] = "<--removed-->";
                    continue block0;
                }
                if (stringArray[j].equals(string + "*")) continue block0;
            }
            if (this.isEmptyNode(nodeArray[i])) continue;
            throw new RrdException("Unexpected tag encountered: <" + string + ">");
        }
        this.validatedNodes.add(node);
    }
}

