/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.Source;

class CustomArea
extends PlotDef {
    private long xVal1;
    private long xVal2;
    private double yVal1;
    private double yVal2;

    CustomArea(long l, double d, long l2, double d2, Color color) {
        this.color = color;
        if (color == null) {
            this.visible = false;
        }
        this.xVal1 = l;
        this.xVal2 = l2;
        this.yVal1 = d;
        this.yVal2 = d2;
    }

    void draw(ChartGraphics chartGraphics, int[] nArray, double[] dArray, int n) throws RrdException {
        chartGraphics.setColor(this.color);
        int n2 = this.xVal1 == Long.MIN_VALUE ? chartGraphics.getMinX() : (this.xVal1 == Long.MAX_VALUE ? chartGraphics.getMaxX() : chartGraphics.getX(this.xVal1));
        int n3 = this.xVal2 == Long.MIN_VALUE ? chartGraphics.getMinX() : (this.xVal2 == Long.MAX_VALUE ? chartGraphics.getMaxX() : chartGraphics.getX(this.xVal2));
        int n4 = this.yVal1 == Double.MIN_VALUE ? chartGraphics.getMinY() : (this.yVal1 == Double.MAX_VALUE ? chartGraphics.getMaxY() : chartGraphics.getY(this.yVal1));
        int n5 = this.yVal2 == Double.MIN_VALUE ? chartGraphics.getMinY() : (this.yVal2 == Double.MAX_VALUE ? chartGraphics.getMaxY() : chartGraphics.getY(this.yVal2));
        if (this.visible) {
            if (n5 > n4) {
                chartGraphics.fillRect(n2, n4, n3, n5);
            } else {
                chartGraphics.fillRect(n2, n5, n3, n4);
            }
        }
        if (this.yVal2 != Double.MAX_VALUE) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = nArray[i] < n2 || nArray[i] > n3 ? chartGraphics.getInverseY(0) : chartGraphics.getInverseY(n5);
            }
        }
    }

    double getValue(int n, long[] lArray) {
        long l = lArray[n];
        if (l > this.xVal2 || l < this.xVal1) {
            return Double.NaN;
        }
        if (this.yVal2 == Double.MAX_VALUE) {
            return Double.NaN;
        }
        return this.yVal2;
    }

    void setSource(Source[] sourceArray, HashMap hashMap) throws RrdException {
    }

    void setValue(int n, long l, long[] lArray) {
    }

    void exportXmlTemplate(XmlWriter xmlWriter, String string) {
        xmlWriter.startTag("area");
        xmlWriter.writeTag("time1", this.xVal1);
        xmlWriter.writeTag("value1", this.yVal1);
        xmlWriter.writeTag("time2", this.xVal2);
        xmlWriter.writeTag("value2", this.yVal2);
        xmlWriter.writeTag("color", this.color);
        xmlWriter.writeTag("legend", string);
        xmlWriter.closeTag();
    }
}

