/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Comment;
import org.jrobin.graph.Source;
import org.jrobin.graph.ValueFormatter;

class Gprint
extends Comment {
    private static final String SCALE_MARKER = "@s";
    private static final String UNIFORM_SCALE_MARKER = "@S";
    private static final String VALUE_MARKER = "@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})";
    private static final Pattern VALUE_PATTERN = Pattern.compile("@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})");
    private String sourceName;
    private int aggregate;
    private int numDec = 3;
    private int strLen = -1;
    private double baseValue = -1.0;
    private boolean normalScale = false;
    private boolean uniformScale = false;
    protected ArrayList parsedList;

    Gprint(String string, String string2, String string3) throws RrdException {
        this.text = string3;
        this.checkValuePlacement();
        this.commentType = 2;
        this.sourceName = string;
        if (string2.equalsIgnoreCase("AVERAGE") || string2.equalsIgnoreCase("AVG")) {
            this.aggregate = 2;
        } else if (string2.equalsIgnoreCase("MAX") || string2.equalsIgnoreCase("MAXIMUM")) {
            this.aggregate = 1;
        } else if (string2.equalsIgnoreCase("MIN") || string2.equalsIgnoreCase("MINIMUM")) {
            this.aggregate = 0;
        } else if (string2.equalsIgnoreCase("LAST")) {
            this.aggregate = 4;
        } else if (string2.equalsIgnoreCase("FIRST")) {
            this.aggregate = 3;
        } else if (string2.equalsIgnoreCase("TOTAL")) {
            this.aggregate = 5;
        } else {
            throw new RrdException("Invalid consolidation function specified.");
        }
    }

    Gprint(String string, String string2, String string3, double d) throws RrdException {
        this(string, string2, string3);
        this.baseValue = d;
    }

    void setValue(Source[] sourceArray, HashMap hashMap, ValueFormatter valueFormatter) throws RrdException {
        try {
            double d = sourceArray[(Integer)hashMap.get(this.sourceName)].getAggregate(this.aggregate);
            double d2 = valueFormatter.getBase();
            if (this.baseValue != -1.0 && this.baseValue != valueFormatter.getBase()) {
                valueFormatter.setBase(this.baseValue);
            }
            valueFormatter.setFormat(d, this.numDec, this.strLen);
            valueFormatter.setScaling(this.normalScale, this.uniformScale);
            String string = valueFormatter.getFormattedValue();
            String string2 = valueFormatter.getPrefix();
            this.parsedList = new ArrayList(this.oList);
            for (int i = 0; i < this.oList.size(); i += 2) {
                String string3 = (String)this.oList.get(i);
                string3 = string3.replaceAll(VALUE_MARKER, string);
                if (this.normalScale) {
                    string3 = string3.replaceAll(SCALE_MARKER, string2);
                }
                if (this.uniformScale) {
                    string3 = string3.replaceAll(UNIFORM_SCALE_MARKER, string2);
                }
                this.parsedList.set(i, string3);
            }
            if (this.baseValue != -1.0) {
                valueFormatter.setBase(d2);
            }
        }
        catch (Exception exception) {
            throw new RrdException("Could not find datasource: " + this.sourceName);
        }
    }

    ArrayList getTokens() {
        return this.parsedList;
    }

    private void checkValuePlacement() throws RrdException {
        Matcher matcher = VALUE_PATTERN.matcher(this.text);
        if (matcher.find()) {
            this.normalScale = this.text.indexOf(SCALE_MARKER) >= 0;
            boolean bl = this.uniformScale = this.text.indexOf(UNIFORM_SCALE_MARKER) >= 0;
            if (this.normalScale && this.uniformScale) {
                throw new RrdException("Can't specify normal scaling and uniform scaling at the same time.");
            }
            String[] stringArray = matcher.group(1).split("\\.");
            this.strLen = -1;
            this.numDec = 0;
            if (stringArray.length > 1) {
                if (stringArray[0].length() > 0) {
                    this.strLen = Integer.parseInt(stringArray[0]);
                    this.numDec = Integer.parseInt(stringArray[1]);
                } else {
                    this.numDec = Integer.parseInt(stringArray[1]);
                }
            } else {
                this.numDec = Integer.parseInt(stringArray[0]);
            }
        } else {
            throw new RrdException("Could not find where to place value. No @ placeholder found.");
        }
    }

    void exportXmlTemplate(XmlWriter xmlWriter) {
        xmlWriter.startTag("gprint");
        xmlWriter.writeTag("datasource", this.sourceName);
        xmlWriter.writeTag("cf", Source.aggregates[this.aggregate]);
        xmlWriter.writeTag("format", this.text);
        if (this.baseValue != -1.0) {
            xmlWriter.writeTag("base", this.baseValue);
        }
        xmlWriter.closeTag();
    }
}

