/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphDefTemplate;
import org.jrobin.mrtg.MrtgConstants;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.server.Config;
import org.jrobin.mrtg.server.RrdWriter;
import org.jrobin.mrtg.server.Server;

class Plotter
implements MrtgConstants {
    private String ifDescr;
    private String host;
    private String alias;
    private static RrdGraphDefTemplate rrdGraphDefTemplate = null;

    Plotter(String string, String string2) throws MrtgException {
        if (rrdGraphDefTemplate == null) {
            throw new MrtgException("Could not load graph XML template");
        }
        this.host = string;
        this.ifDescr = string2;
        this.alias = Server.getInstance().getDeviceList().getRouterByHost(string).getLinkByIfDescr(string2).getIfAlias();
    }

    byte[] getPngGraphBytes(long l, long l2) throws MrtgException {
        RrdGraph rrdGraph = this.getRrdGraph(l, l2);
        try {
            return rrdGraph.getPNGBytes(502, 234);
        }
        catch (RrdException rrdException) {
            throw new MrtgException(rrdException);
        }
        catch (IOException iOException) {
            throw new MrtgException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RrdGraph getRrdGraph(long l, long l2) throws MrtgException {
        RrdGraphDef rrdGraphDef;
        Object object = rrdGraphDefTemplate;
        synchronized (object) {
            rrdGraphDefTemplate.setVariable("start", l);
            rrdGraphDefTemplate.setVariable("end", l2);
            rrdGraphDefTemplate.setVariable("interface", this.ifDescr);
            rrdGraphDefTemplate.setVariable("host", this.host);
            rrdGraphDefTemplate.setVariable("rrd", RrdWriter.getRrdFilename(this.host, this.ifDescr));
            rrdGraphDefTemplate.setVariable("alias", this.alias);
            rrdGraphDefTemplate.setVariable("date_start", new Date(l * 1000L).toString());
            rrdGraphDefTemplate.setVariable("date_end", new Date(l2 * 1000L).toString());
            try {
                rrdGraphDef = rrdGraphDefTemplate.getRrdGraphDef();
            }
            catch (RrdException rrdException) {
                throw new MrtgException(rrdException);
            }
        }
        object = new RrdGraph(rrdGraphDef, true);
        return object;
    }

    static {
        try {
            rrdGraphDefTemplate = new RrdGraphDefTemplate(new File(Config.getGraphTemplateFile()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RrdException rrdException) {
            rrdException.printStackTrace();
        }
    }
}

