/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdDefTemplate;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.mrtg.Debug;
import org.jrobin.mrtg.MrtgConstants;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.server.Config;
import org.jrobin.mrtg.server.RawSample;

class RrdWriter
extends Thread
implements MrtgConstants {
    private RrdDefTemplate rrdDefTemplate;
    private int sampleCount;
    private int badSavesCount;
    private int goodSavesCount;
    private List queue = Collections.synchronizedList(new LinkedList());
    private static final RrdDbPool pool = RrdDbPool.getInstance();
    private volatile boolean active = true;

    RrdWriter() throws MrtgException {
        try {
            this.rrdDefTemplate = new RrdDefTemplate(new File(Config.getRrdTemplateFile()));
        }
        catch (IOException iOException) {
            throw new MrtgException(iOException);
        }
        catch (RrdException rrdException) {
            throw new MrtgException(rrdException);
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Debug.print("Archiver started");
        while (this.active) {
            Object object;
            while (this.active && this.queue.size() == 0) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Debug.print(interruptedException.toString());
                    }
                }
            }
            if (!this.active || this.queue.size() <= 0) continue;
            object = (RawSample)this.queue.remove(0);
            this.process((RawSample)object);
        }
        Debug.print("Archiver ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.active = false;
        RrdWriter rrdWriter = this;
        synchronized (rrdWriter) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void process(RawSample rawSample) {
        block15: {
            RrdDb rrdDb = null;
            rrdDb = this.openRrdFileFor(rawSample);
            Sample sample = rrdDb.createSample();
            sample.setTime(rawSample.getTimestamp());
            if (rawSample.isValid()) {
                sample.setValue("in", (double)rawSample.getIfInOctets());
                sample.setValue("out", (double)rawSample.getIfOutOctets());
            }
            sample.update();
            ++this.goodSavesCount;
            Object var5_6 = null;
            try {
                pool.release(rrdDb);
            }
            catch (IOException iOException) {
                Debug.print(iOException.toString());
            }
            catch (RrdException rrdException) {
                Debug.print(rrdException.toString());
            }
            break block15;
            {
                catch (IOException iOException) {
                    Debug.print(iOException.toString());
                    ++this.badSavesCount;
                    Object var5_7 = null;
                    try {
                        pool.release(rrdDb);
                    }
                    catch (IOException iOException2) {
                        Debug.print(iOException2.toString());
                    }
                    catch (RrdException rrdException) {
                        Debug.print(rrdException.toString());
                    }
                    break block15;
                }
                catch (RrdException rrdException) {
                    Debug.print(rrdException.toString());
                    ++this.badSavesCount;
                    Object var5_8 = null;
                    try {
                        pool.release(rrdDb);
                    }
                    catch (IOException iOException) {
                        Debug.print(iOException.toString());
                    }
                    catch (RrdException rrdException2) {
                        Debug.print(rrdException2.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    pool.release(rrdDb);
                }
                catch (IOException iOException) {
                    Debug.print(iOException.toString());
                }
                catch (RrdException rrdException) {
                    Debug.print(rrdException.toString());
                }
                throw throwable;
            }
        }
    }

    private String getRrdFilenameFor(RawSample rawSample) {
        return RrdWriter.getRrdFilename(rawSample.getHost(), rawSample.getIfDescr());
    }

    static String getRrdFilename(String string, String string2) {
        String string3 = string2.replaceAll("[^0-9a-zA-Z]", "_") + "@" + string.replaceFirst(":", "_") + ".rrd";
        return Config.getRrdDir() + string3;
    }

    synchronized void store(RawSample rawSample) {
        this.queue.add(rawSample);
        ++this.sampleCount;
        this.notify();
    }

    private RrdDb openRrdFileFor(RawSample rawSample) throws IOException, RrdException {
        String string = this.getRrdFilenameFor(rawSample);
        if (new File(string).exists()) {
            return pool.requestRrdDb(string);
        }
        this.rrdDefTemplate.setVariable("path", string);
        RrdDef rrdDef = this.rrdDefTemplate.getRrdDef();
        Debug.print("Creating: " + string);
        return pool.requestRrdDb(rrdDef);
    }

    int getSampleCount() {
        return this.sampleCount;
    }

    int getBadSavesCount() {
        return this.badSavesCount;
    }

    int getGoodSavesCount() {
        return this.goodSavesCount;
    }

    int getSavesCount() {
        return this.getGoodSavesCount() + this.getBadSavesCount();
    }
}

