/***********************************************************************
 ** md5.h -- header file for implementation of MD5                    **
 ** RSA Data Security, Inc. MD5 Message-Digest Algorithm              **
 ** Created: 2/17/90 RLR                                              **
 ** Revised: 12/27/90 SRD,AJ,BSK,JT Reference C version               **
 ** Revised (for MD5): RLR 4/27/91                                    **
 **********************************************************************/

/* Swiped from the Tripwire distribution. */

/* typedef a 32-bit type */
#ifdef TW_TYPE32
typedef unsigned TW_TYPE32 UINT4;
#else
#ifdef MSDOS
typedef unsigned long UINT4;
#else
#ifdef __alpha		/* 8-byte longs don't work! */
typedef unsigned int UINT4;
#else
typedef unsigned long int UINT4;
#endif /* __alpha */
#endif /* MSDOS */
#endif /* TW_TYPE32 */

/* Data structure for MD5 (Message-Digest) computation */
typedef struct {
  UINT4 i[2];                   /* number of _bits_ handled mod 2^64 */
  UINT4 buf[4];                                    /* scratch buffer */
  unsigned char in[64];                              /* input buffer */
} MD5_CTX;

void MD5Init();
void MD5Update();
void MD5Final();

/* Took this out of the struct; YOU pass the digest pointer to MD5Final,
   for *it* to fill in!
unsigned char digest[16];     /* actual digest after MD5Final call */
