/*
    EditorWindow.h - NSwindow subclass for Localize.app
    Copyright (C) 2003 Rob Burns

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02111, USA.
*/

#include "EditorWindow.h"

@implementation EditorWindow 

- (void) keyDown: (NSEvent *) theEvent
{
  NSString *characters;
  unichar character;

  characters = [theEvent characters];
  character = 0;

  if ( [characters length] > 0 )
    {
      character = [characters characterAtIndex: 0];

      switch ( character )
        { 
          case NSPageUpFunctionKey:
            NSBeep();
            break;
          default:
            [super keyDown: theEvent];
        }
    }
}

@end


