/*
    EditorWindowController.h - Editor window controller header for Localize.app
    Copyright (C) 2003 Rob Burns

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02111, USA.
*/

#ifndef _EDITOR_WINDOW_CONTROLLER_H_
#define _EDITOR_WINDOW_CONTROLLER_H_

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "StringsDocument.h"

@interface EditorWindowController : NSWindowController
{
  id filterList;
  id keyList;
  id file;
  id keyText;
  id valueText;
  id commentText;
  id fileLabel;
  
  NSMutableArray *index;
  
  NSImage *transImage;
  NSImage *notTransImage;
  NSImage *notTransUnMatchImage;
  NSImage *unMatchImage;
}


- (void) dealloc;
- (void) awakeFromNib;


// **************
// Action methods
// **************


- (void) selectKey: (id)sender;
- (void) deleteString: (id)sender;
- (void) setFilter: (id)sender;
- (void) showSource: (id)sender;
- (void) toggleTranslated: (id)sender;


// *************************** 
// NSTextView delegate methods
// ***************************


- (void) textDidChange: (NSNotification *)aNotification;


// ***************************
// NSWindowController methdods
// ***************************


- (NSString *) windowTitleForDocumentDisplayName: (NSString *)displayName;

@end

#endif // _EDITOR_WINDOW_CONTROLLER_H_


