#ifndef _STRINGS_DOCUMENT_READ_WRITE_
#define _STRINGS_DOCUMENT_READ_WRITE_

#include "StringsDocument.h"

/** Return whether value ch between min and max. */
#define inrange(ch,min,max) ((ch)>=(min) && (ch)<=(max))

/** Convert hex digit in ascii to decimal equivalent. */
#define char2num(ch) \
inrange(ch,'0','9') \
? ((ch)-0x30) \
: (inrange(ch,'a','f') \
? ((ch)-0x57) : ((ch)-0x37))

#define DUMMY @"<dummy>"

@class StringsEntry;

@interface StringsDocument (ReadWrite)

- (BOOL) parseInput: (NSString *)rawString;

- (NSString *) convertInput: (NSString *)myString;

- (BOOL) isTranslated: (NSString *)key;
- (void) addTranslated: (NSString *)key;

-(void) _writeTo: (NSMutableString *)str  entryHead: (StringsEntry *)se;
-(void) _writeTo: (NSMutableString *)str  entryFlags: (StringsEntry *)se;
-(void) _writeTo: (NSMutableString *)str  entryKey: (StringsEntry *)se;
-(void) _writeTo: (NSMutableString *)str  manyEntries: (NSMutableArray *)list;
-(BOOL) _shouldIgnore: (StringsEntry *)se;
-(NSString *) createOutput: (NSString *)filename;
- (NSData *) convertOutput: (NSString *)myString;



@end

#endif // _STRINGS_DOCUMENT_READ_WRITE_
