/*
    StringsDocument.h - NSDocumnet subclass header for Localize.app
    Copyright (C) 2003 Rob Burns

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02111, USA.
*/

#ifndef _STRINGS_DOCUMENT_H_
#define _STRINGS_DOCUMENT_H_

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "EditorWindowController.h"

@class StringsEntry;

@interface StringsDocument : NSDocument
{
  NSMutableArray *strings;
  NSString *global_comment;
  BOOL m_sGenerated;
  NSString *m_sHeader;
  
  NSMutableArray *repeatStrings;
  
  // variables for parsing the strings file, hopefully can get rid of these
  NSMutableArray *keys_translated;
  NSMutableArray *keys_matched;
}

- (void) dealloc;
- (id) init;
- (NSData *) dataRepresentationOfType: (NSString *)aType;
- (BOOL) loadDataRepresentation: (NSData *)docData ofType: (NSString*)docType;
- (void) makeWindowControllers;


// **************************
// Access and mutation methods
// ***************************


- (BOOL) m_sGenerated;
- (NSArray *) strings;

- (NSString *) keyForString: (StringsEntry *)string;
- (NSString *) fileForString: (StringsEntry *)string;
- (BOOL) stringIsMatched: (StringsEntry *)string;

- (NSString *) valueForString: (StringsEntry *)string;
- (void) setValue: (NSString *)value forString: (StringsEntry *)string;

- (NSString *) commentForString: (StringsEntry *)string;
- (void) setComment: (NSString *)comment forString: (StringsEntry *)string;

- (BOOL) stringIsTranslated: (StringsEntry *)string;
- (void) setTranslated: (BOOL)flag forString: (StringsEntry *)string; 

- (void) deleteString: (StringsEntry *)string;


// ******************************************
// NSOutlineView DataSource protocol methods
// ******************************************


- (id) outlineView: (NSOutlineView *) outlineView
             child: (int) index
            ofItem: (id) item;

- (BOOL) outlineView: (NSOutlineView *) outlineView
    isItemExpandable: (id) item;

-    (int) outlineView: (NSOutlineView *) outlineView
numberOfChildrenOfItem: (id) item;

- (id)        outlineView: (NSOutlineView *) outlineView
objectValueForTableColumn: (NSTableColumn *) tableColumn
                   byItem: (id)item;
               

// ***************
// Private methods
// ***************


- (void) tagRepeats;


@end

#endif // _STRINGS_DOCUMENT_H_
