/*
    EditorWindowController.m - Editor window controller for Localize.app
    Copyright (C) 2003 Rob Burns

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02111, USA.
*/

#include "EditorWindowController.h"

@implementation EditorWindowController

- (void) dealloc
{ 
  RELEASE(index);
  RELEASE(transImage);
  RELEASE(notTransImage);
  RELEASE(notTransUnMatchImage);
  RELEASE(unMatchImage);
  
  [super dealloc];
}

- (id) initWithWindowNibName: (NSString *) name
{
  if( (self = [super initWithWindowNibName: name]) )
    {
      index = [[NSMutableArray alloc] init];
      transImage = RETAIN([NSImage imageNamed: @"Translated"]);
      notTransImage = RETAIN([NSImage imageNamed: @"NotTranslated"]);
      notTransUnMatchImage = RETAIN([NSImage imageNamed: @"NotTransUnMatch"]);
      unMatchImage = RETAIN([NSImage imageNamed: @"unMatched"]);
      return self;
    }
  return nil;
}

- (void) awakeFromNib
{ 
  [self setFilter: self];
  [valueText setFieldEditor: YES];
  [commentText setFieldEditor: YES];
  [keyList setAutoresizesAllColumnsToFit: YES];  
  [keyList setDataSource: [self document]];
  [keyList reloadData];
  
  if( [[self document] m_sGenerated] )
    {
      // [fileLabel setStringValue: _(@"File:")];
      // [[filterList itemAtIndex: 0] setTitle: _(@"All Strings")];
      // [[filterList itemAtIndex: 1] setTitle: _(@"Untranslated Strings")];
      // [[filterList itemAtIndex: 2] setTitle: _(@"Unmatched Strings")];
    }
    
}

// Action methods
// ***************

- (void) selectKey: (id)sender
{
  
}

- (void) deleteString: (id)sender
{
  // int x = [[index objectAtIndex: [keyList selectedRowInColumn: 0]] intValue];

  // [[self document] deleteStringAtIndex: x];
  // [self setFilter: self];
}

- (void) setFilter: (id)sender
{
/*  NSString *filter = [filterList titleOfSelectedItem];
  int numberOfStrings = [[[self document] strings] count];
  int i;
 
  if( [filter isEqualToString: _(@"All Strings")] )
    {
      [index removeAllObjects];
      for( i=0;i<numberOfStrings;i++ )
        {
          [index addObject: [NSNumber numberWithInt: i]];
        }
    }
  else if( [filter isEqualToString: _(@"Untranslated Strings")] )
    {
      [index removeAllObjects];
      for( i=0;i<numberOfStrings;i++ )
        {
          if( ![[self document] isTranslatedAtIndex: i] )
            {
              [index addObject: [NSNumber numberWithInt: i]];
            }
        }
    }
  else if( [filter isEqualToString: _(@"Unmatched Strings")] )
    {
      [index removeAllObjects];
      for( i=0;i<numberOfStrings;i++ )
        {
          if( ![[self document] isMatchedAtIndex: i] )
            {
              [index addObject: [NSNumber numberWithInt: i]];
            }
        }
    }  */
}
                      
- (void) showSource: (id)sender
{
  NSLog(@"We Will be showing some source ...");
}
                      
- (void) toggleTranslated: (id)sender
{

}
                      
// NSOutlineView delegate methods
// ******************************


- (void) outlineView: (NSOutlineView *)aOutlineView
     willDisplayCell: (id)aCell
      forTableColumn: (NSTableColumn *)aTableColumn
                item: (id)item
{
  if(aOutlineView == keyList)
    {
      if( ![[self document] stringIsTranslated: item] )
        [aCell setFont: [NSFont boldSystemFontOfSize: 0]];
      else
        [aCell setFont: [NSFont systemFontOfSize: 0]];
        
      if( aTableColumn == [aOutlineView tableColumnWithIdentifier: @"Translated"] )
        {
          if( ![[self document] stringIsTranslated: item] );
            // [aCell setImage: notTransImage];
          else;
            // [aCell setImage: transImage];
        }
    }
}

- (void) outlineViewSelectionDidChange: (NSNotification *)aNotification
{
  int x = [keyList selectedRow];
  id item = [keyList itemAtRow: x];
      
  [keyText setString: [[self document] keyForString: item]];
  [valueText setString: [[self document] valueForString: item]];
      
  if( [[self document] m_sGenerated] )
    {
      [commentText setString: [[self document] commentForString: item]];
      [file setStringValue: [[self document] fileForString: item]];
    }
}


// ***************************
// NSTextView delegate methods
// ***************************

- (void) textDidChange: (NSNotification *)aNotification
{
  NSString *value;
  id item;
  int x = [keyList selectedRow];
  item = [keyList itemAtRow: x];
  
  if( [aNotification object] == valueText )
    {
      value = [NSString stringWithString: [valueText string]];
      [[self document] setValue: value forString: item];
    }
  
  if( [aNotification object] == commentText )
    {
      value = [NSString stringWithString: [commentText string]];
      [[self document] setComment: value forString: item];
    }
} 


// ***************************
// NSWindowController methdods
// ***************************


- (NSString *) windowTitleForDocumentDisplayName: (NSString *)displayName
{
  if( [[self document] fileName] != nil )
    {
      return [NSString stringWithFormat: @"%@ - %@", displayName,
        [[[self document] fileName] stringByDeletingLastPathComponent]];
    }
  return displayName;
}

@end

