/* $Id: controls.c,v 10.1 92/10/06 22:58:13 ca Exp $ */

#ifdef UNICOS
#include <sys/unistd.h>
#else  /* UNICOS */
#include <sys/file.h>
#endif  /* UNICOS */
#include <stdio.h>
#include "sim.h"
#include "list.h"
#include "simx.h"
#include "event.h"
#include "xtables.h"
#include "controls.h"

extern list *read_world();
extern char eventfilename[];

void toggle_display(), reset_display_mode();
/* This file contains the code for creating and painting the control
windows for the screen. The control windows are boxes which the
user clicks the mouse on to perform an action. */

static CONTROL control_types[] = {
  {0, 0, 0, "NULL", "Null"},
  {0, 0, 0, "START",  "DarkTurquoise"},
  {0, 0, 0, "CONTINUOUS",  "DarkTurquoise"},
  {0, 0, 0, "DELAY", "DarkTurquoise"},
  {0, 0, 0, "UPDATE", "DarkTurquoise"},
  {0, 0, 0, "DSP: ALL", "DarkTurquoise"},
  {0, 0, 0, "KILL",  "DarkTurquoise"},
  {0, 0, 0, "LOAD",  "DarkTurquoise"},
  {0, 0, 0, "SAVE",  "DarkTurquoise"},
  {0, 0, 0, "SNAP",  "DarkTurquoise"},
  {0, 0, 0, "RECORD",  "DarkTurquoise"},
  {0, 0, 0, "PLAY",    "DarkTurquoise"},
  {0, 0, 0, "PRINT", "DarkTurquoise"},
  {0, 0, 0, "QUIT", "DarkTurquoise"},
  {1, 0, 0, "NOTHING", "DarkTurquoise"},
};


/* This routine creates the windows for the control boxes and 
returns 1 if successful. */

Status pop_controls()

{
  Colormap clr_map;
  XColor clr;
  unsigned long pixels[15];
  int color;
  int position = 0;
  unsigned long dummy;
  char *color_string;
  char dummy_string[30];
  int counter; 
  unsigned num_windows;
  int x,y;
  Window the_window;
  

  for (num_windows = 0; control_types[num_windows].window != 1; ++num_windows)
    ;

  x = the_environment.width - the_environment.control_window_width -
     the_environment.border_width;

  y = Y_INITIAL;

  if (! the_environment.monochrome) {
    clr_map = DefaultColormap(the_environment.the_display, the_environment.the_screen);
    XAllocColorCells(the_environment.the_display, 
		     clr_map, 
		     0, 
		     &dummy, 
		     0, 
		     pixels, 
		     num_windows);
  }
 
  for (counter = 1; counter != num_windows; ++counter)
    {
      if (the_environment.monochrome == 1) {
	color = the_environment.back_color;
      } else {
	if (!(color_string = XGetDefault(the_environment.the_display, the_environment.pr_name, control_types[counter].name)))
	  color_string = strcpy(dummy_string, control_types[counter].background_color);
    
	XParseColor(the_environment.the_display, 
		    clr_map, 
		    color_string, 
		    &clr);
	clr.pixel = pixels[position++];
	XStoreColor(the_environment.the_display, 
		    clr_map, 
		    &clr);
	color = clr.pixel;
      }

      the_window = XCreateSimpleWindow(the_environment.the_display, 
				       the_environment.back_window, 
				       x, y, 
				       the_environment.control_window_width, 
				       the_environment.control_window_height, 
				       the_environment.border_width,
				       the_environment.fore_color, 
				       color);
      XSelectInput(the_environment.the_display,
		   the_window,
		   ExposureMask);

      XMapWindow(the_environment.the_display, the_window);
      control_types[counter].window = the_window;

     
      control_types[counter].hposition = (int) the_environment.control_window_height - ((the_environment.control_window_height - the_environment.control_font_info->ascent - the_environment.control_font_info->descent)/2);
      control_types[counter].wposition = (int)  (the_environment.control_window_width - XTextWidth(the_environment.control_font_info, control_types[counter].name, strlen(control_types[counter].name)))/2;


      XSaveContext(the_environment.the_display, the_window, control_xtable, (caddr_t)counter);
      y += the_environment.control_window_height + the_environment.border_width;

    }
  return(TRUE);
}



/* This routine prints text in the control boxes to indicate their
function. */

paint_controls(function)
     int function;
{
  XTextItem xtext;

  xtext.chars = control_types[function].name;
  xtext.nchars = strlen(control_types[function].name);
  xtext.font = the_environment.control_font;
  xtext.delta = 0;

  XDrawText(the_environment.the_display,
	    control_types[function].window,
	    the_environment.the_gc,
	    control_types[function].wposition, 
	    control_types[function].hposition,
	    &xtext,
	    1);
}


set_control_name(function, name)
     int function;
     char *name;
{

  strcpy(control_types[function].name, name);

  control_types[function].hposition = (int) the_environment.control_window_height - (the_environment.control_window_height - the_environment.control_font_info->ascent - the_environment.control_font_info->descent)/2;

  control_types[function].wposition = (int)  (the_environment.control_window_width - XTextWidth(the_environment.control_font_info, control_types[function].name, strlen(control_types[function].name)))/2;


}




control_button_press_handler(bevent, control_code, c_m_r)
     XButtonPressedEvent *bevent;
     int control_code;
     int c_m_r;
{

  char filename[256];
  char dummy_string[20];
  char *def;
  unsigned value;
  int x,y;
  int height;
  int num_windows;
  int counter;
  XWindowAttributes xinfo;

  if ((c_m_r == 1) && (bevent->button == user_bindings.move.button) && (bevent->state == user_bindings.move.key))
    {

      XGetWindowAttributes(the_environment.the_display,
			   the_environment.clock_window,
			   &xinfo);

      for (num_windows = 0; control_types[num_windows].window != 1; ++num_windows)
	;
      height = xinfo.height + the_environment.control_window_height*num_windows;
      x = bevent->x;
      y = bevent->y;

      move_window(&x, 
		  &y,
		  the_environment.control_window_width,
		  height,
		  x - xinfo.x, y - xinfo.y);
		  
      XMoveWindow(the_environment.the_display,
		  the_environment.clock_window,
		  x, y);
      XRaiseWindow(the_environment.the_display,
		   the_environment.clock_window);
      
      y += xinfo.height;

      for (counter = 1; counter < num_windows; ++counter) {
	XMoveWindow(the_environment.the_display,
		    control_types[counter].window,
		    x,y);
	XRaiseWindow(the_environment.the_display,
		     control_types[counter].window);

	y += the_environment.control_window_height + 
	   the_environment.border_width;
      }
      return;
    }
  switch (control_code)
    {	      

    case (QUIT):

      def =  XGetDefault(the_environment.the_display, the_environment.pr_name, "quitwarn");
      if ((def == (char *) 0) || strcmp("on", def) != 0) {
	 if (ev_now() != 0)
	    sim_stop(comps);
	 print_end_stat(stderr);
	 if (profile_flag) {
	    print_end_stat(profilefile);
	    print_rusage(profilefile);
	    fclose(profilefile);
	 }
	 exit(0);
      }
      xprintclear();
      printx("Are you sure you want to abort?(yes/no) ");
      if (xinput(dummy_string, 15) == 0)
	break;
      if (strcmp(dummy_string, "yes") == 0) {
	 if (ev_now() != 0)
	    sim_stop(comps);
	 print_end_stat(stderr);
	 if (profile_flag) {
	    print_end_stat(profilefile);
	    print_rusage(profilefile);
	    fclose(profilefile);
	 }
	 exit(0);
      }
      xprintclear();
      break;

    case (DESTROY):
      destroy_component();
      break;
    case (SAVE):
      xprintclear();
      printx("Enter filename in which to save this setup : ");
      if (xinput(filename, 255) == 0)
	/* User decided to abort */
	{
	  printx("Aborting.....");
	  sleep(1);
	  xprintclear();
	  break;
	}
      if (save_world(comps, filename) != (int) NULL)
	{
	  xprintclear();
	  printx("Setup saved in file ");
	  printx(filename);
	  sleep (2);
	  xprintclear();
	}
      break;
    case (LOAD):
      xprintclear();
      printx("Enter name of file : ");
      if (xinput(filename, 255) == 0)
	/* User decided to abort */
	{
	  printx("Aborting....");
	  sleep(1);
	  xprintclear();
	  break;
	}
      if (access(filename, R_OK) == -1)
	/* file does not exist */
	{
	  xprintclear();
	  printx("Can't access file, aborting...");
			sleep(2);
	  xprintclear();
	  break;
	}
      if (ev_now() != 0)
	 sim_stop(comps);
      destroy_world();
      (void) reset_display_mode();
      XSync(the_environment.the_display,
	    TRUE);
      comps = (list *) read_world(filename);
      if (comps == NULL)
	{
	  xprintclear();
	  printx("Error creating new world.");
	  sleep(2);
	  xprintclear();
	}
      else
	{
	  make_line_array();
	  connect_components();
	  xprintclear();
	}

      break;

     case (RUN_STEP):
	switch (the_environment.single_step) {
	 case 0 : /*** Single step mode on */
	    the_environment.single_step = 1;
	    set_control_name(RUN_STEP, "EVENT STEP");
	    XClearWindow(the_environment.the_display, control_types[RUN_STEP].window);
	    paint_controls(RUN_STEP);
	    break;
	  case 1 : /* time step */
	    the_environment.single_step = 2;
	    set_control_name(RUN_STEP, "TIME STEP");
	    XClearWindow(the_environment.the_display, control_types[RUN_STEP].window);
	    paint_controls(RUN_STEP);
	    break;
	  case 2 : /*** Single step mode off */
	    the_environment.single_step = 0;
	    set_control_name(RUN_STEP, "CONTINUOUS");
	    XClearWindow(the_environment.the_display, control_types[RUN_STEP].window);
	    paint_controls(RUN_STEP);
	    break;
	  default :;
	 }
      break;

    case (SNAP):
      xprintclear();
      printx("Enter filename in which to save present configuration : ");
      if (xinput(filename, 255) == 0)
	/* User decided to abort */
	{
	  xprintclear();
	  break;
	}
      if (save_snapshot(comps, filename) != (int) NULL)
	{
    	  xprintclear();
	  printx("Configuration saved in file ");
	  printx(filename);
	  sleep (2);
	  xprintclear();
	}
      break;

    case (PRINT):
      xprintclear();
      printx("Enter filename in which to save printout : ");
      if (xinput(filename, 255) == 0)  {
	xprintclear();
	break;
      }
      xprintclear();
      if (create_PS_file(comps, filename))
	printx("Topology printout saved; use 'lpr' to print");
      else
	printx("Print out failed");
      sleep(2);
      xprintclear();
      break;

/* toggle screen update variable */

    case (UPDATE):
      if (screen_update == ON)
	screen_update = OFF;
      else
	screen_update = ON;
      break;

/* Start simulation. */

    case (START):
      /* Reset everything, and then start everything. */
      if (ev_now() != 0)
	 sim_stop(comps);
      the_environment.never_ran = FALSE;
      sim_reset(comps);
      sim_start(comps);
      break;

/* set delay */

    case (DELAY):
      xprintclear();
      printx("Please enter delay between events (in microseconds)[");
      value = ev_get_delay();
      sprintf(dummy_string, "%d", value);
      printx(dummy_string);
      printx("] : ");
      if (xinput(dummy_string, 20) == 0)
	{
	  xprintclear();
	  break;
	}
      xprintclear();
      ev_set_delay((tick_t) atoi(dummy_string));
      break;

    case (DISPLAY):
       toggle_display();
       break;

    case (RECORD):
       record_flag = 1 - record_flag;
       if (record_flag) {
          if ((record_file = fopen(eventfilename, "a")) == NULL) {
             record_flag = 0;
             return;
          }
          set_control_name(RECORD, "STOP-RECORD");
       }
       else {
          fclose(record_file);
          set_control_name(RECORD, "RECORD");
       }
       XClearWindow(the_environment.the_display,control_types[RECORD].window);
       paint_controls(RECORD);
       break;
    case (PLAY):
      xprintclear();
      printx("Enter playback filename : ");
      if (xinput(playfilename, 255) == 0)
	/* User decided to abort */
	{
	  xprintclear();
	  break;
	}
      play_flag = 1;
      xprintclear();
      printx("You need to re-start for actual playing of the file ");
      printx(playfilename);
      sleep (3);
      xprintclear();
      break;
    default:
      break;
    }

}
		
void move_controls_to_top_right()
{

   int counter, x, y;

   x = the_environment.width - 
      the_environment.control_window_width -
	 the_environment.border_width;
   y = 0;
   XMoveWindow(the_environment.the_display,
	       the_environment.clock_window,
	       x, y);
   XRaiseWindow(the_environment.the_display,
		the_environment.clock_window);
      
   y = Y_INITIAL;
   for (counter = 1; control_types[counter].window != 1; 
	++counter) {
      XMoveWindow(the_environment.the_display,
		  control_types[counter].window,
		  x,y);
      XRaiseWindow(the_environment.the_display,
		   control_types[counter].window);
      y += the_environment.control_window_height + 
	 the_environment.border_width;
   }
}

static int display_mode = 0;

void toggle_display ()
{
   display_mode += 1;
   if (display_mode > 2)
      display_mode = 0;;
   switch (display_mode) {
    case 0:
      comp_display_all();
      set_control_name(DISPLAY, "DSP: ALL");
      break;
    case 1:
      comp_display_nodes();
      set_control_name(DISPLAY, "DSP: NODES");
      break;
    case 2:
      comp_display_sorted();
      set_control_name(DISPLAY, "DSP: SORTED");
      break;
    default : ;
   }
   XClearWindow(the_environment.the_display,control_types[DISPLAY].window);
   paint_controls(DISPLAY);
   XFlush(the_environment.the_display);
}

void reset_display_mode()
{
   display_mode = 0;
   set_control_name(DISPLAY, "DSP: ALL");
   XClearWindow(the_environment.the_display,control_types[DISPLAY].window);
   paint_controls(DISPLAY);
}

void set_record_flag(doXstuff)
int doXstuff;
{
   record_flag = 1;
   if ((record_file = fopen(eventfilename, "a")) == NULL) {
      record_flag = 0;
      return;
   }
   if (doXstuff)
      set_control_name(RECORD, "STOP-RECORD");
}
