/* $Id: lines.c,v 10.1 92/10/06 22:58:22 ca Exp $ */

#include <sys/types.h>
#include <stdio.h>
#include "q.h"
#include "list.h"
#include "hash.h"
#include "sim.h"
#include "simx.h"
#include "log.h"

static XSegment *line_array;
static int number_of_lines;
static unsigned amount_of_memory;

initialize_lines()
{
  line_array = (XSegment *) sim_calloc(1, sizeof(XSegment));
  number_of_lines = 0;
}



make_line_array()
{
  COMPONENT *component;       /* component we are drawing lines from */
  XCOMPONENT *xcomponent;     /* xcomponet we are drawing lines from */
  NEIGHBOR *neigh;            /* the component's neighbors */
  XWindowAttributes info;            /* x information about a window */
  short x1, x2, y1, y2;         /* x,y for a component and its neighbors */
  Window this_window, neighbor_window; /* windows for a component and its neighbors */
 

/* Loop through each component */

  number_of_lines  = 0;
  amount_of_memory = 20;
  free((char *) line_array);
  line_array = (XSegment *) sim_calloc(amount_of_memory, sizeof(XSegment));
  for (component = (COMPONENT *) comps->l_head; component != NULL; component = component->co_next)
    {

/* get the x and y coordinates, relative to the back window, for the
component's window. */

      xcomponent = (XCOMPONENT *) component->co_picture;
      this_window = xcomponent->comp_window;
/*      XGetWindowAttributes(the_environment.the_display, this_window, &info);*/
      x1 = (short) xcomponent->x + xcomponent->width / 2;
      y1 = (short) xcomponent->y + xcomponent->height / 2;

/* Loop through each of the component's neighbors */

      for (neigh =(NEIGHBOR *) (component->co_neighbors->l_head); neigh; neigh = neigh->n_next)
	{

/* Get the x and y coordinates for the neighboring window */

	  xcomponent = (XCOMPONENT *) neigh->n_c->co_picture;
	  neighbor_window = xcomponent->comp_window;
/*	  XGetWindowAttributes(the_environment.the_display, neighbor_window, &info);*/
	  x2 = (short) xcomponent->x + xcomponent->width / 2;
	  y2 = (short) xcomponent->y + xcomponent->height / 2;

	  if (check_array(x1, x2, y1, y2) != (int) NULL)
	    {
	    
	      line_array[number_of_lines].x1 = x1;
	      line_array[number_of_lines].x2 = x2;
	      line_array[number_of_lines].y1 = y1;
	      line_array[number_of_lines].y2 = y2;
	      number_of_lines++;
	      if (number_of_lines >= amount_of_memory)
		{
		  amount_of_memory += 10;
		  line_array = (XSegment *) realloc((char *) line_array, (unsigned) (amount_of_memory * sizeof(XSegment)));
		}
	    }
	}
    }
}



move_component_array_modify(component, oldx, oldy)
     COMPONENT *component;
     short oldx, oldy;
{
  short x1, y1, x2, y2;
  int position;
  NEIGHBOR *neigh;
  XCOMPONENT *xcomponent;
  XWindowAttributes info;            /* x information about a window */
  Window this_window, neighbor_window; /* windows for a component and its neighbors */

  xcomponent = (XCOMPONENT *) component->co_picture;
  this_window = xcomponent->comp_window;
/*  XGetWindowAttributes(the_environment.the_display, 
		       this_window, 
		       &info);*/
  x1 = (short) xcomponent->x + xcomponent->width / 2;
  y1 = (short) xcomponent->y + xcomponent->height / 2;

  oldx = (short) oldx + xcomponent->width / 2;
  oldy = (short) oldy + xcomponent->height / 2;

 
  /* Loop through each of the component's neighbors */

  for (neigh =(NEIGHBOR *) (component->co_neighbors->l_head); neigh; neigh = neigh->n_next)
    {
	  
/* Get the x and y coordinates for the neighboring window */

      xcomponent = (XCOMPONENT *) neigh->n_c->co_picture;
      neighbor_window = xcomponent->comp_window;
/*      XGetWindowAttributes(the_environment.the_display, 
			   neighbor_window, 
			   &info);*/
      x2 = (short) xcomponent->x + xcomponent->width / 2;
      y2 = (short) xcomponent->y + xcomponent->height / 2;

      if ((position = in_array(oldx, x2, oldy, y2)) != -1)
	{
	  line_array[position].x1 = x1;
	  line_array[position].x2 = x2;
	  line_array[position].y1 = y1;
	  line_array[position].y2 = y2;
	}
    }
}



add_connection_array_modify(component1, component2)
     COMPONENT *component1, *component2;
{
  XWindowAttributes info;            /* x information about a window */
  XCOMPONENT *xcomponent;
  short x1, x2, y1, y2;         /* x,y for a component and its neighbors */
  Window this_window; /* windows for a component and its neighbors */



  /* get the x and y coordinates, relative to the back window, for the 2
component's window. */

  xcomponent = (XCOMPONENT *) component1->co_picture;
  this_window = xcomponent->comp_window;
/*  XGetWindowAttributes(the_environment.the_display, this_window, &info);*/
  x1 = (short) xcomponent->x + xcomponent->width / 2;
  y1 = (short) xcomponent->y + xcomponent->height / 2;

  xcomponent = (XCOMPONENT *) component2->co_picture;
  this_window = xcomponent->comp_window;
/*  XGetWindowAttributes(the_environment.the_display, this_window, &info);*/
  x2 = (short) xcomponent->x + xcomponent->width / 2;
  y2 = (short) xcomponent->y + xcomponent->height / 2;
  	    
  line_array[number_of_lines].x1 = x1;
  line_array[number_of_lines].x2 = x2;
  line_array[number_of_lines].y1 = y1;
  line_array[number_of_lines].y2 = y2;
  number_of_lines++;
  if (number_of_lines >= amount_of_memory)
    {
      amount_of_memory += 10;
      line_array = (XSegment *) realloc((char *) line_array, (unsigned) (amount_of_memory * sizeof(XSegment)));
    }
}
	


delete_connection_array_modify(component1, component2)
     COMPONENT *component1, *component2;
{
  XWindowAttributes info;            /* x information about a window */
  XCOMPONENT *xcomponent;
  short x1, x2, y1, y2;         /* x,y for a component and its neighbors */
  Window this_window; /* windows for a component and its neighbors */
  register short i;
  int counter, end;
  XSegment *temp_array;

  /* get the x and y coordinates, relative to the back window, for the 2
component's window. */

  xcomponent = (XCOMPONENT *) component1->co_picture;
  this_window = xcomponent->comp_window;
/*  XGetWindowAttributes(the_environment.the_display, this_window, &info);*/
  x1 = (short) xcomponent->x + xcomponent->width / 2;
  y1 = (short) xcomponent->y + xcomponent->height / 2;

  xcomponent = (XCOMPONENT *) component2->co_picture;
  this_window = xcomponent->comp_window;
/*  XGetWindowAttributes(the_environment.the_display, this_window, &info);*/
  x2 = (short) xcomponent->x + xcomponent->width / 2;
  y2 = (short) xcomponent->y + xcomponent->height / 2;
  	    
  temp_array = (XSegment *) sim_calloc(amount_of_memory, sizeof(XSegment));

  end = number_of_lines;
  counter = 0;

  for (i = 0; i != end; ++i) 
    {
      if (((line_array[i].x1 == x1) &&
	   (line_array[i].x2 == x2) &&
	   (line_array[i].y1 == y1) &&
	   (line_array[i].y2 == y2)) ||
	  ((line_array[i].x1 == x2) &&
	   (line_array[i].x2 == x1) &&
	   (line_array[i].y1 == y2) &&
	 (line_array[i].y2 == y1)))
	{
	  number_of_lines--;
	}
      else
	{
	  temp_array[counter].x1 = line_array[i].x1;
	  temp_array[counter].x2 = line_array[i].x2;
	  temp_array[counter].y1 = line_array[i].y1;
	  temp_array[counter].y2 = line_array[i].y2;
	  counter++;  
	}
    }

  free((char *) line_array);
  line_array = (XSegment *) temp_array;
  
}


delete_component_array_modify(component)
     COMPONENT *component;
{

  XWindowAttributes info;            /* x information about a window */
  XCOMPONENT *xcomponent;
  short x1, y1;         /* x,y for a component and its neighbors */
  Window this_window; /* windows for a component and its neighbors */
  register short i;
  int counter, end;
  XSegment *temp_array;

  /* get the x and y coordinates, relative to the back window, for the 2
component's window. */

  xcomponent = (XCOMPONENT *)  component->co_picture;
  this_window = xcomponent->comp_window;
/*  XGetWindowAttributes(the_environment.the_display, this_window, &info);*/
  x1 = (short) xcomponent->x + xcomponent->width / 2;
  y1 = (short) xcomponent->y + xcomponent->height / 2;

  temp_array = (XSegment *) sim_calloc(amount_of_memory, sizeof(XSegment));

  end = number_of_lines;
  counter = 0;

  for (i = 0; i != end; ++i) 
    {
      if (((line_array[i].x1 == x1) &&
	   (line_array[i].y1 == y1)) ||
	  ((line_array[i].x2 == x1) &&
	   (line_array[i].y2 == y1)))
	{
	  number_of_lines--;
	}
      else
	{
	  temp_array[counter].x1 = line_array[i].x1;
	  temp_array[counter].x2 = line_array[i].x2;
	  temp_array[counter].y1 = line_array[i].y1;
	  temp_array[counter].y2 = line_array[i].y2;
	  counter++;  
	}
    }

  free((char *) line_array);
  line_array = (XSegment *) temp_array;
  
}



connect_components()
{

  if (the_environment.monochrome)
    {

      XDrawSegments(the_environment.the_display, 
		    the_environment.back_window, 
		    the_environment.the_gc,
		    line_array,
		    number_of_lines);
    }
  else
    {
      XDrawSegments(the_environment.the_display, 
		    the_environment.back_window, 
		    the_environment.line_gc,
		    line_array,
		    number_of_lines);
    }

}



check_array(x1, x2, y1, y2)
     register short  x1,x2,y1,y2;
{

  register int i;

  for (i = 0; i < number_of_lines; ++i)
    {
      if ((line_array[i].x1 == x1) &&
	  (line_array[i].x2 == x2) &&
	  (line_array[i].y1 == y1) &&
	  (line_array[i].y2 == y2))
	return ((int) NULL);
      if ((line_array[i].x1 == x2) &&
	  (line_array[i].x2 == x1) &&
	  (line_array[i].y1 == y2) &&
	  (line_array[i].y2 == y1))
	return ((int) NULL);

    }
  return (1);
}


in_array(x1, x2, y1, y2)
     register short x1, x2, y1, y2;
{
  
  register int i;

  for (i = 0; i < number_of_lines; ++i)
    {
      if ((line_array[i].x1 == x1) &&
	  (line_array[i].x2 == x2) &&
	  (line_array[i].y1 == y1) &&
	  (line_array[i].y2 == y2))
	return (i);
      if ((line_array[i].x1 == x2) &&
	  (line_array[i].x2 == x1) &&
	  (line_array[i].y1 == y2) &&
	  (line_array[i].y2 == y1))
	return (i);

    }
  return (-1);
}
