/* $Id: text.c,v 10.1 92/10/06 22:58:27 ca Exp $ */

#include <sys/types.h>
#include <stdio.h>
#include "sim.h"
#include "simx.h"

static Window text_window;
static int character_width, y_padding, xposition;
static char perm_string[100];
static int text_window_mapped;

text_init()
{
 
  xposition = 5;
 
  y_padding =(int)  the_environment.text_window_height - ((the_environment.text_window_height - the_environment.text_font_info->ascent - the_environment.text_font_info->descent) / 2);

  text_window = XCreateSimpleWindow(the_environment.the_display,
				    the_environment.back_window, 
				    0, 
				    the_environment.height - the_environment.text_window_height - the_environment.border_width, 
				    the_environment.width, 
				    the_environment.text_window_height, 
				    the_environment.border_width, 
				    the_environment.fore_color,
				    the_environment.text_color);

  character_width = the_environment.text_font_info->max_bounds.width;

  XSelectInput(the_environment.the_display,
	       text_window, 
	       ExposureMask); 

  text_window_mapped = FALSE;
  return (OK);
}



update_text()
{
  if (text_window_mapped == TRUE) {
    XUnmapWindow(the_environment.the_display,
		 text_window);
    text_window_mapped = FALSE;
    XFlush(the_environment.the_display);
  }
  
}



xprintclear()
{
  int counter;

  XClearWindow(the_environment.the_display, 
	       text_window);
  xposition = 5; /* set tab */
  for (counter = 0; counter != 100; perm_string[counter++] = '\0')
    ;
  if (text_window_mapped == FALSE) {
    XMapRaised(the_environment.the_display,
	       text_window);
    text_window_mapped = TRUE;
  }
  XFlush(the_environment.the_display);
}


/* This routine accepts a pointer to a character array and its length.
It prints those characters in text_window. It does not return anything.*/

xprint(string, length)
char string[];
int length;
{
  int counter;

  XSetBackground(the_environment.the_display,
		 the_environment.the_gc,
		 the_environment.text_color);

  XSetFont(the_environment.the_display,
	   the_environment.the_gc,
	   the_environment.text_font);

  if (text_window_mapped == FALSE) {
    XMapRaised(the_environment.the_display,
	       text_window);
    text_window_mapped = TRUE;
  }

  for (counter = 0; counter < length; ++counter)
    {
      if (string[counter] == 127)
	{
	  if (xposition > (5 + character_width))
	    {
	      perm_string[(xposition - 5)/character_width] = '\0';
	      xposition -= character_width;

	      XDrawImageString(the_environment.the_display, 
			       text_window, 
			       the_environment.the_gc,
			       xposition, 
			       y_padding,
			       " ", 
			       1);

	    }
	}
      else if (string[counter] == 13)
	{
	  continue;
	}
      else
	{
	  XDrawImageString(the_environment.the_display,
			   text_window, 
			   the_environment.the_gc,
			   xposition, 
			   y_padding, 
			   &(string[counter]), 
			   1);

	  xposition += character_width;
	  perm_string[(xposition-5)/character_width] = string[counter];
	  if (xposition >= the_environment.width)
	    xprintclear();
	}
    }

  XFlush(the_environment.the_display);
}


/* This routine accepts a pointer to a character array and the 
maximum length of that array. It fills in the array with keyboard
input, which it also echoes to the  screen. It puts a \0 at the
end of the string. It returns the number of characters that it
put in the array, not including the null terminator. */

int xinput(string, maxlength)
char string[];
int maxlength;
{
  int position = 0;
  char dummy_string[5];
  int nbytes;
  XEvent event;
  XKeyPressedEvent *kevent;

  

  while (position <= (maxlength - 1))
    {
      XNextEvent(the_environment.the_display, &event); 
      if (event.type == Expose)  {
	general_expose_event_handler((XExposeEvent *) &event);
	continue;
      }
      if (event.type != KeyPress)
	continue;
      kevent = (XKeyPressedEvent *) &event;
      nbytes= XLookupString(kevent, dummy_string, 4, NULL, NULL);
      if (nbytes != 1)
	{
	  continue;
	}
      else if (*dummy_string == 13)
	{
	  break;
	}
      else if (*dummy_string == 127)
	{
	  if (position >0)
	    {
	      xprint(dummy_string, 1);
	      --position;
	    }
	}
      else if (position < (maxlength - 1))
	{
	  xprint(dummy_string, 1);
	  string[position++] = *dummy_string;
	}

    }

  string[position] = '\0';
  return (position);
}



/* This routine accepts a poniter to a character array and prints it 
in text_window. It is more convenient than xprint because it does not
require the length of the string. (It uses strlen to find that.) */

printx(string)
char string[];
{
  xprint(string, strlen(string));
}


move_text_window(window_height)
     int window_height;         /* new height of background window */
{
  XMoveWindow(the_environment.the_display,
	      text_window,
	      0,
	      window_height - the_environment.text_window_height - the_environment.border_width);
}
