/* $Id: update.c,v 10.1 92/10/06 22:58:28 ca Exp $ */

#include <sys/types.h>
#include <stdio.h>
#include "sim.h"
#include "simx.h"
#include "xtables.h"


/* This file contains the code for updating the screen for each
tick of the simulator */

/* this is the main routine. It simply calls the other routines
necessary to update the screen. */

update_screen()
{
  update_clock();
  if (screen_update != (int) NULL)
    {
      update_meters_and_info_windows();
      update_text();
      XFlush(the_environment.the_display);
    }
  else if ((screen_update == (int) NULL) && (the_environment.iconified == TRUE))
    {
      update_meters_iconified();
    }
}



/* This routine goes through each component and redraws the 
meters whose components have changed. It also updates the 
infowindows. */

update_meters_and_info_windows()
{
  COMPONENT *scomponent;
  PARAM *parameter;
  XCOMPONENT *xcomponent;
  register int i;
  char info_string[100];
 
/* Loop through each component */

  for(scomponent = (COMPONENT *) comps->l_head; scomponent; scomponent = scomponent->co_next) {

    xcomponent = (XCOMPONENT *) scomponent->co_picture;
         
    for (i = 0; i != xcomponent->num_meters; ++i) {

      parameter = xcomponent->m_list[i];
      if ((parameter->p_display_type & MeterTypeMask) == TIME_HISTORY)
	{
	  update_time_history_meter(scomponent, parameter);
	}
      else if (parameter->p_flags & ChangeMask) 
	{
	  if ((parameter->p_display_type & MeterTypeMask) == TIME_HISTORY_D)
	    {
	      update_time_history_d_meter(scomponent, parameter);
	    }
	  else if ((parameter->p_display_type & MeterTypeMask) == DELTA)
	    {
	      update_delta_meter(scomponent, parameter);
	    }
 	  else if ((parameter->p_display_type & MeterTypeMask) == HISTOGRAM)
 	  {
 		  update_histogram_meter (scomponent, parameter);
 	  }
	  else
	    {
	      paint_meter(scomponent, parameter, NULL, NULL);
	    }
	  if (!scomponent->co_menu_up)
	    parameter->p_flags &= ~ChangeMask;
	}
    }
    
    if (scomponent->co_menu_up == (int) NULL)
      continue;
	
   
    XSetFont(the_environment.the_display,
	     the_environment.the_gc,
	     the_environment.info_font);

   	
    XSetBackground(the_environment.the_display,
		   the_environment.the_gc,
		   the_environment.component_color[scomponent->co_type]); 

    /* Loop through each displayed parameter */
	
    for (i = 0; i < xcomponent->num_params; ++i) {
      parameter = xcomponent->p_list[i];
      if (parameter->p_flags & ChangeMask)
	{
	  parameter->p_flags &= ~ChangeMask;
		/* Get new string and add two spaces to avoid leaving 
		   any part of old string displayed. */
		
	  strncpy((char *) info_string, (*(parameter->p_make_text))(scomponent, parameter), sizeof(info_string) - 10);

	  strcat((char *) info_string, "     ");

	  XDrawImageString(the_environment.the_display,
			   xcomponent->info_window,
			   the_environment.the_gc,
			   ((2 * the_environment.meter_indicator_width) + 6),
			   (i * the_environment.info_window_height + the_environment.info_window_vertical_padding),
			   info_string, 
			   strlen(info_string));
	    
	}
    }
  }
}



update_meters_iconified()
{
  COMPONENT *scomponent;
  PARAM *parameter;
  XCOMPONENT *xcomponent;
  register int i;
 
/* Loop through each component */

  for(scomponent = (COMPONENT *) comps->l_head; scomponent; scomponent = scomponent->co_next) {

    xcomponent = (XCOMPONENT *) scomponent->co_picture;
      
    for (i = 0; i != xcomponent->num_meters; ++i) {

      parameter = xcomponent->m_list[i];
      if ((parameter->p_display_type & MeterTypeMask) == TIME_HISTORY)
	{
	  update_time_history_meter(scomponent, parameter);
	} 
      else if (parameter->p_flags & ChangeMask) 
	{
	  if ((parameter->p_display_type & MeterTypeMask) == TIME_HISTORY_D)
	    {
	      update_time_history_d_meter(scomponent, parameter);
	    }
	  else if ((parameter->p_display_type & MeterTypeMask) == DELTA)
	    {
	      update_delta_meter(scomponent, parameter);
	    }
	  parameter->p_flags &= ~ChangeMask;
	}
    }
  }
}
    
 
