/* $Id: xinit.c,v 10.1 92/10/06 22:58:30 ca Exp $ */

#include <sys/types.h>
#include <stdio.h>
#include <X11/cursorfont.h>
#include "sim.h"
#include "simx.h"
#include "xtables.h"
#include "comptypes.h"


/* This file contains the code for initializing the X global
variables. It also sets up the screen for the simulator. */

ENVIRONMENT the_environment;
KEY_BINDING user_bindings;
XContext comp_xtable, control_xtable, th_xtable, meter_xtable, meterinfo_xtable;
GC color_gc[18];

/* This routine initializes all of the x variables and sets
up the screen */

Status xinit()
{
  int i;
  XWMHints xiconhints;
  XSizeHints xsizehints;
  XSetWindowAttributes xattributes;
  Visual *visual;
  static int errorHandler();
  char	*geo_string = NULL;

  if((the_environment.the_display = XOpenDisplay((char *)NULL)) == NULL)
    return (ERROR);

  the_environment.the_screen = DefaultScreen(the_environment.the_display);
  the_environment.the_gc = DefaultGC(the_environment.the_display,
				     the_environment.the_screen);

  
  visual = DefaultVisual(the_environment.the_display,
			 the_environment.the_screen);

  if (visual->class == StaticGray && visual->map_entries == 2)
    the_environment.monochrome = 1;
  else
    the_environment.monochrome = 0;

  XSetFunction(the_environment.the_display,
	       the_environment.the_gc,
	       GXcopy);

  XSetLineAttributes(the_environment.the_display,
		     the_environment.the_gc,
		     0,
		     LineSolid,
		     CapButt,
		     JoinMiter);

  XSetGraphicsExposures(the_environment.the_display, the_environment.the_gc,
			TRUE);

  initialize_fonts();
  initialize_colors();
  initialize_key_bindings();
  initialize_gcs();

  comp_xtable = XUniqueContext();
  control_xtable = XUniqueContext();
  th_xtable = XUniqueContext();
  meter_xtable = XUniqueContext();
  meterinfo_xtable = XUniqueContext();

  the_environment.delta = 7;

  the_environment.width = 
     DisplayWidth(the_environment.the_display, the_environment.the_screen) 
	* 9 / 10;
  the_environment.height = 
     DisplayHeight(the_environment.the_display, the_environment.the_screen) 
	* 9 / 10;

  the_environment.x_center = the_environment.width /2;
  the_environment.y_center = the_environment.height /2;

  the_environment.x = 0;
  the_environment.y = 0;

  the_environment.component_window_height = 25;
  the_environment.component_window_width = 70;

  the_environment.control_window_width = 120;
  the_environment.control_window_height = 30;

  the_environment.text_window_width = 923;
  the_environment.text_window_height = 36;

  the_environment.info_window_width = 265;
  the_environment.info_window_vertical_padding = 5;

  the_environment.info_window_height = 
     (the_environment.info_window_vertical_padding * 2) + 
	the_environment.info_font_info->ascent + 
	   the_environment.info_font_info->descent;

  the_environment.info_window_vertical_padding += 
     the_environment.info_font_info->ascent + 
	the_environment.info_font_info->descent;
  the_environment.info_window_horizontal_padding = 4;
  the_environment.meter_info_window_entries = 11;

  the_environment.meter_indicator_width = 15;
  the_environment.border_width = 1;


  the_environment.meter_window_height = 15;
  the_environment.meter_window_width = the_environment.component_window_width;

  the_environment.single_step = 0;
  the_environment.iconified = FALSE;

  the_environment.back_window = 
     XCreateSimpleWindow(the_environment.the_display,
			 XDefaultRootWindow(the_environment.the_display), 
			 0, 0, 
			 the_environment.width,
			 the_environment.height, 
			 0, 
			 the_environment.fore_color,
			 the_environment.back_color);
  
  the_environment.icon_window = 
    XCreateSimpleWindow(the_environment.the_display,
			XDefaultRootWindow(the_environment.the_display),
			500,500,120,30,2,
			the_environment.fore_color,
			the_environment.clock_color);

  XSelectInput(the_environment.the_display, 
	       the_environment.back_window, 
	       ExposureMask | 
	       ButtonPressMask | 
	       ButtonReleaseMask | 
	       ButtonMotionMask |
	       StructureNotifyMask |
	       KeyPressMask);

  XSelectInput(the_environment.the_display,
	       the_environment.icon_window, 
	       ExposureMask | 
	       StructureNotifyMask);

  xsizehints.flags = PPosition | PSize;
  xsizehints.width = the_environment.width;
  xsizehints.height = the_environment.height;
  xsizehints.x = 0;
  xsizehints.y =  0;

  if(geo_string = XGetDefault(the_environment.the_display, 
			      the_environment.pr_name, "geometry"))
  {
	  int	mask;
	  
	  mask = XParseGeometry(geo_string, &xsizehints.x, &xsizehints.y,
				(unsigned int *)&xsizehints.width,
				(unsigned int *)&xsizehints.height);
	  if(mask & (HeightValue | WidthValue))
		  xsizehints.flags |= USSize;
	  if(mask & (XValue | YValue))
		  xsizehints.flags |= USPosition;
  }

  the_environment.x = xsizehints.x;
  the_environment.y = xsizehints.y;
  the_environment.width = xsizehints.width;
  the_environment.height = xsizehints.height;

  XSetStandardProperties(the_environment.the_display,
		  the_environment.back_window, "Maryland Routing Simulator", 
		  "mars", (int) NULL,
		  NULL, 0, &xsizehints);
		  
  xiconhints.flags = IconWindowHint;
  xiconhints.icon_window = the_environment.icon_window;

  XSetWMHints(the_environment.the_display,
	      the_environment.back_window,
	      &xiconhints);

  xsizehints.flags = PSize;
  xsizehints.width = 120;
  xsizehints.height = 30;
 
  XSetNormalHints(the_environment.the_display,
		  the_environment.icon_window,
		  &xsizehints);



/*  xattributes.override_redirect = ON;
  XChangeWindowAttributes(the_environment.the_display,
			  the_environment.back_window,
			  CWOverrideRedirect,
			  &xattributes); */

  XMapWindow(the_environment.the_display, the_environment.back_window);

  if(!pop_clock())
    return(ERROR);
  paint_clock();

  pop_controls();

  if (text_init() == ERROR)
    return (ERROR);

  initialize_lines();

 
  screen_update = ON;

  XDefineCursor(the_environment.the_display, 
		the_environment.back_window, 
		XCreateFontCursor(the_environment.the_display,
				  XC_X_cursor));

  XFlush(the_environment.the_display);
  return (OK);

}



/* This routine initializes the variables to their correct values*/

/** Colors to be used for packets */

#define n_packet_colors 18
extern int packet_colors[];
extern int num_packet_colors;
static char *pk_color_names[] = {
  "green", "#ff0000", "#ff00ff", "#8a23bc", "#00ff00", "#23238e",
  "#eaadea", "#0000ff", "#812f81", "#00ffff", "#ff7f00", "#db9370",
  "#82493e", "#ffff00", "#ffffff", "#00ff7f", "#ff007f", "#7f00ff"
};

#define n_colors 40   /* Number of colors to be used */

/* The plane mask for the colors that we allocate.  Needs to be shared
   within this file, but not globally. */
static unsigned long line_plane_mask;

initialize_colors()

{
  Colormap clr_map;
  XColor clr;
  unsigned long pixel[n_colors + n_packet_colors];
  int position = 0;
  char *color_string;
  int counter;
  int num_types = 0;
  char dummy_string[30];
  int i;

  if (the_environment.monochrome) {

    if (the_environment.reverse_video) {
      the_environment.fore_color = WhitePixel(the_environment.the_display,
					      the_environment.the_screen);
      the_environment.back_color = BlackPixel(the_environment.the_display,
					      the_environment.the_screen);
    } else {
      the_environment.fore_color = BlackPixel(the_environment.the_display,
					      the_environment.the_screen);
      the_environment.back_color = WhitePixel(the_environment.the_display,
					      the_environment.the_screen);
    }

    XSetForeground(the_environment.the_display,
		   the_environment.the_gc,
		   the_environment.fore_color);

    num_packet_colors = 1;
    packet_colors[0] = the_environment.back_color;
    the_environment.text_color = the_environment.back_color;
    the_environment.clock_color = the_environment.back_color;
    the_environment.edit_color = the_environment.back_color;
    for (num_types = 0; component_types[num_types].action; num_types++)
      {
	the_environment.component_color[num_types] =
	  	the_environment.back_color;
	the_environment.component_back_gc[num_types] =
	  XCreateGC(the_environment.the_display,
		    XDefaultRootWindow(the_environment.the_display),
		    0, NULL);
	XSetForeground(the_environment.the_display,
		       the_environment.component_back_gc[num_types],
		       the_environment.back_color);
      }
  } else {

     /* Allocate some color cells */
    clr_map = DefaultColormap(the_environment.the_display, the_environment.the_screen);

    if (! XAllocColorCells(the_environment.the_display, 
		     clr_map, 
		     0, &line_plane_mask, 
		     1, pixel, 
		     n_colors + n_packet_colors)) {
       fputs ("XAllocColorCells failed\n", stderr);
       exit (1);
     }
       

    /** set up all colors to be put into packets & used in busy meters */

    num_packet_colors = n_packet_colors;
    for (i = 0; i < n_packet_colors; i++)  {
      XParseColor(the_environment.the_display, clr_map,pk_color_names[i], &clr);
      clr.pixel = pixel[position++];
      XStoreColor(the_environment.the_display, clr_map,&clr);
      clr.pixel |= line_plane_mask;
      XStoreColor (the_environment.the_display, clr_map, &clr);
      packet_colors[i] = clr.pixel;
    }

    /* set foreground color */

    clr.blue = 0;
    clr.red = 0;
    clr.green = 0;
    clr.pixel = pixel[position++];
    XStoreColor(the_environment.the_display, clr_map,&clr);
    clr.pixel |= line_plane_mask;
    XStoreColor (the_environment.the_display, clr_map, &clr);

    the_environment.fore_color = clr.pixel;
					
    XSetForeground(the_environment.the_display,
		   the_environment.the_gc,
		   the_environment.fore_color);

    /* set text color */

    if(!(color_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "textcolor")))
      color_string = strcpy(dummy_string, "DarkTurquoise");
    XParseColor(the_environment.the_display, clr_map,color_string, &clr);
    clr.pixel = pixel[position++];
    XStoreColor(the_environment.the_display, clr_map,&clr);
    clr.pixel |= line_plane_mask;
    XStoreColor (the_environment.the_display, clr_map, &clr);
 
    the_environment.text_color = clr.pixel;

    /* set clock color */


    if(!(color_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "clockcolor")))
      color_string = strcpy(dummy_string, "aquamarine");
    XParseColor(the_environment.the_display, clr_map,color_string, &clr);
    clr.pixel = pixel[position++];
    XStoreColor(the_environment.the_display, clr_map,&clr);
    clr.pixel |= line_plane_mask;
    XStoreColor (the_environment.the_display, clr_map, &clr);
    the_environment.clock_color = clr.pixel;

    /* get edit color */

    if(!(color_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "edit")))
      color_string = strcpy(dummy_string, "tan");
    XParseColor(the_environment.the_display, clr_map,color_string, &clr);
    clr.pixel = pixel[position++];
    XStoreColor(the_environment.the_display, clr_map,&clr);
    clr.pixel |= line_plane_mask;
    XStoreColor (the_environment.the_display, clr_map, &clr);
    the_environment.edit_color = clr.pixel;


    /* set component colors */

    color_string = strcpy(dummy_string, "tan");
    for (num_types = 0; component_types[num_types].action; ++num_types)
      ;

    for (counter = 0; counter != num_types; ++counter)
      {
	if(!(color_string = XGetDefault(the_environment.the_display, the_environment.pr_name, component_types[counter].typename)))
	  clr.green = 0x1F00 + (0x2A00 * counter);
	else
	  XParseColor(the_environment.the_display, clr_map,color_string, &clr);
	clr.pixel = pixel[position++];
	XStoreColor(the_environment.the_display, clr_map,&clr);
	clr.pixel |= line_plane_mask;
	XStoreColor (the_environment.the_display, clr_map, &clr);
	the_environment.component_color[counter] = clr.pixel;

	the_environment.component_back_gc[counter] =
	  XCreateGC(the_environment.the_display,
		    XDefaultRootWindow(the_environment.the_display),
		    0, NULL);
	XSetForeground(the_environment.the_display,
		       the_environment.component_back_gc[counter],
		       the_environment.component_color[counter]);
      }

   /* get background color */

    if(!(color_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "backgroundcolor")))
      color_string = strcpy(dummy_string, "SkyBlue");
    XParseColor(the_environment.the_display, clr_map,color_string, &clr);
    clr.pixel = pixel[position] | line_plane_mask;
    XStoreColor(the_environment.the_display, clr_map,&clr);
    the_environment.back_color = clr.pixel;
  
    /* This is the color the connecting lines will use. */  
    clr.pixel = pixel[position];
    clr.green =0;
    clr.red = 0;
    clr.blue = 0;
    XStoreColor(the_environment.the_display, clr_map,&clr);

  }
}




/* This function sets the font names to their correct values.*/

initialize_fonts()
{
  char *font_string;
  char dummy_string[90];

  if (!(font_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "infofont")))
    font_string = strcpy(dummy_string, "6x13");
  the_environment.info_font = XLoadFont(the_environment.the_display, font_string);
  the_environment.info_font_info = XQueryFont(the_environment.the_display, the_environment.info_font);


  if (!(font_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "compfont")))
    font_string = strcpy(dummy_string, "6x13");
  the_environment.comp_font = XLoadFont(the_environment.the_display, font_string);
  the_environment.comp_font_info = XQueryFont(the_environment.the_display, the_environment.comp_font);


  if (!(font_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "controlfont")))/*
    font_string = strcpy(dummy_string, "-adobe-courier-bold-o-normal--24-240-75-75-m-150-iso8859-1");*/
    font_string = strcpy(dummy_string, "9x15");
   the_environment.control_font = XLoadFont(the_environment.the_display, font_string);
  the_environment.control_font_info = XQueryFont(the_environment.the_display, the_environment.control_font);


  if (!(font_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "editfont")))
    font_string = strcpy(dummy_string, "9x15");
  the_environment.edit_font = XLoadFont(the_environment.the_display, font_string);
  the_environment.edit_font_info = XQueryFont(the_environment.the_display, the_environment.edit_font);


  if (!(font_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "textfont")))
    font_string = strcpy(dummy_string, "9x15");
  the_environment.text_font = XLoadFont(the_environment.the_display, font_string);
  the_environment.text_font_info = XQueryFont(the_environment.the_display, the_environment.text_font);


  if (!(font_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "clockfont")))
    font_string = strcpy(dummy_string, "9x15");
  the_environment.clock_font = XLoadFont(the_environment.the_display, font_string);
  the_environment.clock_font_info = XQueryFont(the_environment.the_display, the_environment.clock_font);
  

  if (!(font_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "meterfont")))
    font_string = strcpy(dummy_string, "6x10");
  the_environment.meter_font = XLoadFont(the_environment.the_display, font_string);
  the_environment.meter_font_info = XQueryFont(the_environment.the_display, the_environment.meter_font);
      
}



initialize_key_bindings()
{

  char *option_string;
  char dummy_string[40];
  
/* select */

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "select.button")))
    option_string = strcpy(dummy_string, "middle");
  user_bindings.select.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "select.key")))
    option_string = strcpy(dummy_string, "none");
  user_bindings.select.key = option_from_string(option_string);

/* move */

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "move.button")))
    option_string = strcpy(dummy_string, "right");
  user_bindings.move.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "move.key")))
    option_string = strcpy(dummy_string, "none");
  user_bindings.move.key = option_from_string(option_string);

/* resize */  

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "resize.button")))
    option_string = strcpy(dummy_string, "middle");
  user_bindings.resize.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "resize.key")))
    option_string = strcpy(dummy_string, "none");
  user_bindings.resize.key = option_from_string(option_string);

/* create */    

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "create.button")))
    option_string = strcpy(dummy_string, "right");
  user_bindings.create.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "create.key")))
    option_string = strcpy(dummy_string, "shift");
  user_bindings.create.key = option_from_string(option_string);

/* toggle connection */
  

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "connection.button")))
    option_string = strcpy(dummy_string, "middle");
  user_bindings.connection.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "connection.key")))
    option_string = strcpy(dummy_string, "shift");
  user_bindings.connection.key = option_from_string(option_string);

/* peer */


  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "peer.button")))
    option_string = strcpy(dummy_string, "left");
  user_bindings.peer.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "peer.key")))
    option_string = strcpy(dummy_string, "shift");
  user_bindings.peer.key = option_from_string(option_string);


/* raise */


  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "raise.button")))
    option_string = strcpy(dummy_string, "right");
  user_bindings.raise.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "raise.key")))
    option_string = strcpy(dummy_string, "none");
  user_bindings.raise.key = option_from_string(option_string);

/* lower */


  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "lower.button")))
    option_string = strcpy(dummy_string, "left");
  user_bindings.lower.button = option_from_string(option_string);

  if (!(option_string = XGetDefault(the_environment.the_display, the_environment.pr_name, "lower.key")))
    option_string = strcpy(dummy_string, "none");
  user_bindings.lower.key = option_from_string(option_string);



}

initialize_gcs()
{
  int i;
  XGCValues xgcv;

  for (i = 0; i < n_packet_colors; i++) 
    {


      color_gc[i] = XCreateGC(the_environment.the_display,
			      XDefaultRootWindow(the_environment.the_display),
			      0,
			      NULL);

      XSetLineAttributes(the_environment.the_display,
			 color_gc[i],
			 0,
			 LineSolid,
			 CapButt,
			 JoinMiter);

  				  
      XSetForeground(the_environment.the_display,
		     color_gc[i],
		     packet_colors[i]);

    }

  the_environment.meter_or_log_indicator_gc = 
    XCreateGC(the_environment.the_display,
	      XDefaultRootWindow(the_environment.the_display),
	      0,
	      NULL);

  XSetFunction(the_environment.the_display,
	       the_environment.meter_or_log_indicator_gc,
	       GXcopy);

  if (the_environment.monochrome == 1)
    XSetForeground(the_environment.the_display,
		   the_environment.meter_or_log_indicator_gc,
		   the_environment.fore_color);
  else
    XSetForeground(the_environment.the_display,
		   the_environment.meter_or_log_indicator_gc,
		   WhitePixel(the_environment.the_display,
			      the_environment.the_screen));


  XSetLineAttributes(the_environment.the_display,
		     the_environment.meter_or_log_indicator_gc,
		     0,
		     LineSolid,
		     CapButt,
		     JoinMiter);


  the_environment.clock_erase_gc =
    XCreateGC(the_environment.the_display,
	      XDefaultRootWindow(the_environment.the_display),
	      0, NULL);
  
  XSetSubwindowMode(the_environment.the_display,
		    the_environment.clock_erase_gc,
		    IncludeInferiors);

  XSetForeground(the_environment.the_display,
		 the_environment.clock_erase_gc,
		 the_environment.clock_color);
  
  XSetLineAttributes(the_environment.the_display,
		     the_environment.clock_erase_gc,
		     0,
		     LineSolid,
		     CapButt,
		     JoinMiter);


  XSetFunction(the_environment.the_display,
	       the_environment.clock_erase_gc,
	       GXcopy);

  the_environment.clock_draw_gc =
    XCreateGC(the_environment.the_display,
	      XDefaultRootWindow(the_environment.the_display),
	      0,
	      NULL);
  
  XSetSubwindowMode(the_environment.the_display,
		    the_environment.clock_draw_gc,
		    IncludeInferiors);

  XSetForeground(the_environment.the_display,
		 the_environment.clock_draw_gc,
		 the_environment.fore_color);
  
  XSetLineAttributes(the_environment.the_display,
		     the_environment.clock_draw_gc,
		     0,
		     LineSolid,
		     CapButt,
		     JoinMiter);

  XSetFunction(the_environment.the_display,
	       the_environment.clock_draw_gc,
	       GXcopy);

  XSetBackground(the_environment.the_display,
		 the_environment.clock_draw_gc,
		 the_environment.clock_color);

  XSetFont(the_environment.the_display,
	   the_environment.clock_draw_gc,
	   the_environment.clock_font);


  the_environment.line_gc =
    XCreateGC(the_environment.the_display,
	      XDefaultRootWindow(the_environment.the_display),
	      0,
	      NULL);
  
  XSetSubwindowMode(the_environment.the_display,
		    the_environment.line_gc,
		    IncludeInferiors);

  XSetPlaneMask(the_environment.the_display, 
		the_environment.line_gc,
		line_plane_mask);

  
  XSetForeground(the_environment.the_display,
		 the_environment.line_gc,
		 0);
      

  XSetFunction(the_environment.the_display,
	       the_environment.line_gc,
	       GXcopy);

  XSetLineAttributes(the_environment.the_display,
		     the_environment.line_gc,
		     0,
		     LineSolid,
		     CapButt,
		     JoinMiter);

  xgcv.function = GXxor;
  xgcv.foreground = the_environment.fore_color ^ the_environment.back_color;
  xgcv.subwindow_mode = IncludeInferiors;
  the_environment.xor_gc =
    XCreateGC(the_environment.the_display,
	      XDefaultRootWindow(the_environment.the_display),
	      GCFunction|GCForeground|GCSubwindowMode,
	      &xgcv);
}


option_from_string(string)
     char *string;
{

  if (strcmp(string, "none") == 0)
    return ((int) NULL);
  else if (strcmp(string, "shift") == 0)
    return (ShiftMask);
  else if (strcmp(string, "control") == 0)
    return (ControlMask);
  else if (strcmp(string, "meta") == 0)
    return(Mod1Mask);

  else if (strcmp(string, "left") == 0)
    return (LeftButton);
  else if (strcmp(string, "right") == 0)
    return (RightButton);
  else if (strcmp(string, "middle") == 0)
    return (MiddleButton);

  else 
    return ((int) NULL);


}

static int
errorHandler(display, event)
     Display *display;
     XErrorEvent *event;
{
  fprintf(stderr,
	  "An XError occured:  request code %d, error type %d\n",
	  event->request_code,
	  event->error_code);

  return (0);
}
