/* $Id: io.c,v 10.1 92/10/06 23:03:22 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#include <Xm/Xm.h>
#include "xm-io.h"
#include "xm-main_w.h"
#include "simx1.h"
#include "xm-network.h"
#include "simx.h"
#include "xm-param_w.h"
#include "xm-util.h"
#include "xm-main_w.h"
#include "xm-meters.h"

/* This file contains the following functions:

   void update_screen();                Update the clock, meters, and info windows.
   void io();                           The event dispatching loop.
   void x_reset();                      Reset the meters.

   void x_printclear();                 Clear the text window.
   void printx(char *s);                Print a string to the text window.
   int xinput(char *s, int maxlength);  Input a string from the text window.

   void set_record_flag(int doXstuff);  Start recording.
   void destroy_world();                Destroy everything.
*/

extern Widget record_button;
extern XtAppContext app;	
extern char eventfilename[];

void io()
{
  if (the_environment.single_step==1 || the_environment.single_step==2) {
     XtCallCallbacks(pause_button, XmNactivateCallback, NULL);
  }
  while (XtAppPending(app)) {
     XtAppProcessEvent(app, XtIMAll);
  }
  if (reset_components) {
     reset_components=0;
     if (network_status==NETWORK_RUNNING) { /* We don't need to stop if it is not running. */
	XtCallCallbacks(start_button, XmNactivateCallback, NULL);
     }
  }
}

/* this is the main routine. It simply calls the other routines
necessary to update the screen. */

void update_screen()
{
   update_clock();
   if (screen_update != NULL) {
      update_meters_and_info_windows();
   }
   XFlush(the_environment.the_display);
}


void update_meters_and_info_windows()
{
  COMPONENT *scomponent;
  int i;
  l_elt *le;
  /* Update Meters */
  for (le=m_list->l_head; le!=NULL; le=le->le_next) {
     PARAM *parameter;
     COMPONENT *scomponent;
     MComponent *comp;
     METER *meter;

     parameter = (PARAM *)le->le_data;
     meter=(METER *)parameter->p_my_picture;
     scomponent=(COMPONENT *)meter->scomponent;
     comp=(MComponent *)scomponent->co_picture;

     if ((parameter->p_display_type & MeterTypeMask) == TIME_HISTORY)
	{
	   update_time_history_meter(scomponent, parameter);
	}
     else  {
	if (parameter->p_flags & ChangeMask) {
	   switch(parameter->p_display_type & MeterTypeMask) {
	    case TIME_HISTORY_D:  update_time_history_d_meter(scomponent, parameter); break;
	    case DELTA: update_delta_meter(scomponent, parameter); break;
	    case HISTOGRAM: update_histogram_meter (scomponent, parameter); break;
	    default: paint_meter(scomponent, parameter, NULL, NULL); break;
	   }
	   if (!CompParamWindowOpen(comp)) 
	      parameter->p_flags &= ~ChangeMask;	   
	}	
     }
  }

  for(scomponent = (COMPONENT *) comps->l_head; scomponent; scomponent = scomponent->co_next) {
     MComponent *comp;
     unsigned num_params;
     ParameterTextfield **textfields;
  
     comp = (MComponent *) scomponent->co_picture;
    
     if (!CompParamWindowOpen(comp))
	continue;
    
     /* Update Parameters */
    
     TRACE("updating parameters.");
    
     num_params=((ParamWinData *)comp->param_window)->num_params;
     textfields=((ParamWinData *)comp->param_window)->textfields;
     for (i = 0; i < num_params; ++i) {
	ParameterTextfield *p_textf;
	PARAM *parameter;
      
	p_textf=textfields[i];
	parameter = p_textf->parameter;
	if (parameter->p_flags & ChangeMask) {
	   char *new_value;
	
	   p_textf->changed_by_user=0;
	   p_textf->new_value_entered=0;
	   parameter->p_flags &= ~ChangeMask;
	   new_value=parameter->p_make_short_text(scomponent, parameter);
	   remove_quotes(new_value);

	   XmTextFieldSetString(p_textf->textfield,new_value);
	
	   if (p_textf->current_value!=NULL) {
	      free(p_textf->current_value);
	      free(p_textf->initial_value);
	      p_textf->current_value=new_string(new_value);
	      p_textf->initial_value=new_string(new_value);
	   }
	}		
     }
  }
}

/* This routine resets all of the X stuff (meters). */

void x_reset()
{
  int counter;
  COMPONENT *scomponent;
  TH *time_history;
  PARAM *parameter;
  METER *meter;
  MComponent *comp;
  l_elt *le;

  for (le=m_list->l_head; le!=NULL; le=le->le_next) {
     parameter =  (PARAM *)le->le_data;
     meter = (METER *) parameter->p_my_picture;
     time_history = (TH *) meter->th;
     
     if (time_history != NULL)
	time_history->time = 0;
  }
  update_clock(); 
}

void xprintclear()
{
  XmTextSetString(message_w,NULL);
}

void printx(char *s) 
{
   char *curr;
   char *new;
   
   curr=XmTextGetString(message_w);
   new=(char *)sim_malloc(strlen(curr)+strlen(s)+1);
   strcpy(new,curr);
   strcat(new,s);
   XmTextSetString(message_w,new);
   XtVaSetValues(message_w, XmNvalue, new, NULL);
   XtFree(curr);
   free(new);
   
   XFlush(the_environment.the_display);
}

int input=1;
XmTextPosition base_position;

void input_text(Widget w, XtPointer unused, XmTextVerifyCallbackStruct *cbs)
{
   TRACE("input_text");
   switch(cbs->reason) {
    case XmCR_MODIFYING_TEXT_VALUE:
      if (cbs->startPos<base_position) {
	 cbs->doit=False;
      }
      break;
    case XmCR_MOVING_INSERT_CURSOR:
      if (cbs->newInsert<base_position) {
	 cbs->doit=False;
      }	
      break;
    case XmCR_ACTIVATE:
      input=1;
      break;
   }
}

int xinput(char *s, int maxlength) {
  char *str;
  int length;

  TRACE("xinput");

  base_position=XmTextGetLastPosition(message_w);
  XmTextSetInsertionPosition(message_w,base_position);

  XtAddCallback(message_w,XmNactivateCallback, input_text, NULL);
  XtAddCallback(message_w,XmNmotionVerifyCallback, input_text, NULL);
  XtAddCallback(message_w,XmNmodifyVerifyCallback, input_text, NULL);

  input=0;
  XmTextSetEditable(message_w,True);
  while(input==0) {
    XtAppProcessEvent(app,XtIMAll);
  }
  XmTextSetEditable(message_w,False);

  XtRemoveCallback(message_w,XmNactivateCallback, input_text, NULL);
  XtRemoveCallback(message_w,XmNmotionVerifyCallback, input_text, NULL);
  XtRemoveCallback(message_w,XmNmodifyVerifyCallback, input_text, NULL);

  str=XmTextGetString(message_w);

  strncpy(s,str+(int)base_position,maxlength);
  length=strlen(s);
  s[length] = '\0';
  return(length);
}

void set_record_flag(doXstuff)
int doXstuff;
{
   record_flag = 1;
   if ((record_file = fopen(eventfilename, "a")) == NULL) {
      record_flag = 0;
      if (doXstuff)
	 SetLabelString(record_button, "Record");	
      return;
   }
   if (doXstuff)
      SetLabelString(record_button, "Stop Record");	
}

/* This routine destroys everything so that a new congiguration
can be loaded. */

extern void RecursiveDestroyComponent(MComponent *comp);
extern MComponentList selected;

void destroy_world()
{
  COMPONENT *scomponent;
  COMPONENT *dummy_variable;

  /* Clear all default component names. */
  ClearDefaultNumbers();
  ClearGlobalHideSettings();
  CloseHideComponentsBox();

  /* Clear the global hide settings. */
  the_environment.hide_settings=0;
  the_environment.hide_meters=0;

  CloseCreateComponentBox();
  l_traverse(network_components,RecursiveDestroyComponent);
  lq_clear(selected);

  free((char *)comps);
  comps=NULL;

  ev_reset();
  pk_free_all();

/**********************
  do peer staff
  written at UMCP
************************/
  peer_destroy();
  peer_create();

}






