/* $Id: main_w.c,v 10.1 92/10/06 23:03:25 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <Xm/MessageB.h>
#include <Xm/SeparatoG.h>
#include <Xm/DrawingA.h>

#include <X11/StringDefs.h>
#include <Xm/TextF.h>

#include "xm-util.h"
#include "xm-mfile.h"
#include "xm-edit.h"
#include "xm-view.h"
#include "xm-options.h"
#include "xm-comp_trans.h"
#include "comptypes.h"
#include "xm-info_w.h"
#include "simx.h"
#include "xm-meters.h"
#include "xm-main_w.h"
#include "xm-lines.h"

extern XtAppContext app;	
extern SegmentList *network_segmentlist;

/* This file contains function to build the main window.  Also included are callback functions for the start and
   pause buttons, functions which handle resizing the network, updating the clock, and handling expose events in
   the network window.  */

/*====================================================== Global Variables ==================================================================*/
Widget scroll_w;
Widget meter_w;
Widget meter_w_shell;
Widget main_w;        /* Toplevel FormWidget, child of shell */
Widget main_w_shell;  /* Toplevel application shell */
Widget message_w;/* Message area at the bottom of the main window. */
Widget network_w;
Widget clock_w;

int reset_components=0;  /* This is set whenever a component is killed. If reset_components is TRUE, all components are reset
			    before returning to the main loop. */

void redraw(Widget drawing_a, XtPointer client_data, XmDrawingAreaCallbackStruct *cbs);
void resize_network_w_event_handler(Widget w, XtPointer data, XConfigureEvent *event);
void redraw_lines_event_handler(Widget network_w, XtPointer client_data, XExposeEvent *event);

void ResizeNetwork(int new_width, int new_height);

/*************************************************************************************************************************/
Widget start_button;
Widget pause_button;
int network_status=NETWORK_STOPPED;

void start_button_cb(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs);
void pause_button_cb(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs);


/********************************************************************************************************************************/
void pause_button_cb(w,data,cbs)
     Widget w;
     XtPointer data;
     XmPushButtonCallbackStruct *cbs;
{
  TRACE("pause_button_cb");
/******************** Don't Process events before comps has been initialized. ****************/

  switch(network_status) {
  case NETWORK_RUNNING: /* Pause all components */
    network_status=NETWORK_PAUSED;
    SetLabelString(pause_button,"Continue");

    for (;network_status==NETWORK_PAUSED;) {
       while (XtAppPending(app)) {
	  XtAppProcessEvent(app, XtIMAll);
       }
       update_screen();
    }

    break;
  case NETWORK_PAUSED:  /* Continue all components */ 
    network_status=NETWORK_RUNNING;
    SetLabelString(pause_button,"Pause");
    break;
  case NETWORK_STOPPED: /* Do nothing */
    break;
  default: WARNING("Unknown network status.");
  }
}


/******************************************************************************************************************************/
void start_button_cb(w,data,cbs)
     Widget w;
     XtPointer data;
     XmPushButtonCallbackStruct *cbs;
{
  TRACE("start_button_cb");

/******************** Don't Process events before comps has been initialized. ****************/
  switch(network_status) {
  case NETWORK_RUNNING: /* Stop all components */
    network_status=NETWORK_STOPPED;
    SetLabelString(start_button,"Start");

    sim_stop(comps);

    /* Process events until the user decides to restart the network. */
    for (;network_status==NETWORK_STOPPED;) {
       while (XtAppPending(app)) {
	  XtAppProcessEvent(app, XtIMAll);
       }
       update_screen();
    }
    
    break;
  case NETWORK_PAUSED:  /* Stop all components */ 
    network_status=NETWORK_STOPPED;
    SetLabelString(pause_button,"Pause");
    SetLabelString(start_button,"Start");

    sim_stop(comps);

    /* Process events until the user decides to restart the network. */
    for (;network_status==NETWORK_STOPPED;) {
       while (XtAppPending(app)) {
	  XtAppProcessEvent(app, XtIMAll);
       }
       update_screen();
    }

    break;
  case NETWORK_STOPPED: /* Start all components */
    network_status=NETWORK_RUNNING;

    the_environment.never_ran = FALSE;
    sim_reset(comps);
    sim_start(comps);

    reset_components=0; /* Set this after sim_reset, because the sim_reset routine may kill components,
                           which would set reset_components back to 1. */

    SetLabelString(start_button,"Stop");
    break;
  default: WARNING("Unknown network status.");
  }
}

/***************************************************************************************************************************/
void BuildMainWindow() {
   Widget menubar, header, pause_start_rowcolumn, meter_w_label, sep, super_header, msecs_label, clock_form;
   Dimension width, height;

   XmString str;
   main_w = XtVaCreateWidget("main_w",xmFormWidgetClass, main_w_shell,NULL);
    

   super_header = XtVaCreateWidget("super_header",xmFormWidgetClass, main_w,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   NULL);

   header = XtVaCreateWidget("header",xmFormWidgetClass, super_header, NULL);

   menubar = XtVaCreateWidget("menubar", xmRowColumnWidgetClass, header,
			      XmNtopAttachment, XmATTACH_FORM,
			      XmNleftAttachment, XmATTACH_FORM,
			      XmNorientation, XmHORIZONTAL,
			      XmNbottomAttachment, XmATTACH_FORM,
			      XmNrowColumnType, XmMENU_BAR,
			      NULL);
   BuildPulldownMenu(menubar, "File", 'F', file_items);
   BuildPulldownMenu(menubar, "Edit", 'E', edit_items);
   BuildPulldownMenu(menubar, "View", 'V', view_items);
   BuildPulldownMenu(menubar, "Options", 'O', options_items);
   XtManageChild(menubar);

   
   pause_button=XtVaCreateManagedWidget("pause_button",xmPushButtonWidgetClass, header,					
					XmNleftAttachment, XmATTACH_WIDGET,
					XmNleftWidget, menubar,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					NULL);

   XtAddCallback(pause_button,XmNactivateCallback,pause_button_cb,NULL);

   start_button=XtVaCreateManagedWidget("start_button",xmPushButtonWidgetClass, header,
					XmNleftAttachment, XmATTACH_WIDGET,
					XmNleftWidget, pause_button,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					NULL);

   XtAddCallback(start_button,XmNactivateCallback,start_button_cb,NULL);

   XtManageChild(header);

   clock_form=XtVaCreateWidget("clock_form", xmFormWidgetClass, super_header,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNtopAttachment, XmATTACH_FORM,
			       XmNbottomAttachment, XmATTACH_FORM,
			       NULL);

   clock_w=XtVaCreateManagedWidget("clock",xmLabelWidgetClass, clock_form,				 
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);

   msecs_label=XtVaCreateManagedWidget("msecs_label", xmLabelWidgetClass, clock_form,
				       XmNleftAttachment, XmATTACH_WIDGET, 
				       XmNleftWidget, clock_w,
				       XmNrightAttachment, XmATTACH_FORM,
				       XmNtopAttachment, XmATTACH_FORM,
				       XmNbottomAttachment, XmATTACH_FORM,
				       NULL);

   XtManageChild(clock_form);
   XtManageChild(super_header);

   message_w=XtVaCreateManagedWidget("message_w", xmTextWidgetClass, main_w,
				     XmNeditable, False,
				     NULL);

   scroll_w=XtVaCreateManagedWidget("scroll_w", xmScrolledWindowWidgetClass, main_w,
				    XmNtopWidget, super_header,
				    XmNbottomWidget, message_w,
				    XmNscrollingPolicy,  XmAUTOMATIC,
				    NULL);

   network_w = XtVaCreateManagedWidget("network_w",xmBulletinBoardWidgetClass, scroll_w,
				       XmNwidth, the_environment.network_width,
				       XmNheight, the_environment.network_height,				       
				       XmNtranslations, the_environment.network_w_translations,
				       XmNbackground, the_environment.back_color,
				       NULL);

   XtAddEventHandler(network_w, StructureNotifyMask, False, resize_network_w_event_handler, NULL);
   XtAddEventHandler(network_w, ExposureMask, False, redraw_lines_event_handler, NULL);

   XtVaSetValues(scroll_w,
		 XmNworkWindow, network_w,
		 NULL);

   meter_w_shell = XtVaAppCreateShell("MaRSMeterWindow", "MaRSMeterWindow", topLevelShellWidgetClass, the_environment.the_display,
				      NULL);

   meter_w = XtVaCreateManagedWidget("meter_w", xmBulletinBoardWidgetClass, meter_w_shell, NULL);

   if (the_environment.meter_window_open) {      
      XtRealizeWidget(meter_w_shell);	
   }

   /* Build the create compoonent's box. */
   create_component_box=BuildCreateComponentsBox(main_w);
   XtVaSetValues(create_component_box,
		 XmNtopWidget, super_header,
		 NULL);

   XtManageChild(main_w);
}

/********************************************************************************************************************************/
void resize_network_w_event_handler(Widget w, XtPointer data, XConfigureEvent *event) {
   if (event->type!=ConfigureNotify)
      return;
   if (event->width!=the_environment.network_width || event->height!=the_environment.network_height) {
      the_environment.network_width=event->width;
      the_environment.network_height=event->height;

      the_environment.x_center = the_environment.network_width /2;
      the_environment.y_center = the_environment.network_height /2;
   }
}   
   
/********************************************************************************************************************************************/
void ResizeNetwork(int new_width, int new_height) {/*  This is called when the user resizes the network. */
   XtVaSetValues(network_w,
		 XmNwidth,(Dimension)new_width,
		 XmNheight,(Dimension)new_height,
		 NULL);
   
   the_environment.network_width=new_width;
   the_environment.network_height=new_height;

   the_environment.x_center = the_environment.network_width /2;
   the_environment.y_center = the_environment.network_height /2;
}	

/********************************************************************************************************************************************/
void update_clock() {
   static tick_t oldtime=0;
   register tick_t newtime=TICKS_TO_USECS(ev_now());
   char time_string[40];
   char icon_string[50];
   XmString str;

   if (oldtime!=newtime) {
      oldtime=newtime;      
	 
      sprintf(time_string, "%.3f", (double)newtime / 1000.0);

      str=XmStringCreateSimple(time_string);
      XtVaSetValues(clock_w,
		    XmNlabelString, str,
		    NULL);
      XmStringFree(str);

      sprintf(icon_string, "MaRS: ");
      strcat(icon_string, time_string);

      XtVaSetValues(main_w_shell,
		    XmNiconName, icon_string,
		    NULL);
   }
}

/********************************************************************************************************************************************/
void redraw_lines_event_handler(Widget network_w, XtPointer client_data, XExposeEvent *xexpose) {
   static Region r=NULL;
   XRectangle rect;

   if (r==NULL) {
      r=XCreateRegion();
   }
   if (xexpose->count==0) {
      rect.x=xexpose->x;
      rect.y=xexpose->y;
      rect.width=xexpose->width;
      rect.height=xexpose->height;
      XUnionRectWithRegion(&rect, r, r);
/*      XClipBox(r,&rect);
      XClearArea(the_environment.the_display, XtWindow(network_w), rect.x, rect.y, rect.width, rect.height, False);*/
      XSetRegion(the_environment.the_display, the_environment.redraw_gc, r);
      draw_segments(network_segmentlist, the_environment.the_display, XtWindow(network_w), the_environment.redraw_gc);
      XDestroyRegion(r);
      r=XCreateRegion();
   }
   else {
      rect.x=xexpose->x;
      rect.y=xexpose->y;
      rect.width=xexpose->width;
      rect.height=xexpose->height;
      XUnionRectWithRegion(&rect, r, r);
   }
}


