/* $Id: options.c,v 10.1 92/10/06 23:03:34 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science
 *          University of Maryland at College Park.
 */
#include <Xm/ToggleBG.h>
#include <Xm/PushBG.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/CascadeBG.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>

#include "xm-options.h"
#include "xm-main_w.h"
#include "xm-network.h"
#include "xm-util.h"
#include "simx.h"

/* This file contains routines associated with the options submenu. */

#define CONTINUOUS_BUTTON 0
#define EVENT_STEP_BUTTON 1
#define TIME_STEP_BUTTON  2

#define O_DELAY 1
#define O_OPERATING_MODE 2
#define O_RESIZE 3

void opmodes_cb(Widget widget,int item,XmToggleButtonCallbackStruct *cbs);
void options_cb(Widget widget,int item);
void delay_cb(Widget widget, int item);
void resize_dialog_cb(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs);

void initialize_continuous_button(Widget w);
void initialize_event_step_button(Widget w);
void initialize_time_step_button(Widget w);

void initialize_delay_button(Widget w);

Widget continuous_button;
Widget event_step_button;
Widget time_step_button;
Widget delay_button;

MenuItem opmodes_radiobox[] = {
  {"Continuous", &xmToggleButtonGadgetClass, NULL, NULL, NULL, XmNvalueChangedCallback, opmodes_cb, (XtPointer)CONTINUOUS_BUTTON, (MenuItem*)NULL, initialize_continuous_button},
  {"Event Step", &xmToggleButtonGadgetClass, NULL, NULL ,NULL, XmNvalueChangedCallback, opmodes_cb, (XtPointer)EVENT_STEP_BUTTON, (MenuItem*)NULL, initialize_event_step_button},
  {"Time Step", &xmToggleButtonGadgetClass, NULL, NULL, NULL, XmNvalueChangedCallback, opmodes_cb, (XtPointer)TIME_STEP_BUTTON, (MenuItem*)NULL, initialize_time_step_button},
  NULL
};

MenuItem options_items[] = {
  {"Delay", &xmPushButtonGadgetClass, NULL, NULL, NULL, XmNactivateCallback, delay_cb, (XtPointer)O_DELAY, (MenuItem *)NULL, initialize_delay_button},
  {"", &xmSeparatorGadgetClass, NULL, NULL, NULL, NULL, NULL, NULL, (MenuItem *)NULL, NULL},
  {"Operating Mode", &xmCascadeButtonGadgetClass, NULL, NULL, NULL, XmNactivateCallback, NULL, (XtPointer)O_OPERATING_MODE,opmodes_radiobox, NULL},
  {"Resize Network", &xmPushButtonGadgetClass, NULL, NULL, NULL, XmNactivateCallback, resize_dialog_cb, (XtPointer)O_RESIZE, (MenuItem *)NULL, NULL},
  NULL
};

void initialize_delay_button(Widget w) {
   int value;
   char buf[20];

   delay_button=w;
   value = ev_get_delay();   
   sprintf(buf,"Delay: %dus",value);
   SetLabelString(w,buf);
}

void initialize_continuous_button(Widget w) {
   XtVaSetValues(XtParent(w),XmNradioBehavior,True,NULL);
   continuous_button=w;
   if (the_environment.single_step==0)
      XtVaSetValues(w,
		    XmNset, True,
		    XmNindicatorType, XmONE_OF_MANY,
		    NULL);
   else
      XtVaSetValues(w,
		    XmNset, False,
		    XmNindicatorType, XmONE_OF_MANY,
		    NULL);
}

void initialize_event_step_button(Widget w) {
   event_step_button=w;
   if (the_environment.single_step==1)
      XtVaSetValues(w,
		    XmNset, True,
		    XmNindicatorType, XmONE_OF_MANY,
		    NULL);
   else
      XtVaSetValues(w,
		    XmNset, False,
		    XmNindicatorType, XmONE_OF_MANY,
		    NULL);
}

void initialize_time_step_button(Widget w) {
   time_step_button=w;
   if (the_environment.single_step==2)
      XtVaSetValues(w,
		    XmNset, True,
		    XmNindicatorType, XmONE_OF_MANY,
		    NULL);
   else
      XtVaSetValues(w,
		    XmNset, False,
		    XmNindicatorType, XmONE_OF_MANY,
		    NULL);
}

/*************************************************************************************************************************/ 
void opmodes_cb(Widget widget,int item,XmToggleButtonCallbackStruct *cbs)
{
   if (cbs->set) {
      switch(item) {
       case CONTINUOUS_BUTTON:
	 the_environment.single_step = 0;
	 break;
       case EVENT_STEP_BUTTON:
	 the_environment.single_step = 1;
	 break;
       case TIME_STEP_BUTTON:
	 the_environment.single_step = 2;
	 break;
      }
   }
}

/*************************************************************************************************************************/
void SetOperatingModeButtons(int mode) { /* This should be called whenever the operating mode is changed by something other 
					    than the user. In comps/stopper.c, for example.*/
   switch(mode) {
    case EVENT_STEP_MODE:
      XtVaSetValues(event_step_button, XmNset, True, NULL);
      XtVaSetValues(time_step_button, XmNset, False, NULL);
      XtVaSetValues(continuous_button, XmNset, False, NULL);
      break;
    case TIME_STEP_MODE:
      XtVaSetValues(event_step_button, XmNset, False, NULL);
      XtVaSetValues(time_step_button, XmNset, True, NULL);
      XtVaSetValues(continuous_button, XmNset, False, NULL);
      break;
    case CONTINUOUS_MODE:
      XtVaSetValues(event_step_button, XmNset, False, NULL);
      XtVaSetValues(time_step_button, XmNset, False, NULL);
      XtVaSetValues(continuous_button, XmNset, True, NULL);
      break;
   }
}

/*************************************************************************************************************************/
void delay_cb(Widget widget, int item)
{
   int value;
   int new_value;
   char dummy_string[20];
 
   xprintclear();
   printx("Please enter delay between events (in microseconds)[");
   value = ev_get_delay();
   sprintf(dummy_string, "%d", value);
   printx(dummy_string);
   printx("] : ");
   if (xinput(dummy_string, 20) == 0)
      {
	 xprintclear();
	 return;
      }
   xprintclear();
   new_value=atoi(dummy_string);
   ev_set_delay((tick_t) new_value);

   sprintf(dummy_string,"Delay: %dus",new_value);
   SetLabelString(delay_button,dummy_string);
}


/***************************************************************************************************************************/
void resize_minimize(Widget w, Widget *textfields, XmAnyCallbackStruct *cbs);
void resize_check_input(Widget w, int *max_value, XmAnyCallbackStruct *cbs);
void resize_cancel(Widget w, XtPointer data, XmAnyCallbackStruct *cbs);
void resize_ok(Widget w, Widget *textfields, XmAnyCallbackStruct *cbs);
void get_max_coords(MComponent *comp);


ActionAreaItem resize_action[]={
  { "Ok", resize_ok, NULL, NULL},
  { "Cancel", resize_cancel, NULL, NULL},
};

int resize_max_w,resize_max_h;
int max_x_coord,max_y_coord;

Widget resize_dialog=NULL;

/***************************************************************************************************************************/
void resize_dialog_cb(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
   static Widget textfields[2];
   Widget width_input, height_input, action_area, sep, minimize_button, label;
   char buf[10];
   int i;

   if (!resize_dialog) {
     resize_dialog=XmCreateFormDialog(main_w,"resize_dialog",NULL,0);

     /* label */
     label=XtVaCreateManagedWidget("title", xmLabelWidgetClass, resize_dialog, NULL);
     
     sep=CreateSeparator(resize_dialog,XmDOUBLE_LINE,label);

     /* Width Textfield */
     sprintf(buf,"%d",the_environment.network_width);
     width_input=CreateTextInput(resize_dialog,"width",buf,&textfields[0]);
     XtAddCallback(textfields[0],XmNactivateCallback,resize_check_input,&resize_max_w);
     XtVaSetValues(width_input,
		   XmNleftAttachment, XmATTACH_FORM,
		   XmNrightAttachment, XmATTACH_FORM,
		   XmNtopAttachment, XmATTACH_WIDGET,
		   XmNtopWidget, sep,
		   NULL);
      
   /* Height Textfield */
      sprintf(buf,"%d",the_environment.network_height);
      height_input=CreateTextInput(resize_dialog,"height",buf,&textfields[1]);
      XtAddCallback(textfields[1],XmNactivateCallback,resize_check_input,&resize_max_h);
      XtVaSetValues(height_input,
		    XmNleftAttachment, XmATTACH_FORM,
		    XmNrightAttachment, XmATTACH_FORM,
		    XmNtopAttachment, XmATTACH_WIDGET,
		    XmNtopWidget, width_input,
		    NULL);

   /* Minimize Button */
      minimize_button=XtVaCreateManagedWidget("minimize_button", xmPushButtonWidgetClass, resize_dialog, NULL);
      XtAddCallback(minimize_button, XmNactivateCallback, resize_minimize, textfields);
      XtVaSetValues(minimize_button,
		    XmNleftAttachment, XmATTACH_FORM,
		    XmNrightAttachment, XmATTACH_FORM,
		    XmNtopAttachment, XmATTACH_WIDGET,
		    XmNtopWidget, height_input,
		    NULL);

      sep=CreateSeparator(resize_dialog,XmSINGLE_LINE,minimize_button);

   /* Action Area */
      for (i=0;i<XtNumber(resize_action);i++) resize_action[i].data=textfields;
      action_area=CreateActionArea(resize_dialog, resize_action, XtNumber(resize_action),0);
      XtVaSetValues(action_area,
		    XmNtopAttachment, XmATTACH_WIDGET,
		    XmNtopWidget, sep,
		    XmNleftAttachment, XmATTACH_FORM,
		    XmNrightAttachment, XmATTACH_FORM,
		    XmNbottomAttachment, XmATTACH_FORM,
		    NULL);
   }
   else {
      char buf[10];

      sprintf(buf,"%d",the_environment.network_width);
      XmTextFieldSetString(textfields[0],buf);
      sprintf(buf,"%d",the_environment.network_height);
      XmTextFieldSetString(textfields[1],buf);
   }

   GetMinimumNetworkSize(&resize_max_w, &resize_max_h);

   XtManageChild(resize_dialog); 
   XRaiseWindow(the_environment.the_display, XtWindow(XtParent(resize_dialog)));
}    

/***************************************************************************************************************************/
void GetMinimumNetworkSize(int *width_return, int *height_return) {
   max_x_coord=0;
   max_y_coord=0;

   TraverseNetwork(PRE_ORDER,get_max_coords);
	
   *width_return=max_x_coord+1;
   *height_return=max_y_coord+1;
}

/***************************************************************************************************************************/
void get_max_coords(MComponent *comp) {
  Dimension w,h;
  
  XtVaGetValues(comp->icon,XmNwidth, &w, XmNheight, &h, NULL);
  max_x_coord=max(max_x_coord,comp->x+w/2);
  max_y_coord=max(max_y_coord,comp->y+h/2);
}

/***************************************************************************************************************************/
/* The callback routine for the minimize button in the resize network dialog. */

void resize_minimize(Widget w, Widget *textfields, XmAnyCallbackStruct *cbs)
{
   char buf[10];

   sprintf(buf,"%d",resize_max_w);
   XmTextFieldSetString(textfields[0],buf);
   sprintf(buf,"%d",resize_max_h);
   XmTextFieldSetString(textfields[1],buf);
}


/***************************************************************************************************************************/
/* The callback routine called when the user presses enter in one of the textfields.  It checks that the width or height is
   not greater than the maximum value.  If it is, the textfield is set to the maximum value. */

void resize_check_input(Widget w, int *max_value, XmAnyCallbackStruct *cbs)
{
  char buf[10];
  char *str;
  int value;

  str=XmTextFieldGetString(w);
  value=atoi(str);
  XtFree(str);
  if (value<*max_value) {
    sprintf(buf,"%d",*max_value);
    XmTextFieldSetString(w,buf);
  }
}

/***************************************************************************************************************************/
/* The callback routine for the cancel button in the resize network dialog. */

void resize_cancel(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
   XtUnmanageChild(resize_dialog);
}

/***************************************************************************************************************************/
/* The callback routine for the ok button in the resize network dialog. */

void resize_ok(Widget w, Widget *textfields, XmAnyCallbackStruct *cbs)
{
  char *str;
  int width,height;
  
  /* Get new width */
  str=XmTextFieldGetString(textfields[0]);
  width=atoi(str);
  XtFree(str);
  if (width<resize_max_w) {
    width=resize_max_w;
  }
  
  /* Get new height */
  str=XmTextFieldGetString(textfields[1]);
  height=atoi(str);
  XtFree(str);
  if (height<resize_max_h) {
    height=resize_max_h;
  }

  if (width!=the_environment.network_width || height!=the_environment.network_height) { /* Something has changed. */
    ResizeNetwork(width, height);
  }
  
  XtUnmanageChild(resize_dialog);
}





