/* $Id: util.c,v 10.1 92/10/06 23:03:38 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#include <Xm/Xm.h>
#include <Xm/CascadeBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/Label.h>
#include "xm-util.h"
#include "simx.h"
#include "comptypes.h"

/* This file contains miscellaneous utility routines that don't belong anywhere else. */

/********************************************************************************************************************************************/
/* This is set on the popupCallback list of dialog shell widgets to set their position just before they pop up. */

void SetShellPosition(Widget w, CoordinatePair *pos) {
   XtVaSetValues(w, XmNx, pos->x, XmNy, pos->y, NULL);
}

/********************************************************************************************************************************************/
/* Translate (w1x,w1y) in widget w1 to the corresponding position in widget w2 (Assuming the widgets overlap). */

void WWTranslateCoords(Widget w1,Widget w2,Position w1x,Position w1y,Position *w2x,Position *w2y) {

  Position r1x,r1y,r2x,r2y;

  XtTranslateCoords(w1,w1x,w1y,&r1x,&r1y);
  XtTranslateCoords(w2,(Position)0,(Position)0,&r2x,&r2y);
  *w2x=(Position)(r1x-r2x);
  *w2y=(Position)(r1y-r2y);
}


/* Translate root-relative coordinates to widget relative-coordinates. */

void RWTranslateCoords(Position x, Position y, Widget w, Position *wx, Position *wy) {
  Position rx,ry;

  XtTranslateCoords(w,(Position)0,(Position)0,&rx,&ry);
  *wx=(Position)x-rx;
  *wy=(Position)y-ry;
}   
/********************************************************************************************************************************************/
int which_string(String key, String *strings, int nstrings) {
  int i;
  for (i=0;i<nstrings;i++) {
    if (0==strcmp(key,strings[i])) return(i);
  }
  return(-1);
}


/**************************************************************************************************************************************/
/* BuildPulldownMenu() and CreateActionArea() are modified versions of routines copied from the example programs listed in the
   following publication:

   The Definitive Guides to the X Window System: Volume 6, Motif Programming Manual by Dan Heller. O'Reilly & Associates, Inc. 1991.


   The following copyright notice applies only to the BuildPulldownMenu() and CreateActionArea() routines:    */

/* Written by Dan Heller.  Copyright 1991, O'Reilly && Associates.
 * This program is freely distributable without licensing fees and
 * is provided without guarantee or warrantee expressed or implied.
 * This program is -not- in the public domain.
 */

/* Pulldown menus are built from cascade buttons, so this function
 * also includes pullright menus.  Create the menu, the cascade button
 * that owns the menu, and then the submenu items.
 */

Widget BuildPulldownMenu(parent, menu_title, menu_mnemonic, items)
Widget parent;
char *menu_title, menu_mnemonic;
MenuItem *items;
{
  Widget PullDown, cascade, widget;
  int i;
  XmString str;
  
  PullDown = XmCreatePulldownMenu(parent, "_pulldown", NULL, 0);
  
  str = XmStringCreateSimple(menu_title);
  cascade = XtVaCreateManagedWidget(menu_title,
				    xmCascadeButtonGadgetClass, parent,
				    XmNsubMenuId,   PullDown,
				    XmNlabelString, str,
				    XmNmnemonic,    menu_mnemonic,
				    NULL);
  XmStringFree(str);
  
  /* Now add the menu items */
  for (i = 0; items[i].label != NULL; i++) {
    /* If subitems exist, create the pull-right menu by calling this
     * function recursively.  Since the function returns a cascade
     * button, the widget returned is used..
     */
    if (items[i].subitems)
      widget = BuildPulldownMenu(PullDown,items[i].label, items[i].mnemonic, items[i].subitems);
    else {
       widget = XtVaCreateWidget(items[i].label,*items[i].class, PullDown,NULL);
       if (items[i].creation_function)
	  items[i].creation_function(widget);
       XtManageChild(widget);
    }

    /* Whether the item is a real item or a cascade button with a
     * menu, it can still have a mnemonic.
     */
    if (items[i].mnemonic)
      XtVaSetValues(widget, XmNmnemonic, items[i].mnemonic, NULL);
    /* any item can have an accelerator, except cascade menus. But,
     * we don't worry about that; we know better in our declarations.
     */
    if (items[i].accelerator) {
      str = XmStringCreateSimple(items[i].accel_text);
      XtVaSetValues(widget, XmNaccelerator, items[i].accelerator,
		    XmNacceleratorText, str,
		    NULL);
      XmStringFree(str);
    }
    /* Add callback if there is one.
     */
    if (items[i].callback) {
      XtAddCallback(widget, items[i].callback_list, items[i].callback, items[i].callback_data);
    }
  }
  return cascade;
}

/************************************************************************************************************************************************/
/* This creates an action area in a dialog widget, which is simply a set of push buttons, usually located at the bottom
   of the dialog. */

#define TIGHTNESS 20

Widget CreateActionArea(parent, actions, num_actions, default_button)
     Widget parent;
     ActionAreaItem *actions;
     int num_actions;
     int default_button;
{
  Widget action_area, widget;
  int i;
  Pixel bg;
  
  XtVaGetValues(parent, XmNbackground, &bg, NULL);
  action_area = XtVaCreateWidget("action_area", xmFormWidgetClass, parent,
				 XmNbackground, bg,
				 XmNfractionBase, TIGHTNESS*num_actions - 1,
				 NULL);
  
  for (i = 0; i < num_actions; i++) {
    widget = XtVaCreateManagedWidget(actions[i].label, xmPushButtonGadgetClass, action_area,
				     XmNleftAttachment,       i? XmATTACH_POSITION : XmATTACH_FORM,
				     XmNleftPosition,         TIGHTNESS*i,
				     XmNtopAttachment,        XmATTACH_FORM,
				     XmNbottomAttachment,     XmATTACH_FORM,
				     XmNrightAttachment,      (i != num_actions-1)? XmATTACH_POSITION : XmATTACH_FORM,
				     XmNrightPosition,        TIGHTNESS*(i + 1) - 1,
				     XmNshowAsDefault,        (i == default_button)? True : False,
				     XmNdefaultButtonShadowThickness, 1,
				     NULL);
    if (actions[i].callback)
       XtAddCallback(widget, XmNactivateCallback, actions[i].callback, actions[i].data);

    if (actions[i].creation_function) 
       actions[i].creation_function(widget, actions[i].data);
 }
  
  XtManageChild(action_area);
  
  return action_area;
}

/**********************************************************************************************************************************************/
/* This creates a label widget and a textfield widget as children of a row column and returns the row column.
   The label contains the string 'prompt'.  The textfield contains the string 'initial_value'.
   The textfield widget id is returned in the last argument. */

Widget CreateTextInput(Widget parent, String prompt, String initial_value, Widget *textfield)
{
  Widget form,label;
  XmString str;
  Pixel bg;
  
  XtVaGetValues(parent, XmNbackground, &bg, NULL);
  form=XtVaCreateWidget("text_input_form",xmFormWidgetClass,parent,
			XmNbackground, bg,
			NULL);
  
  str=XmStringCreateSimple(prompt);
  label=XtVaCreateManagedWidget("label",xmLabelWidgetClass,form,
				XmNbackground, bg,
				XmNlabelString, str,
				XmNleftAttachment, XmATTACH_FORM,
				XmNtopAttachment, XmATTACH_FORM,
				XmNbottomAttachment, XmATTACH_FORM,
				NULL);
  XmStringFree(str);
  
  *textfield=XtVaCreateManagedWidget("textfield",xmTextFieldWidgetClass,form,
				     XmNbackground, bg,
				     XmNvalue, initial_value,
				     XmNrightAttachment, XmATTACH_FORM,
				     XmNtopAttachment, XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_FORM,
				     XmNleftAttachment, XmATTACH_WIDGET,
				     XmNleftWidget, label,
				     NULL);
    
  XtManageChild(form);
  return(form);
}

/***********************************************************************************************************************************************/
char *GetTypeName(int type) { /* Return the component's type name given it's type number. */
   static char name[40];

   if (type==TYPE_GROUP) {
      strcpy(name, "GROUP");
      return(name);
   }
   if (type==TYPE_METER) {
      strcpy(name, "METER");
      return(name);
   }
   strcpy(name,component_types[type].typename);
   return(name);
}

/***********************************************************************************************************************************************/
int GetTypeNumber(char *type_name) { /* Return the component's type number given it's type name. */
   int i;
   if (!strcmp(type_name,"GROUP"))
      return(TYPE_GROUP);
   if (!strcmp(type_name,"METER"))
      return(TYPE_METER);

   for (i = 0; component_types[i].action; i++)
      if (!strcmp(component_types[i].typename,type_name))
	 return(i);
   
   /* We should never get to here. */
   WARNING("GetTypeName could not identify the type name.");
   return(0);
}
	  
/***********************************************************************************************************************************************/
typedef struct {
   char *name;
   int number;
} DefaultNumber;

static DefaultNumber *default_numbers=NULL;
static int num_default_numbers=0;

/***********************************************************************************************************************************************/
void ClearDefaultNumbers() {
   free(default_numbers);
   num_default_numbers=0;
}

/***********************************************************************************************************************************************/
void SetDefaultNumber(char *type_name, int number) {
   int i;
   if (num_default_numbers==0) {
      default_numbers=(DefaultNumber *)sim_calloc(1,sizeof(DefaultNumber));
      num_default_numbers=1;
      default_numbers[0].name=new_string(type_name);
      default_numbers[0].number=number;
      return;
   }
   for(i=0;i<num_default_numbers;i++) {
      if (!strcmp(default_numbers[i].name,type_name)) {
	 default_numbers[i].number=number;
	 return;
      }      
   }
   /* Else no default found, add a new one. */
   default_numbers=(DefaultNumber *)sim_realloc((char *)default_numbers, (num_default_numbers+1)*sizeof(DefaultNumber));
   default_numbers[num_default_numbers].name=new_string(type_name);
   default_numbers[num_default_numbers].number=number;
   num_default_numbers++;
}

/***********************************************************************************************************************************************/
char *GetNextDefaultName(char *type_name) {
   int i;
   static char name[50];
   for(i=0;i<num_default_numbers;i++) {
      if (!strcmp(default_numbers[i].name,type_name)) {
	 sprintf(name, "%s %d", type_name, default_numbers[i].number);
	 default_numbers[i].number+=1;
	 return(name);
      }
   }
   /* no default found, add a new one. */
   
   SetDefaultNumber(type_name, 1);
   return(GetNextDefaultName(type_name));
}


/***********************************************************************************************************************************************/
char *PeekNextDefaultName(char *type_name) { /* This returns the next default name without incrementing the value. */
   int i;
   static char name[50];
   for(i=0;i<num_default_numbers;i++) {
      if (!strcmp(default_numbers[i].name,type_name)) {
	 sprintf(name, "%s %d", type_name, default_numbers[i].number);
	 return(name);
      }
   }

   sprintf(name, "%s %d", type_name, 1);
   return(name);
}











