/* $Id: view.c,v 10.1 92/10/06 23:03:39 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#include "xm-network.h"
#include <Xm/Xm.h>
#include <Xm/ToggleBG.h>
#include <Xm/PushBG.h>
#include <Xm/Form.h>
#include <Xm/SeparatoG.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Label.h>
#include <X11/Shell.h>

#include "xm-view.h"
#include "xm-util.h"
#include "xm-network.h"
#include "comptypes.h"
#include "xm-main_w.h"
#include "xm-comp_trans.h"
#include "xm-info_w.h"
#include "xm-param_w.h"
#include "xm-meters.h"

/* This file contains functions associated with the view submenu. */

/* VIEW menu */
#define V_UPDATE_SCREEN 1
#define V_METER_WINDOW 2
#define V_HIDE 3
#define V_UNHIDE 4
#define V_CLOSE_ALL_INFO_WINDOWS 5
#define V_CLOSE_ALL_GROUPS 5

void view_cb(Widget, int);
void view_meter_cb(Widget, int);

void view_hide_cb(Widget widget, int item);
void hide_ok_action(Widget w);
void hide_cancel_action(Widget w);
void hide_w_component_toggle_cb(Widget w, int type, XmToggleButtonCallbackStruct *cbs);

void initialize_open_meter_window_button(Widget w);
void initialize_update_screen_toggle(Widget w);

void toggle_update_screen(Widget w, int data, XmToggleButtonCallbackStruct *cbs);
void CloseAllComponentInformationWindows(MComponent *comp);
void close_all_info_w(Widget w);
void close_all_groups(Widget w);

MenuItem view_items[] = {
  {"Update Screen", &xmToggleButtonGadgetClass, NULL, NULL, NULL, XmNvalueChangedCallback, toggle_update_screen, (XtPointer)NULL, (MenuItem *)NULL,initialize_update_screen_toggle},
  {"",&xmSeparatorGadgetClass, NULL, NULL, NULL, NULL, NULL, NULL, (MenuItem *)NULL,NULL},
  {"Open Meter Window", &xmPushButtonGadgetClass, NULL, NULL, NULL, XmNactivateCallback, view_meter_cb, (XtPointer)V_METER_WINDOW, (MenuItem *)NULL, NULL}, 
  {"Close All Information Windows", &xmPushButtonGadgetClass, NULL, NULL, NULL, XmNactivateCallback, close_all_info_w, (XtPointer)V_CLOSE_ALL_INFO_WINDOWS, (MenuItem *)NULL, NULL},
  {"Close All Groups", &xmPushButtonGadgetClass, NULL, NULL, NULL, XmNactivateCallback, close_all_groups, (XtPointer)V_CLOSE_ALL_GROUPS, (MenuItem *)NULL, NULL},
  {"",&xmSeparatorGadgetClass, NULL, NULL, NULL, NULL, NULL, NULL, (MenuItem *)NULL,NULL},
  {"Hide", &xmPushButtonGadgetClass, NULL, NULL, NULL, XmNactivateCallback, view_hide_cb, (XtPointer)V_HIDE, (MenuItem *)NULL,NULL},
  NULL
};


/*================================================== global variables ==================================================*/
Widget hide_components=NULL;
int hide_components_window_open=0;
static unsigned num_components;

Widget *hide_components_toggles;
static unsigned long hide_components_prev_settings;

Widget hide_meters_toggle;
static unsigned int hide_meters_prev_setting;
Widget open_meter_window_button=NULL;


/*************************************************************************************************************************/
void CloseHideComponentsBox() {/* This doesn't update any changes in hide settings.  It should really only be used when
				  destroying the new network. */
   if (hide_components)
      if (hide_components_window_open) {
	 hide_components_window_open=0;
	 XtUnmanageChild(hide_components);
      }
}

/*************************************************************************************************************************/
/* Hide a given component type. */
void SetGlobalHidden(int type) { /* This only sets the value of the environment variables, it does not change the
                                    toggle buttons in the Hide Components box and it does not make components
                                    invisible. */
   if (type==TYPE_GROUP)
      return;
  if (type==TYPE_METER)
     the_environment.hide_meters = 1;
  else
     the_environment.hide_settings |= 1L<<type; 
}

/*************************************************************************************************************************/
/* Unhide a given component type. */
void SetGlobalNotHidden(int type) {/* This only sets the value of the environment variables, it does not change the
                                      toggle buttons in the Hide Components box and it does not make components
                                      visible. */
   if (type==TYPE_GROUP)
      return;
  if (type==TYPE_METER)
     the_environment.hide_meters = 0;
  else
     the_environment.hide_settings &= ~(1L<<type); 
}

/*************************************************************************************************************************/
/* Unhide everything. */
void ClearGlobalHideSettings() {
   the_environment.hide_meters=0;
   the_environment.hide_settings=0;
}

/*************************************************************************************************************************/
void initialize_update_screen_toggle(Widget w) {
   XtVaSetValues(w, XmNset, (screen_update==ON)? True : False, NULL);
}

/*************************************************************************************************************************/
void close_all_info_w(Widget w) {
   TraverseNetwork(PRE_ORDER,CloseAllComponentInformationWindows);
}

/*******************************************************************************************************************************************/
void CloseAllGroups(list *l) {
   l_elt *le;

   if (l_empty(l)) return;
   for(le=l->l_head; le!=NULL; le=le->le_next) {
      MComponent *comp;
    
      comp=(MComponent *)le->le_data;
      if (comp->type==TYPE_GROUP) {  /* Note: if the component is not a group, it won't have any group children. */
	 if (CompGroupOpen(comp)) {
	    UnselectGroupMembers(comp);
	    CloseGroup(comp);
	    if (CompInfoWindowOpen(comp))
	       SetGroupOpenCloseButton(comp);
	 } 
	 CloseAllGroups(comp->children);
      }
   }
}

/*************************************************************************************************************************/
/* The callback called by the close all group menu button. */

void close_all_groups(Widget w) {
   CloseAllGroups(network_components);
}

/*************************************************************************************************************************/
void CloseIfGroup(MComponent *comp) {
   if (comp->type==TYPE_GROUP) {
      if (CompGroupOpen(comp)) {
	 CloseGroup(comp);
      }
   }
}

/*************************************************************************************************************************/
void CloseAllComponentInformationWindows(MComponent *comp) {
   METER *meter;
   PARAM *parameter;
   int i;
   l_elt *le;

   if (CompParamWindowOpen(comp)) {
      CloseParameterWindow(comp);
   }
   if (CompInfoWindowOpen(comp)) {
      CloseInformationWindow(comp);
   }

   for (le=m_list->l_head; le!=NULL; le=le->le_next) {
      MComponent *meter_comp;
      
      parameter=(PARAM *)le->le_data;
      meter = (METER *) parameter->p_my_picture;
      meter_comp=(MComponent *)((COMPONENT *)meter->scomponent)->co_picture;
      if (comp==meter_comp && meter->info_window != NULL) {
	 CloseMeterInfoWindow(meter);	    
      }
   }
}

/*************************************************************************************************************************/
void toggle_update_screen(Widget w, int data, XmToggleButtonCallbackStruct *cbs) {
   if (cbs->set) 
      screen_update = ON;
   else
      screen_update = OFF;
}	

/*************************************************************************************************************************/
/* The callback called by the Open Meter Window button in the submenu. */

void view_meter_cb(w,item)
     Widget w;
     int item;
{
   if (the_environment.meter_window_open) {
      XRaiseWindow(the_environment.the_display, XtWindow(meter_w_shell));
   }
   else {
      XtRealizeWidget(meter_w_shell);
      the_environment.meter_window_open=TRUE;
   }
}


/****************************************************************************************************************************/
static ActionAreaItem hide_action_area[]={
  {"Ok", hide_ok_action, NULL, NULL},
  {"Cancel", hide_cancel_action, NULL, NULL}
};


/***************************************************************************************************************************/
/* The callback called by the Hide menu button. */

void view_hide_cb(Widget widget, int item) /* form to contain everything
					      row col to contain selections
					      separator
					      action_area */ 
{
  int i;
  extern Widget main_w;
  Widget row_col,action_area, toggle, separator, label;
  Position x,y;
  XmString str;

  if (!hide_components) {
    
     hide_components=XmCreateForm(network_w, "hide_components_form", NULL, 0);

    /* TITLE LINE */
    label=XtVaCreateManagedWidget("title",xmLabelWidgetClass,hide_components,				 
				XmNtopAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				XmNleftAttachment, XmATTACH_FORM,
				XmNtranslations, the_environment.move_window_translations,
				XmNuserData, hide_components,  
				NULL);

    separator=CreateSeparator(hide_components,XmDOUBLE_LINE,label);

     /* ROW COLUMN with toggle buttons. */
     row_col=XtVaCreateWidget("toggle_button_row_column",xmRowColumnWidgetClass,hide_components,
			     XmNtopAttachment, XmATTACH_WIDGET,
			     XmNtopWidget, separator,
			     XmNleftAttachment, XmATTACH_FORM,
			     XmNrightAttachment, XmATTACH_FORM,
			     NULL);
    
     for(num_components=0;component_types[num_components].class!=NULL;num_components++);
     hide_components_toggles=(Widget *)sim_malloc(sizeof(Widget)*num_components);

     for(i=0;i<num_components;i++) {
	str=XmStringCreateSimple(component_types[i].typename);
	hide_components_toggles[i]=XtVaCreateManagedWidget("toggle_button", xmToggleButtonGadgetClass, row_col,
							   XmNlabelString, str,
							   XmNalignment, XmALIGNMENT_BEGINNING,
							   XmNindicatorOn, True,
							   XmNfillOnSelect, True,
							   XmNset, (the_environment.hide_settings>>i & 0x1L)? True:False,
							   NULL);
	XmStringFree(str);
	XtAddCallback(hide_components_toggles[i], XmNvalueChangedCallback, hide_w_component_toggle_cb, (XtPointer)i);
     }
     str=XmStringCreateSimple("METERS");
     hide_meters_toggle=XtVaCreateManagedWidget("toggle_button", xmToggleButtonGadgetClass,row_col,
						XmNlabelString,str,
						XmNalignment, XmALIGNMENT_BEGINNING,
						XmNindicatorOn, True,
						XmNfillOnSelect, True,
						XmNset, (the_environment.hide_meters)? True:False,
						NULL);
     XmStringFree(str);
     XtAddCallback(hide_meters_toggle, XmNvalueChangedCallback, hide_w_component_toggle_cb, (XtPointer)TYPE_METER);
    
     XtManageChild(row_col);
    
    separator=CreateSeparator(hide_components,XmSINGLE_LINE,row_col);
    
    /* ACTION AREA */
    action_area=CreateActionArea(hide_components, hide_action_area, XtNumber(hide_action_area), 0);
    
    XtVaSetValues(action_area, 
		  XmNtopAttachment, XmATTACH_WIDGET,
		  XmNtopWidget, separator,
		  XmNleftAttachment, XmATTACH_FORM,
		  XmNrightAttachment, XmATTACH_FORM,
		  XmNbottomAttachment, XmATTACH_FORM,
		  NULL);
    
     hide_components_prev_settings=the_environment.hide_settings;
     hide_meters_prev_setting=the_environment.hide_meters;
     TraverseNetwork(PRE_ORDER,SaveVisibility);    
  }	
  else {
     if (!hide_components_window_open) { /* Set toggle switches and backup settings. */
	int i;
	for(i=0;i<num_components;i++) {
	   XtVaSetValues(hide_components_toggles[i],
			 XmNset, (the_environment.hide_settings>>i & 0x1L)? True:False,
			 NULL);
	}
	XtVaSetValues(hide_meters_toggle,
		      XmNset, (the_environment.hide_meters)? True:False,
		      NULL);
		      
	hide_components_prev_settings=the_environment.hide_settings;
	hide_meters_prev_setting=the_environment.hide_meters;
	TraverseNetwork(PRE_ORDER,SaveVisibility);    
     }
  }

  hide_components_window_open=1;

  WWTranslateCoords(scroll_w,network_w,(Position)10,(Position)10,&x,&y);
  SetWidgetCoordinates(hide_components,x,y);
  XtManageChild(hide_components);
  RaiseWidget(hide_components);
}


/**********************************************************************************************************************************************/
void hide_ok_action(Widget w) {

   TRACE("hide_ok_action");

  hide_components_window_open=0;
  XtUnmanageChild(hide_components);
}

/**********************************************************************************************************************************************/
void hide_cancel_action(Widget w) {

   TRACE("hide_cancel_action");

  TraverseNetwork(PRE_ORDER,RestoreVisibility);
  the_environment.hide_settings=hide_components_prev_settings;
  the_environment.hide_meters=hide_meters_prev_setting;
  hide_components_window_open=0;
  XtUnmanageChild(hide_components);
 }

/**********************************************************************************************************************************************/
void hide_w_component_toggle_cb(Widget w, int type, XmToggleButtonCallbackStruct *cbs)
{
  if (type==TYPE_METER) the_environment.hide_meters = ~the_environment.hide_meters;
  else the_environment.hide_settings ^= 1L<<type; 
    
  if (cbs->set) TraverseNetworkWithArguments(PRE_ORDER,MakeTypeInvisible,&type);
  else TraverseNetworkWithArguments(PRE_ORDER,MakeTypeVisible,&type);
}


/**********************************************************************************************************************************************/
void MakeTypeVisible(MComponent *comp, int *type) 
{
  if (comp->type==*type && !CompVisible(comp)) MakeVisible(comp);
}

/**********************************************************************************************************************************************/
void MakeTypeInvisible(MComponent *comp, int *type) 
{
  if (comp->type==*type && CompVisible(comp)) {
    MakeInvisible(comp);
  }
}







