/* $Id: xinit.c,v 10.1 92/10/06 23:03:42 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Eric Bull
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */
#include <Xm/Xm.h>
#include <X11/StringDefs.h>

#include "xm-main_w.h"
#include "simx.h"
#include "xm-comp_trans.h"
#include "xm-info_w.h"
#include "xm-param_w.h"
#include "xm-meters.h"
#include "xm-edit.h"
#include "comptypes.h"
#include "xm-lines.h"
#include "xm-mfile.h"

/* This file contains the xinit() routine which initializes the XMotif environment.  xinit() should be call once at startup. */

/**************************************************** Application Resources *****************************************************************/

XtResource resources[]={
  {"networkWidth", "NetworkWidth", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR,network_width), XtRImmediate, (XtPointer)1000},
  {"networkHeight", "NetworkHeight", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR,network_height),XtRImmediate, (XtPointer)1000},
  {"meterWindowWidthScalar", "MeterWindowWidthScalar", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR,meter_window_width), XtRImmediate,
      (XtPointer)15},
  {"meterWindowHeightScalar", "MeterWindowHeightScalar", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR,meter_window_height),XtRImmediate,
      (XtPointer)15},
  {"GROUP", "GroupColor", XtRPixel, sizeof(Pixel), XtOffset(ENVIRONMENT_PTR, group_color), XtRString, "green"},
  {"METER", "MeterColor", XtRPixel, sizeof(Pixel), XtOffset(ENVIRONMENT_PTR, meter_color), XtRString, "yellow"},
  {"forecolor", "ForeColor", XtRPixel, sizeof(Pixel), XtOffset(ENVIRONMENT_PTR, fore_color), XtRString, "black"},
  {"textcolor", "TextColor", XtRPixel, sizeof(Pixel), XtOffset(ENVIRONMENT_PTR, text_color), XtRString, "purple"},
  {"backgroundcolor", "BackgroundColor", XtRPixel, sizeof(Pixel), XtOffset(ENVIRONMENT_PTR, back_color), XtRString, "SkyBlue"},
  {"componentTranslations", "ComponentTranslations", XtRTranslationTable, sizeof(XtTranslations), XtOffset(ENVIRONMENT_PTR, component_translations),
      XtRString, ""},
  {"moveWindowTranslations", "MoveWindowTranslations", XtRTranslationTable, sizeof(XtTranslations),
      XtOffset(ENVIRONMENT_PTR, move_window_translations), XtRString, ""},
  {"networkWTranslations", "NetworkWTranslations", XtRTranslationTable, sizeof(XtTranslations), XtOffset(ENVIRONMENT_PTR, network_w_translations),
      XtRString, ""},
  {"createComponentTranslations", "CreateComponentTranslations", XtRTranslationTable, sizeof(XtTranslations),
      XtOffset(ENVIRONMENT_PTR, create_component_translations), XtRString, ""},
  {"meterTranslations", "MeterTranslations", XtRTranslationTable, sizeof(XtTranslations),
      XtOffset(ENVIRONMENT_PTR, meter_window_translations), XtRString, ""},
  {"meterWindowOpen", "MeterWindowOpen", XtRBoolean, sizeof(Boolean), XtOffset(ENVIRONMENT_PTR,meter_window_open), XtRString, "False"},
  {"meterXSpacing", "MeterXSpacing", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR, meter_x_spacing), XtRImmediate, (XtPointer)5},
  {"meterYSpacing", "MeterYSpacing", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR, meter_y_spacing), XtRImmediate, (XtPointer)5},
  {"meterComponentXOffset", "MeterComponentXOffset", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR, meter_component_x_offset), XtRImmediate,
      (XtPointer)20},
  {"meterComponentYOffset", "MeterComponentYOffset", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR, meter_component_y_offset), XtRImmediate,
      (XtPointer)20},
  {"meterComponentSpacing", "MeterComponentSpacing", XtRInt, sizeof(int), XtOffset(ENVIRONMENT_PTR, meter_component_spacing), XtRImmediate,
      (XtPointer)0},
  {"quitwarn", "Quitwarn", XtRBoolean, sizeof(Boolean) , XtOffset(ENVIRONMENT_PTR, quitwarn), XtRString, "on"},
  {"killwarn", "Killwarn", XtRBoolean, sizeof(Boolean) , XtOffset(ENVIRONMENT_PTR, killwarn), XtRString, "on"},
  {"draw_meter_component", "Draw_meter_component", XtRBoolean, sizeof(Boolean) , XtOffset(ENVIRONMENT_PTR, draw_meter_component), XtRString, "no"}
};



XtActionsRec actions[]={
  {"move_component",move_component},
  {"lower_component",lower_component},
  {"raise_component",raise_component},
  {"join_components",join_components},
  {"select_component",select_component},
  {"open_group",open_group},
  {"close_group",close_group},
  {"drag_component_icon",create_comp_drag_icon},
  {"open_parameter_window",open_param_w_tn},
  {"close_parameter_window",close_param_w_tn},
  {"open_close_parameter_window",open_close_param_w_tn},
  {"open_information_window",open_info_w_tn},
  {"open_close_information_window",open_close_info_w_tn},
  {"close_information_window",close_info_w_tn},
  {"move_window",move_window},
  {"raise_window",raise_window},
  {"lower_window",lower_window},
  {"rubberbox",rubberbox},
  {"make_peers",make_peer},
  {"open_meter_information_window",open_meter_info_w_tn},
  {"close_meter_information_window",close_meter_info_w_tn},
  {"open_close_meter_information_window",open_close_meter_info_w_tn},
  {"move_meter",move_meter},
  {"raise_meter",raise_meter},
  {"lower_meter",lower_meter},
  {"resize_meter",resize_meter}
};

int screen_update;

ENVIRONMENT the_environment;
XtAppContext app;	
 
/** Colors to be used for packets */
#define n_packet_colors 18 

int xinit(int argc, char **argv) {
   Dimension width,height;
   Visual *visual;
   char *color_string;
   XGCValues gcv;
   char dummy_string[30];

   main_w_shell = XtVaAppInitialize((XtAppContext *)&app,
				    (String) "mars",
				    (XrmOptionDescList)NULL,
				    (Cardinal)0,
				    (Cardinal *)&argc, 
				    (String *)argv, 
				    (String *)NULL,
				    XmNtitle, "MaRS",
				    XmNiconName, "MaRS",
				    NULL);

   XtAppAddActions(app, actions, XtNumber(actions));
   XtGetApplicationResources(main_w_shell, &the_environment, resources, XtNumber(resources), NULL, 0);

   initialize_meters();

/* Initialize the_environment */

   the_environment.the_display=XtDisplay(main_w_shell);
  
   the_environment.the_screen = DefaultScreen(the_environment.the_display);
   the_environment.the_gc = DefaultGC(the_environment.the_display,
				      the_environment.the_screen);
  
  
   visual = DefaultVisual(the_environment.the_display,
			 the_environment.the_screen);
  
  if (visual->class == StaticGray && visual->map_entries == 2)
    the_environment.monochrome = 1;
  else
    the_environment.monochrome = 0;


   XSetFunction(the_environment.the_display,
		the_environment.the_gc,
		GXcopy);
  
   XSetLineAttributes(the_environment.the_display,
		      the_environment.the_gc,
		      0,
		      LineSolid,
		      CapButt,
		      JoinMiter);

   XSetGraphicsExposures(the_environment.the_display, the_environment.the_gc,
			 TRUE);
   
   the_environment.x_center = the_environment.network_width /2;  /* This is the center of the scrollable network, not the main window. */
   the_environment.y_center = the_environment.network_height /2;
   
   the_environment.single_step = 0;
   the_environment.iconified = FALSE;
   
   initialize_colors();
   
   {
      char *font_string;
      char dummy_string[90];
      
      font_string = strcpy(dummy_string, "6x10");
      the_environment.meter_font = XLoadFont(the_environment.the_display, font_string);
      the_environment.meter_font_info = XQueryFont(the_environment.the_display, the_environment.meter_font);
   }

   the_environment.meter_info_window_entries = 11;
   the_environment.hide_settings=0;
   the_environment.hide_meters=0;
   
   screen_update = ON;
   
   XFlush(the_environment.the_display);

  /* Initialize the graphics contexts for drawing and erasing lines. */
   gcv.function=GXcopy;    /* This will be used to redraw portions of the window for exposure events. */
   gcv.foreground = the_environment.fore_color;
   gcv.background = the_environment.back_color;
   the_environment.redraw_gc=XCreateGC(the_environment.the_display,
				      XDefaultRootWindow(the_environment.the_display),
				      GCForeground|GCBackground|GCFunction, &gcv);

   gcv.function=GXcopy;
   gcv.foreground = the_environment.fore_color;
   gcv.background = the_environment.back_color;
   the_environment.draw_gc=XCreateGC(the_environment.the_display,
				     XDefaultRootWindow(the_environment.the_display),
				     GCForeground|GCBackground|GCFunction, &gcv);
                    
   gcv.function=GXcopy;
   gcv.foreground = the_environment.back_color;
   gcv.background = the_environment.fore_color;
   the_environment.erase_gc=XCreateGC(the_environment.the_display,
				      XDefaultRootWindow(the_environment.the_display),
				      GCForeground|GCBackground|GCFunction, &gcv);

   /* rubber_box_GC */
   gcv.function=GXxor;
   gcv.line_style=LineOnOffDash;
   gcv.foreground=the_environment.back_color;
   gcv.background=the_environment.fore_color;
   the_environment.rubberbox_gc=XCreateGC(the_environment.the_display,
					  XDefaultRootWindow(the_environment.the_display),
					  GCForeground|GCBackground|GCFunction|GCLineStyle, &gcv);
   
   BuildMainWindow();

   XtRealizeWidget(main_w_shell);

/* Some cleaning up that has to be done after the main window is realized. */
   SetLabelString(pause_button,"Pause");
   SetLabelString(clock_w,"0.000");

   XtVaGetValues(main_w, XmNwidth, &width, XmNheight, &height, NULL);
   the_environment.width=width;
   the_environment.height=height;

   network_segmentlist=create_segmentlist();
    
   /* network components list */
   if (!(network_components=l_create())) {
      WARNING("Failure to create network components list.");
      return(ERROR);
   }

   /* selected components list */
   if (!(selected=l_create())) {
      WARNING("Failure to create selected components list.\n");
      return(ERROR);
   }

   /* meter list */
   if (!(m_list=l_create())) {
      WARNING("Failure to create meter list.\n");
      return(ERROR);
   }

   XFlush(the_environment.the_display);
   return (OK);

}


extern int packet_colors[];
extern int num_packet_colors;
static char *pk_color_names[] = {
  "green", "#ff0000", "#ff00ff", "#8a23bc", "#00ff00", "#23238e",
  "#eaadea", "#0000ff", "#812f81", "#00ffff", "#ff7f00", "#db9370",
  "#82493e", "#ffff00", "#ffffff", "#00ff7f", "#ff007f", "#7f00ff"
};


initialize_colors()
{
  Colormap clr_map;
  XColor clr,exact_color;

  int counter;
  int num_types = 0;
  char *color_string;
  int i;

  if (the_environment.monochrome) {

    if (the_environment.reverse_video) {
      the_environment.fore_color = WhitePixel(the_environment.the_display,
                                              the_environment.the_screen);
      the_environment.back_color = BlackPixel(the_environment.the_display,
                                              the_environment.the_screen);
    } else {
      the_environment.fore_color = BlackPixel(the_environment.the_display,
                                              the_environment.the_screen);
      the_environment.back_color = WhitePixel(the_environment.the_display,
                                              the_environment.the_screen);
    }

    num_packet_colors = 1;
    packet_colors[0] = the_environment.back_color;
    the_environment.meter_color = the_environment.back_color;
    the_environment.group_color = the_environment.back_color;
    the_environment.text_color = the_environment.back_color;
    for (num_types = 0; component_types[num_types].action; num_types++)
        the_environment.component_color[num_types] = the_environment.back_color;
  } else {

     /* Allocate some colors */

    clr_map = DefaultColormap(the_environment.the_display, the_environment.the_screen);
       
    /** set up all colors to be put into packets & used in busy meters */

    num_packet_colors = n_packet_colors;
    for (i = 0; i < n_packet_colors; i++)  {
       XAllocNamedColor(the_environment.the_display, clr_map, pk_color_names[i], &clr, &exact_color);
       packet_colors[i] = clr.pixel;
    }

    /* set component colors */

    for (num_types = 0; component_types[num_types].action; ++num_types);

    for (counter = 0; counter != num_types; ++counter)
      {
	if(!(color_string = XGetDefault(the_environment.the_display, the_environment.pr_name, component_types[counter].typename)))
	   XAllocNamedColor(the_environment.the_display, clr_map, "green", &clr, &exact_color);
	else
	   XAllocNamedColor(the_environment.the_display, clr_map, color_string, &clr, &exact_color);
	the_environment.component_color[counter] = clr.pixel;
     }
 }
					
  XSetForeground(the_environment.the_display,
		 the_environment.the_gc,
		 the_environment.fore_color);

}





























