/* $Id: lcostfcn.c,v 10.1 92/10/06 23:06:48 ca Exp $ */
/*
 * MaRS Maryland Routing Simulator
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Cengiz Alaettinoglu, Klaudia Dussa-Zieger, Ibrahim Matta
 *          Systems Design and Analysis Group
 *          Department of Computer Science 
 *          University of Maryland at College Park. 
 */

#include <sys/types.h>
#include <stdio.h>
#include <math.h>
#include "sim.h"
#include "simx.h"
#include "q.h"
#include "list.h"
#include "component.h"
#include "log.h"
#include "comptypes.h"
#include "lcostfcn.h"

Lcostfcn *lcostfcn_adr;

static int create_count = 0;

static caddr_t lcostfcn_create();


caddr_t lcostfcn_action(src, g, type, pkt, arg)
     Component *src;
     register Lcostfcn *g;
     int type;
     Packet *pkt;
     caddr_t arg;
{
  caddr_t result = NULL;

  dbg_set_level(DBG_ERR);

  /* Just a big switch on type of event */
  switch (type)  {
    case EV_CREATE:
      if (!create_count) {
	 result = (caddr_t) lcostfcn_adr;
	 create_count = 1;
      }
      else
	 result = (caddr_t) NULL;
      break;

    case EV_DEL:
      create_count = 0;
      result = (caddr_t) lcostfcn_adr;

    default:
      result = (caddr_t) NULL;
      break;
    }

  return(result);
}

int make_default_lcostfcn()
{
  Lcostfcn 	*g;

  /* Memory for the component structure. */
  lcostfcn_adr = g = (Lcostfcn *)sim_malloc(sizeof(Lcostfcn));
  
  /* First things first-- copy name into the new structure. */
  strncpy(g->name, "CostFcn", 40);
  
  g->neighbors 	= l_create();	/* have to create a neighbor list */
  g->params 	= q_create();
  g->class 	= AUXILIARY_CLASS;
  g->type 	= LCOSTFCN;
  g->action 	= lcostfcn_action;
  g->menu_up 	= FALSE;

  /* Initialize the parameters */
  (void)param_init((Component *)g, "CostFcn",
	     (PFD)NULL, make_name_text, make_short_name_text,
	     (PFI)NULL,
	     0, DisplayMask, 0.0);
  
  g->link_cost_function = param_init((Component *)g,	
                 "Cost fcn 1:hndl 2:dly 3:util 4:hop",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->link_cost_function->u.i = 3;
  
  g->max_delay = param_init((Component *)g,	
                 "Delay cost fcn max delay",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->max_delay->u.i = 100000;
  
  g->min_delay = param_init((Component *)g,	
                 "Delay cost fcn min delay",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->min_delay->u.i = 10;
  
  g->slope    = param_init((Component *)g,	
                 "Slope",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->slope->u.i = 10;

  g->offset    = param_init((Component *)g,	
                 "Offset",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->offset->u.i = 0;

  g->movement_limit = param_init((Component *)g,	
                 "Cost movement limit",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->movement_limit->u.i = 1;

  g->maximum = param_init((Component *)g,	
                 "Maximum Cost",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->maximum->u.i = 10;

  g->minimum = param_init((Component *)g,	
                 "Minimum Cost",
		 int_calc, make_int_text, make_short_int_text,
		 param_input_int, 0, DisplayMask | ModifyMask, 0.0);
  g->minimum->u.i = 1;

  g->exp_filter = param_init((Component *)g,	
                 "Exp filter, coeff of new",
		 double_calc, make_double_text, make_short_double_text,
		 param_input_double, 0, DisplayMask | ModifyMask, 0.0);
  g->exp_filter->u.d = 0.5;

  return(1);
}

